/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ViewAnimator;
import com.loopeer.android.librarys.imagegroupview.NavigatorImage;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.activity.UserCameraActivity;
import com.loopeer.android.librarys.imagegroupview.adapter.ImageAdapter;
import com.loopeer.android.librarys.imagegroupview.model.Image;
import com.loopeer.android.librarys.imagegroupview.model.ImageFolder;
import com.loopeer.android.librarys.imagegroupview.utils.PermissionUtils;
import com.loopeer.android.librarys.imagegroupview.view.CustomPopupView;
import com.loopeer.android.librarys.imagegroupview.view.DividerItemImagesDecoration;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class AlbumActivity
extends AppCompatActivity
implements LoaderManager.LoaderCallbacks<Cursor>,
CustomPopupView.FolderItemSelectListener,
ImageAdapter.OnImageClickListener,
View.OnClickListener {
    private static final int LOADER_ID_FOLDER = 10001;
    public static final int ALL = 0;
    public static final int TAKE_PHOTO = 1;
    public static final int ALBUM = 2;
    private RecyclerView mRecyclerView;
    private CustomPopupView mCustomPopupWindowView;
    private ViewAnimator mViewAnimator;
    private ImageAdapter mImageAdapter;
    private List<Image> mSelectedImages;
    private int mMaxSelectedNum;
    private MenuItem mSubmitMenu;
    private TextView mTextSubmit;
    private int mImageGroupId;
    private int mAlbumType;
    private boolean mIsAvatarType;
    private int mToolbarColor;
    private int mStatusBarColor;
    private int mSubmitButtonDrawable;
    private String mToolbarTitle;
    private String mSubmitButtonTextPrefix;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_album);
        this.parseIntent();
        this.mAlbumType = this.getIntent().getIntExtra("extra_album_type", 0);
        this.mIsAvatarType = this.getIntent().getBooleanExtra("extra_is_avatar_crop", false);
        this.mSelectedImages = new ArrayList<Image>();
        this.checkPermissionToStartAlbum();
    }

    private void parseIntent() {
        Intent intent = this.getIntent();
        this.mImageGroupId = intent.getIntExtra("extra_image_group_id", 0);
        this.mMaxSelectedNum = intent.getIntExtra("extra_image_select_max_num", 0);
        this.mToolbarColor = intent.getIntExtra("Album_Activity_Options_ToolbarColor", ContextCompat.getColor((Context)this, (int)R.color.image_group_theme_primary));
        this.mStatusBarColor = intent.getIntExtra("Album_Activity_Options_StatusBarColor", ContextCompat.getColor((Context)this, (int)R.color.image_group_theme_primary_dark));
        this.mSubmitButtonDrawable = intent.getIntExtra("Album_Activity_Options_SubmitButtonDrawable", R.drawable.image_group_button_background_primary_corner_selector);
        this.mToolbarTitle = intent.getStringExtra("Album_Activity_Options_ToolbarTitle");
        this.mSubmitButtonTextPrefix = intent.getStringExtra("Album_Activity_Options_SubmitButtonTextPrefix");
        if (TextUtils.isEmpty((CharSequence)this.mToolbarTitle)) {
            this.mToolbarTitle = this.getString(R.string.toolbar_title);
        }
        if (TextUtils.isEmpty((CharSequence)this.mSubmitButtonTextPrefix)) {
            this.mSubmitButtonTextPrefix = this.getString(R.string.submit_button_text_prefix);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_image_group_submit, menu2);
        if (this.mAlbumType != 1) {
            this.updateSubmitMenu(menu2);
        }
        return true;
    }

    private void updateSubmitMenu(Menu menuItem) {
        this.mSubmitMenu = menuItem.findItem(R.id.action_submit);
        View view = this.mSubmitMenu.getActionView();
        this.mTextSubmit = (TextView)view.findViewById(R.id.text_image_submit);
        this.mTextSubmit.setBackground(ContextCompat.getDrawable((Context)this, (int)this.mSubmitButtonDrawable));
        if (this.mIsAvatarType) {
            this.mTextSubmit.setVisibility(4);
        }
        this.mTextSubmit.setOnClickListener((View.OnClickListener)this);
        this.updateSubmitText();
    }

    private void updateSubmitText() {
        this.mTextSubmit.setEnabled(this.mSelectedImages.size() > 0);
        this.mTextSubmit.setText((CharSequence)this.getSubmitText());
    }

    private String getSubmitText() {
        return this.mSelectedImages.size() == 0 ? this.getResources().getString(R.string.action_submit, new Object[]{this.mSubmitButtonTextPrefix}) : (this.mMaxSelectedNum == 0 ? this.getResources().getString(R.string.action_submit_string_no_max, new Object[]{this.mSubmitButtonTextPrefix, this.mSelectedImages.size()}) : this.getResources().getString(R.string.action_submit_string, new Object[]{this.mSubmitButtonTextPrefix, this.mSelectedImages.size(), this.mMaxSelectedNum}));
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void finishWithResult() {
        Intent intent = this.getIntent();
        intent.putExtra("extra_photos_url", this.createUrls(this.mSelectedImages));
        intent.putExtra("extra_image_group_id", this.mImageGroupId);
        this.setResult(-1, intent);
        this.finish();
    }

    private ArrayList<Image> createUrls(List<Image> selectedImages) {
        return (ArrayList)selectedImages;
    }

    private void setUpView() {
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recycler_album);
        this.mViewAnimator = (ViewAnimator)this.findViewById(R.id.view_album_animator);
        this.mCustomPopupWindowView = (CustomPopupView)this.findViewById(R.id.view_popup_folder_window);
        this.getSupportActionBar().setTitle((CharSequence)this.mToolbarTitle);
        this.getSupportActionBar().setBackgroundDrawable((Drawable)new ColorDrawable(this.mToolbarColor));
        this.setStatusBarColor(this.mStatusBarColor);
        this.setUpTextView();
        this.showProgressView();
        this.setUpRecyclerView();
    }

    @TargetApi(value=21)
    private void setStatusBarColor(@ColorInt int color2) {
        Window window;
        if (Build.VERSION.SDK_INT >= 21 && (window = this.getWindow()) != null) {
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(color2);
        }
    }

    private void setUpTextView() {
        this.mCustomPopupWindowView.setNumText(this.getString(R.string.album_all));
        this.mCustomPopupWindowView.setFolderItemSelectListener(this);
    }

    private void updateContentView(ImageFolder floder) {
        if (floder.images.size() == 0) {
            this.showEmptyView();
        } else {
            this.showContentView();
        }
        this.mImageAdapter.setAlbumType(this.mAlbumType);
        this.mImageAdapter.setIsAvatarType(this.mIsAvatarType);
        this.mImageAdapter.updateFolderImageData(floder);
        this.mRecyclerView.scrollToPosition(0);
    }

    private void showContentView() {
        this.mViewAnimator.setDisplayedChild(2);
    }

    private void showEmptyView() {
        this.mViewAnimator.setDisplayedChild(1);
    }

    private void showProgressView() {
        this.mViewAnimator.setDisplayedChild(0);
    }

    private void setUpRecyclerView() {
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, 3));
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemImagesDecoration(this.getResources().getDimensionPixelSize(R.dimen.inline_padding)));
        this.mRecyclerView.setPadding(this.getResources().getDimensionPixelSize(R.dimen.inline_padding) / 2, 0, this.getResources().getDimensionPixelSize(R.dimen.inline_padding) / 2, 0);
        this.mImageAdapter = new ImageAdapter((Context)this);
        this.mImageAdapter.setOnImageClickListener(this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mImageAdapter);
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        CursorLoader cursorLoader = new CursorLoader((Context)this, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, NavigatorImage.IMAGE_PROJECTION, null, null, NavigatorImage.IMAGE_PROJECTION[2] + " DESC");
        return cursorLoader;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        this.doParseData(data);
    }

    private void doParseData(Cursor cursor) {
        new AsyncTask<Cursor, Void, List>(){

            protected List doInBackground(Cursor ... params) {
                Cursor data = params[0];
                if (data != null) {
                    ArrayList<ImageFolder> folders = new ArrayList<ImageFolder>();
                    int count = data.getCount();
                    if (count > 0) {
                        data.moveToFirst();
                        do {
                            String path = data.getString(data.getColumnIndexOrThrow(NavigatorImage.IMAGE_PROJECTION[0]));
                            String name = data.getString(data.getColumnIndexOrThrow(NavigatorImage.IMAGE_PROJECTION[1]));
                            long dateTime = data.getLong(data.getColumnIndexOrThrow(NavigatorImage.IMAGE_PROJECTION[2]));
                            Image image = new Image(path, name, dateTime);
                            File imageFile = new File(path);
                            File folderFile = imageFile.getParentFile();
                            ImageFolder folder = new ImageFolder();
                            folder.name = folderFile.getName();
                            folder.dir = folderFile.getAbsolutePath();
                            folder.firstImagePath = path;
                            if (!folders.contains(folder)) {
                                ArrayList<Image> imageList = new ArrayList<Image>();
                                imageList.add(image);
                                ++folder.count;
                                folder.images = imageList;
                                folders.add(folder);
                                continue;
                            }
                            ImageFolder f = (ImageFolder)folders.get(folders.indexOf(folder));
                            f.images.add(image);
                            ++f.count;
                        } while (data.moveToNext());
                        return folders;
                    }
                }
                return new ArrayList();
            }

            protected void onPostExecute(List list) {
                super.onPostExecute((Object)list);
                AlbumActivity.this.mCustomPopupWindowView.updateFolderData(AlbumActivity.this.createFoldersWithAllImageFolder(list));
            }
        }.execute((Object[])new Cursor[]{cursor});
    }

    private List createFoldersWithAllImageFolder(List<ImageFolder> folders) {
        if (folders.size() > 0) {
            ImageFolder folder = new ImageFolder();
            folder.name = this.getResources().getString(R.string.album_all);
            folder.dir = null;
            folder.firstImagePath = folders.get((int)0).firstImagePath;
            int imageCount = 0;
            for (ImageFolder imageFolder : folders) {
                imageCount += imageFolder.count;
                folder.images.addAll(imageFolder.images);
            }
            folder.count = imageCount;
            folders.add(0, folder);
        }
        return folders;
    }

    public void onLoaderReset(Loader<Cursor> loader) {
    }

    @Override
    public void onFolderItemSelected(ImageFolder imageFolder) {
        this.updateContentView(imageFolder);
    }

    @Override
    public int onImageSelected(Image image, int position) {
        int index;
        if (this.mSelectedImages.contains(image)) {
            this.mSelectedImages.remove(image);
            index = 2;
        } else {
            if (this.mSelectedImages.size() == this.mMaxSelectedNum && this.mMaxSelectedNum != 0) {
                return 0;
            }
            if (this.mIsAvatarType) {
                this.startCrop(image.url);
                return 0;
            }
            image.time = System.currentTimeMillis();
            this.mSelectedImages.add(image);
            index = 1;
        }
        this.mImageAdapter.updateSelectImages(this.mSelectedImages, position);
        this.updateSubmitText();
        return index;
    }

    @Override
    public void onCameraSelected() {
        this.startCamera();
    }

    private void startCamera() {
        String SDState = Environment.getExternalStorageState();
        if (SDState.equals("mounted")) {
            ActivityCompat.startActivityForResult((Activity)this, (Intent)new Intent((Context)this, UserCameraActivity.class), (int)2003, null);
        } else {
            Toast.makeText((Context)this, (CharSequence)"\u5185\u5b58\u5361\u4e0d\u5b58\u5728", (int)0).show();
        }
    }

    private void startCrop(String url) {
        NavigatorImage.startCropActivity((Context)this, "file://" + url, true, R.color.image_group_theme_primary, R.color.image_group_theme_primary_dark);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data == null || resultCode != -1 && this.mAlbumType == 1) {
            this.finish();
        }
        if (data == null || resultCode != -1) {
            return;
        }
        switch (requestCode) {
            case 69: {
                Uri resultUri = UCrop.getOutput((Intent)data);
                if (resultUri != null) {
                    this.mSelectedImages.clear();
                    this.mSelectedImages.add(new Image(this.copyFileToDownloads(resultUri), "", System.currentTimeMillis()));
                    this.finishWithResult();
                    break;
                }
                this.finish();
                break;
            }
            default: {
                String photoTakeUrl = data.getStringExtra("extra_photo_url");
                if (requestCode == 2003 && null != photoTakeUrl) {
                    this.mSelectedImages.add(new Image(photoTakeUrl, "", System.currentTimeMillis()));
                    if (!this.mIsAvatarType) break;
                    this.startCrop(photoTakeUrl);
                    break;
                }
                this.finishWithResult();
            }
        }
    }

    private String copyFileToDownloads(Uri croppedFileUri) {
        String downloadsDirectoryPath = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getAbsolutePath();
        String filename = String.format("%d_%s", Calendar.getInstance().getTimeInMillis(), croppedFileUri.getLastPathSegment());
        File saveFile = new File(downloadsDirectoryPath, filename);
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(new File(croppedFileUri.getPath()));
            FileOutputStream outStream = new FileOutputStream(saveFile);
            FileChannel inChannel = inStream.getChannel();
            FileChannel outChannel = outStream.getChannel();
            inChannel.transferTo(0L, inChannel.size(), outChannel);
            inStream.close();
            outStream.close();
            return saveFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void onClick(View v) {
        this.finishWithResult();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.onRequestPermissionsResult((Activity)this, requestCode, grantResults);
    }

    private void startAlbumOrCamera() {
        if (this.mAlbumType != 1) {
            this.setContentView(R.layout.activity_album);
            this.setUpView();
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportLoaderManager().initLoader(10001, null, (LoaderManager.LoaderCallbacks)this);
        } else {
            this.startCamera();
        }
    }

    private void checkPermissionToStartAlbum() {
        if (!PermissionUtils.hasSelfPermissions((Context)this, NavigatorImage.PERMISSION_WRITE_STARTREQUEST)) {
            ActivityCompat.requestPermissions((Activity)this, (String[])NavigatorImage.PERMISSION_WRITE_STARTREQUEST, (int)2);
        } else if (!PermissionUtils.hasSelfPermissions((Context)this, NavigatorImage.PERMISSION_CAMERA_STARTREQUEST)) {
            ActivityCompat.requestPermissions((Activity)this, (String[])NavigatorImage.PERMISSION_CAMERA_STARTREQUEST, (int)1);
        } else {
            this.startAlbumOrCamera();
        }
    }

    public void onRequestPermissionsResult(Activity target, int requestCode, int[] grantResults) {
        switch (requestCode) {
            case 1: {
                if (PermissionUtils.getTargetSdkVersion((Context)target) < 23 && !PermissionUtils.hasSelfPermissions((Context)target, NavigatorImage.PERMISSION_CAMERA_STARTREQUEST)) {
                    this.finish();
                    return;
                }
                if (PermissionUtils.verifyPermissions(grantResults)) {
                    this.startAlbumOrCamera();
                    break;
                }
                if (!PermissionUtils.shouldShowRequestPermissionRationale(target, NavigatorImage.PERMISSION_CAMERA_STARTREQUEST)) {
                    Toast.makeText((Context)this, (int)R.string.camera_permission_setting_reject, (int)0).show();
                }
                this.finish();
                break;
            }
            case 2: {
                if (PermissionUtils.getTargetSdkVersion((Context)target) < 23 && !PermissionUtils.hasSelfPermissions((Context)target, NavigatorImage.PERMISSION_WRITE_STARTREQUEST)) {
                    this.finish();
                    return;
                }
                if (PermissionUtils.verifyPermissions(grantResults)) {
                    if (!PermissionUtils.hasSelfPermissions((Context)this, NavigatorImage.PERMISSION_CAMERA_STARTREQUEST)) {
                        ActivityCompat.requestPermissions((Activity)this, (String[])NavigatorImage.PERMISSION_CAMERA_STARTREQUEST, (int)1);
                        break;
                    }
                    this.startAlbumOrCamera();
                    break;
                }
                if (!PermissionUtils.shouldShowRequestPermissionRationale(target, NavigatorImage.PERMISSION_WRITE_STARTREQUEST)) {
                    Toast.makeText((Context)this, (int)R.string.camera_permission_setting_reject, (int)0).show();
                }
                this.finish();
                break;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AlbumType {
    }
}

