/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.utils;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import com.loopeer.android.librarys.imagegroupview.activity.AlbumActivity;

public class Album {
    private Intent mAlbumIntent;
    private final Bundle mAlbumOptionBundle;
    private Context mContext;

    public Album(Context context) {
        this.mContext = context;
        this.mAlbumIntent = new Intent();
        this.mAlbumOptionBundle = new Bundle();
    }

    public Album withOptions(Options options) {
        this.mAlbumOptionBundle.putAll(options.getOptionBundle());
        return this;
    }

    public Intent getAlbumIntent() {
        this.mAlbumIntent.setClass(this.mContext, AlbumActivity.class);
        this.mAlbumIntent.putExtras(this.mAlbumOptionBundle);
        return this.mAlbumIntent;
    }

    public Context getContext() {
        return this.mContext;
    }

    public static class Options {
        private static final String EXTRA_PREFIX = "Album_Activity_Options_";
        public static final String EXTRA_TOOL_BAR_COLOR = "Album_Activity_Options_ToolbarColor";
        public static final String EXTRA_STATUS_BAR_COLOR = "Album_Activity_Options_StatusBarColor";
        public static final String EXTRA_SUBMIT_BUTTON_DRAWABLE = "Album_Activity_Options_SubmitButtonDrawable";
        public static final String EXTRA_TOOL_BAR_TITLE = "Album_Activity_Options_ToolbarTitle";
        public static final String EXTRA_SUBMIT_BUTTON_TEXT_PREFIX = "Album_Activity_Options_SubmitButtonTextPrefix";
        private final Bundle mOptionBundle = new Bundle();

        public Bundle getOptionBundle() {
            return this.mOptionBundle;
        }

        public Options setToolBarColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_TOOL_BAR_COLOR, color2);
            return this;
        }

        public Options setStatusBarColor(@ColorInt int color2) {
            this.mOptionBundle.putInt(EXTRA_STATUS_BAR_COLOR, color2);
            return this;
        }

        public Options setSubmitButtonDrawable(@DrawableRes int drawable2) {
            this.mOptionBundle.putInt(EXTRA_SUBMIT_BUTTON_DRAWABLE, drawable2);
            return this;
        }

        public Options setToolBarTitle(String title) {
            this.mOptionBundle.putString(EXTRA_TOOL_BAR_TITLE, title);
            return this;
        }

        public Options setSubmitButtonTextPrefix(String textPrefix) {
            this.mOptionBundle.putString(EXTRA_SUBMIT_BUTTON_TEXT_PREFIX, textPrefix);
            return this;
        }
    }
}

