/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.ImageView;
import com.loopeer.android.librarys.imagegroupview.OnTabOneClickListener;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.adapter.ImagesSwitcherAdapter;
import com.loopeer.android.librarys.imagegroupview.model.ImageSwitcherWrapper;
import com.loopeer.android.librarys.imagegroupview.model.SquareImage;
import com.loopeer.android.librarys.imagegroupview.view.MutipleTouchViewPager;
import java.util.ArrayList;

public class ImageSwitcherActivity
extends AppCompatActivity
implements OnTabOneClickListener {
    private MutipleTouchViewPager pager;
    private ArrayList<ImageSwitcherWrapper> imageSwitcherWrappers;
    private ImagesSwitcherAdapter mAdapter;
    private boolean canImageDelete;
    private int currentPagerPosition;
    private int placeholderDrawable;
    private ArrayList<Integer> deletePositions;
    private ImageView btnDelete;
    private int mImageGroupId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_switcher);
        this.deletePositions = new ArrayList();
        this.parseIntent();
        this.updateView();
        this.updateData();
    }

    private void parseIntent() {
        Intent intent = this.getIntent();
        ArrayList images = intent.getParcelableArrayListExtra("image_url");
        this.setUpImageWrappers(images);
        this.mImageGroupId = intent.getIntExtra("extra_image_group_id", 0);
        this.currentPagerPosition = intent.getIntExtra("image_position", 0);
        this.canImageDelete = intent.getBooleanExtra("extra_image_delete", false);
        this.placeholderDrawable = intent.getIntExtra("extra_image_place_drawable_id", R.drawable.ic_image_default);
    }

    private void setUpImageWrappers(ArrayList<SquareImage> images) {
        this.imageSwitcherWrappers = new ArrayList();
        for (int i = 0; i < images.size(); ++i) {
            this.imageSwitcherWrappers.add(new ImageSwitcherWrapper(images.get(i), i));
        }
    }

    private void updateView() {
        this.pager = (MutipleTouchViewPager)this.findViewById(R.id.view_pager);
        this.btnDelete = (ImageView)this.findViewById(R.id.btn_delete);
        this.btnDelete.setVisibility(this.canImageDelete ? 0 : 8);
        this.btnDelete.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageSwitcherActivity.this.deleteImage();
            }
        });
        this.setUpView();
    }

    private void setUpView() {
        this.mAdapter = new ImagesSwitcherAdapter(this.getSupportFragmentManager(), this.placeholderDrawable);
        this.mAdapter.setOnTabOneClickListener(this);
        this.pager.setAdapter((PagerAdapter)this.mAdapter);
        this.pager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ImageSwitcherActivity.this.currentPagerPosition = position;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void updateData() {
        this.mAdapter.setImages(this.createShowImages());
        this.setCurrentPosition();
    }

    private ArrayList<SquareImage> createShowImages() {
        ArrayList<SquareImage> squareImages = new ArrayList<SquareImage>();
        for (ImageSwitcherWrapper imageSwitcherWrapper : this.imageSwitcherWrappers) {
            squareImages.add(imageSwitcherWrapper.squareImage);
        }
        return squareImages;
    }

    private void setCurrentPosition() {
        this.pager.setCurrentItem(this.currentPagerPosition);
    }

    private void deleteImage() {
        this.deletePositions.add(this.imageSwitcherWrappers.get((int)this.currentPagerPosition).originPosition);
        this.imageSwitcherWrappers.remove(this.currentPagerPosition);
        if (this.imageSwitcherWrappers.size() == 0) {
            this.goBackWithResult();
        } else if (this.currentPagerPosition == this.imageSwitcherWrappers.size()) {
            --this.currentPagerPosition;
            this.updateData();
        } else {
            this.updateData();
        }
    }

    public void onBackPressed() {
        this.goBackWithResult();
    }

    private void goBackWithResult() {
        Intent intent = new Intent();
        intent.putExtra("image_position", this.deletePositions);
        intent.putExtra("extra_image_group_id", this.mImageGroupId);
        this.setResult(-1, intent);
        this.finish();
    }

    @Override
    public void onTabOneClick() {
        this.goBackWithResult();
    }
}

