/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ViewAnimator;
import com.loopeer.android.librarys.imagegroupview.NavigatorImage;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.activity.UserCameraActivity;
import com.loopeer.android.librarys.imagegroupview.adapter.ImageAdapter;
import com.loopeer.android.librarys.imagegroupview.model.Image;
import com.loopeer.android.librarys.imagegroupview.model.ImageFolder;
import com.loopeer.android.librarys.imagegroupview.view.CustomPopupView;
import com.loopeer.android.librarys.imagegroupview.view.DividerItemImagesDecoration;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AlbumActivity
extends AppCompatActivity
implements LoaderManager.LoaderCallbacks<Cursor>,
CustomPopupView.FolderItemSelectListener,
ImageAdapter.OnImageClickListener,
View.OnClickListener {
    private static final int LOADER_ID_FOLDER = 10001;
    private RecyclerView mRecyclerView;
    private CustomPopupView mCustomPopupWindowView;
    private ViewAnimator mViewAnimator;
    private ImageAdapter mImageAdapter;
    private List<Image> mSelectedImages;
    private int mMaxSelectedNum;
    private MenuItem mSubmitMenu;
    private TextView mTextSubmit;
    private int mImageGroupId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_album);
        this.parseIntent();
        this.mSelectedImages = new ArrayList<Image>();
        this.setUpView();
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    private void parseIntent() {
        Intent intent = this.getIntent();
        this.mImageGroupId = intent.getIntExtra("extra_image_group_id", 0);
        this.mMaxSelectedNum = intent.getIntExtra("extra_image_select_max_num", 0);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_image_group_submit, menu2);
        this.updateSubmitMenu(menu2);
        return true;
    }

    private void updateSubmitMenu(Menu menuItem) {
        this.mSubmitMenu = menuItem.findItem(R.id.action_submit);
        View view = this.mSubmitMenu.getActionView();
        this.mTextSubmit = (TextView)view.findViewById(R.id.text_image_submit);
        this.mTextSubmit.setOnClickListener((View.OnClickListener)this);
        this.updateSubmitText();
    }

    private void updateSubmitText() {
        this.mTextSubmit.setEnabled(this.mSelectedImages.size() > 0);
        this.mTextSubmit.setText((CharSequence)this.getSubmitText());
    }

    private String getSubmitText() {
        return this.mSelectedImages.size() == 0 ? this.getResources().getString(R.string.action_submit) : (this.mMaxSelectedNum == 0 ? this.getResources().getString(R.string.action_submit_string_no_max, new Object[]{this.mSelectedImages.size()}) : this.getResources().getString(R.string.action_submit_string, new Object[]{this.mSelectedImages.size(), this.mMaxSelectedNum}));
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void finishWithResult() {
        Intent intent = this.getIntent();
        intent.putStringArrayListExtra("extra_photos_url", this.createUrls(this.mSelectedImages));
        intent.putExtra("extra_image_group_id", this.mImageGroupId);
        this.setResult(-1, intent);
        this.finish();
    }

    private ArrayList<String> createUrls(List<Image> selectedImages) {
        ArrayList<String> results = new ArrayList<String>();
        for (Image image : selectedImages) {
            results.add(image.url);
        }
        return results;
    }

    private void setUpView() {
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recycler_album);
        this.mViewAnimator = (ViewAnimator)this.findViewById(R.id.view_album_animator);
        this.mCustomPopupWindowView = (CustomPopupView)this.findViewById(R.id.view_popup_folder_window);
        this.setUpTextView();
        this.mCustomPopupWindowView.setFolderItemSelectListener(this);
        this.showProgressView();
        this.setUpRecyclerView();
    }

    private void setUpTextView() {
        this.mCustomPopupWindowView.setNumText(this.getString(R.string.album_all));
    }

    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.getSupportLoaderManager().initLoader(10001, null, (LoaderManager.LoaderCallbacks)this);
    }

    private void updateContentView(ImageFolder floder) {
        if (floder.images.size() == 0) {
            this.showEmptyView();
        } else {
            this.showContentView();
        }
        this.mImageAdapter.updateFolderImageData(floder);
        this.mRecyclerView.scrollToPosition(0);
    }

    private void showContentView() {
        this.mViewAnimator.setDisplayedChild(2);
    }

    private void showEmptyView() {
        this.mViewAnimator.setDisplayedChild(1);
    }

    private void showProgressView() {
        this.mViewAnimator.setDisplayedChild(0);
    }

    private void setUpRecyclerView() {
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, 3));
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemImagesDecoration(this.getResources().getDimensionPixelSize(R.dimen.inline_padding)));
        this.mRecyclerView.setPadding(this.getResources().getDimensionPixelSize(R.dimen.inline_padding) / 2, 0, this.getResources().getDimensionPixelSize(R.dimen.inline_padding) / 2, 0);
        this.mImageAdapter = new ImageAdapter((Context)this);
        this.mImageAdapter.setOnImageClickListener(this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mImageAdapter);
    }

    public Loader<Cursor> onCreateLoader(int id2, Bundle args) {
        CursorLoader cursorLoader = new CursorLoader((Context)this, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, NavigatorImage.IMAGE_PROJECTION, null, null, NavigatorImage.IMAGE_PROJECTION[2] + " DESC");
        return cursorLoader;
    }

    public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
        this.doParseData(data);
    }

    private void doParseData(Cursor cursor) {
        new AsyncTask<Cursor, Void, List>(){

            protected List doInBackground(Cursor ... params) {
                Cursor data = params[0];
                if (data != null) {
                    ArrayList<ImageFolder> folders = new ArrayList<ImageFolder>();
                    int count = data.getCount();
                    if (count > 0) {
                        data.moveToFirst();
                        do {
                            String path = data.getString(data.getColumnIndexOrThrow(NavigatorImage.IMAGE_PROJECTION[0]));
                            String name = data.getString(data.getColumnIndexOrThrow(NavigatorImage.IMAGE_PROJECTION[1]));
                            long dateTime = data.getLong(data.getColumnIndexOrThrow(NavigatorImage.IMAGE_PROJECTION[2]));
                            Image image = new Image(path, name, dateTime);
                            File imageFile = new File(path);
                            File folderFile = imageFile.getParentFile();
                            ImageFolder folder = new ImageFolder();
                            folder.name = folderFile.getName();
                            folder.dir = folderFile.getAbsolutePath();
                            folder.firstImagePath = path;
                            if (!folders.contains(folder)) {
                                ArrayList<Image> imageList = new ArrayList<Image>();
                                imageList.add(image);
                                ++folder.count;
                                folder.images = imageList;
                                folders.add(folder);
                                continue;
                            }
                            ImageFolder f = (ImageFolder)folders.get(folders.indexOf(folder));
                            f.images.add(image);
                            ++f.count;
                        } while (data.moveToNext());
                        return folders;
                    }
                }
                return new ArrayList();
            }

            protected void onPostExecute(List list) {
                super.onPostExecute((Object)list);
                AlbumActivity.this.mCustomPopupWindowView.updateFolderData(AlbumActivity.this.createFoldersWithAllImageFolder(list));
            }
        }.execute((Object[])new Cursor[]{cursor});
    }

    private List createFoldersWithAllImageFolder(List<ImageFolder> folders) {
        if (folders.size() > 0) {
            ImageFolder folder = new ImageFolder();
            folder.name = this.getResources().getString(R.string.album_all);
            folder.dir = null;
            folder.firstImagePath = folders.get((int)0).firstImagePath;
            int imageCount = 0;
            for (ImageFolder imageFolder : folders) {
                imageCount += imageFolder.count;
                folder.images.addAll(imageFolder.images);
            }
            folder.count = imageCount;
            folders.add(0, folder);
        }
        return folders;
    }

    public void onLoaderReset(Loader<Cursor> loader) {
    }

    @Override
    public void onFolderItemSelected(ImageFolder imageFolder) {
        this.updateContentView(imageFolder);
    }

    @Override
    public void onImageSelected(Image image) {
        if (this.mSelectedImages.contains(image)) {
            this.mSelectedImages.remove(image);
        } else {
            if (this.mSelectedImages.size() == this.mMaxSelectedNum && this.mMaxSelectedNum != 0) {
                return;
            }
            this.mSelectedImages.add(image);
        }
        this.mImageAdapter.updateSelectImages(this.mSelectedImages);
        this.updateSubmitText();
    }

    @Override
    public void onCameraSelected() {
        this.startCamera();
    }

    private void startCamera() {
        String SDState = Environment.getExternalStorageState();
        if (SDState.equals("mounted")) {
            ActivityCompat.startActivityForResult((Activity)this, (Intent)new Intent((Context)this, UserCameraActivity.class), (int)2003, null);
        } else {
            Toast.makeText((Context)this, (CharSequence)"\u5185\u5b58\u5361\u4e0d\u5b58\u5728", (int)0).show();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data == null || resultCode != -1) {
            return;
        }
        String photoTakeUrl = data.getStringExtra("extra_photo_url");
        if (requestCode == 2003 && null != photoTakeUrl) {
            this.mSelectedImages.add(new Image(photoTakeUrl));
        }
        this.finishWithResult();
    }

    public void onClick(View v) {
        this.finishWithResult();
    }
}

