/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.app.FragmentManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.facebook.drawee.view.SimpleDraweeView;
import com.loopeer.android.librarys.imagegroupview.NavigatorImage;
import com.loopeer.android.librarys.imagegroupview.OnImageClickListener;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.model.SquareImage;
import com.loopeer.android.librarys.imagegroupview.utils.DisplayUtils;
import com.loopeer.android.librarys.imagegroupview.utils.ImageGroupDisplayHelper;
import com.loopeer.android.librarys.imagegroupview.utils.ImageGroupSavedState;
import com.loopeer.android.librarys.imagegroupview.utils.ImageGroupUtils;
import com.loopeer.android.librarys.imagegroupview.view.SquareImageView;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class ImageGroupView
extends LinearLayout {
    private static final int COLUMN = 3;
    private static final int CHILD_MARGIN = 4;
    private static final int MAX_VALUE = -1;
    private LinearLayout mLayoutItem;
    private ArrayList<Integer> mPhotoViewIDs;
    private FragmentManager mManager;
    private String unionKey;
    private ImageGroupSavedState imageGroupSavedState;
    private Uri preTakePhotoUri;
    private ArrayList<SquareImage> preImage;
    private OnImageClickListener clickListener;
    private int addButtonDrawable;
    private int deleteDrawable;
    private int placeholderDrawable;
    private boolean showAddButton;
    private boolean roundAsCircle;
    private int childMargin;
    private int maxImageNum;
    private int column;

    public ImageGroupView(Context context) {
        this(context, null);
    }

    public ImageGroupView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageGroupView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initData();
        this.getAttrs(context, attrs, defStyleAttr);
        this.setUpTreeObserver();
    }

    private void initData() {
        this.setOrientation(1);
        this.mPhotoViewIDs = new ArrayList();
        this.preImage = new ArrayList();
    }

    private void getAttrs(Context context, AttributeSet attrs, int defStyleAttr) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ImageGroupView, defStyleAttr, 0);
        if (a == null) {
            return;
        }
        this.showAddButton = a.getBoolean(R.styleable.ImageGroupView_showAddButton, false);
        this.roundAsCircle = false;
        this.maxImageNum = a.getInteger(R.styleable.ImageGroupView_maxImageNum, -1);
        this.childMargin = a.getDimensionPixelSize(R.styleable.ImageGroupView_childMargin, 4);
        this.column = a.getInteger(R.styleable.ImageGroupView_column, 3);
        this.addButtonDrawable = a.getResourceId(R.styleable.ImageGroupView_addButtonDrawable, R.drawable.ic_photo_default);
        this.deleteDrawable = a.getResourceId(R.styleable.ImageGroupView_deleteDrawable, R.drawable.ic_delete);
        this.placeholderDrawable = a.getResourceId(R.styleable.ImageGroupView_imagePlaceholderDrawable, R.drawable.ic_image_default);
        a.recycle();
    }

    private void setUpTreeObserver() {
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                @TargetApi(value=16)
                public void onGlobalLayout() {
                    if (Build.VERSION.SDK_INT < 16) {
                        ImageGroupView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        ImageGroupView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    ImageGroupView.this.setPhotoBySquareImageByObserver();
                    ImageGroupView.this.restoreView();
                }
            });
        }
    }

    private void restoreView() {
        if (this.imageGroupSavedState != null && this.showAddButton) {
            this.refreshLayout(this.imageGroupSavedState.getSquarePhotos());
            this.imageGroupSavedState = null;
        }
        if (this.preTakePhotoUri != null) {
            this.refreshPhotoView(this.preTakePhotoUri);
            this.preTakePhotoUri = null;
        }
    }

    private void initLayoutItem() {
        this.addNewLayoutItemWithoutTopMargin();
        this.addPhotoView();
    }

    private void addNewLayoutItemWithTopMargin() {
        this.addNewLayoutItem(true);
    }

    private void addNewLayoutItemWithoutTopMargin() {
        this.addNewLayoutItem(false);
    }

    private void addNewLayoutItem(boolean withTopMargin) {
        this.mLayoutItem = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams lParams = new LinearLayout.LayoutParams(-1, -2);
        if (withTopMargin) {
            lParams.topMargin = this.childMargin;
        }
        this.mLayoutItem.setLayoutParams((ViewGroup.LayoutParams)lParams);
        this.addView((View)this.mLayoutItem);
    }

    private void addPhotoView() {
        SquareImageView squareImageView = new SquareImageView(this.getContext());
        squareImageView.setImageResource(this.addButtonDrawable);
        int imageViewWidth = this.getImageWidth();
        squareImageView.setWidthByParent(imageViewWidth);
        squareImageView.setPlaceholderDrawable(this.placeholderDrawable);
        squareImageView.setRoundAsCircle(this.roundAsCircle);
        FrameLayout frame = new FrameLayout(this.getContext());
        LinearLayout.LayoutParams frameParams = new LinearLayout.LayoutParams(imageViewWidth, imageViewWidth);
        frame.addView((View)squareImageView, (ViewGroup.LayoutParams)frameParams);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(imageViewWidth, imageViewWidth);
        if (this.mPhotoViewIDs.size() % this.column != 0) {
            layoutParams.leftMargin = this.childMargin;
        }
        if (this.mPhotoViewIDs.size() > 0 && this.mPhotoViewIDs.size() % this.column == 0) {
            this.addNewLayoutItemWithTopMargin();
        }
        this.mLayoutItem.addView((View)frame, (ViewGroup.LayoutParams)layoutParams);
        final int squarePhotoViewId = this.createIndex();
        squareImageView.setId(squarePhotoViewId);
        this.mPhotoViewIDs.add(squarePhotoViewId);
        squareImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SquareImageView view = (SquareImageView)v;
                if (ImageGroupView.this.isAddButton(view)) {
                    ImageGroupView.this.doPhotoClickSelectable();
                } else if (ImageGroupView.this.clickListener == null) {
                    NavigatorImage.startImageSwitcherActivity(ImageGroupView.this.getContext(), ImageGroupView.this.getSquarePhotos(), ImageGroupView.this.mPhotoViewIDs.indexOf(squarePhotoViewId), ImageGroupView.this.showAddButton, ImageGroupView.this.placeholderDrawable, ImageGroupView.this.getId());
                }
            }
        });
        squareImageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (ImageGroupView.this.canClickToDelete(v)) {
                    return true;
                }
                return true;
            }
        });
    }

    private boolean isAddButton(SquareImageView view) {
        return view.getImageLocalUrl() == null && view.getInternetUrl() == null;
    }

    private boolean canClickToDelete(View v) {
        return !this.showAddButton || ((SquareImageView)v).getImageLocalUrl() == null && ((SquareImageView)v).getInternetUrl() == null;
    }

    private int getImageWidth() {
        int width = this.getMeasuredWidth();
        if (width == 0) {
            width = DisplayUtils.getScreenWidth(this.getContext()) - this.getResources().getDimensionPixelSize(R.dimen.list_horizontal_margin) * 2;
        }
        return (width - this.childMargin * (this.column - 1) - this.getPaddingRight() - this.getPaddingLeft()) / this.column;
    }

    private void doDeletePhoto(View v) {
        final SquareImageView squarView = (SquareImageView)v;
        FrameLayout frame = (FrameLayout)squarView.getParent();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2, 53);
        ImageView image = new ImageView(this.getContext());
        image.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageGroupView.this.doPhotoDelete(squarView.getId());
            }
        });
        image.setImageResource(this.deleteDrawable);
        frame.addView((View)image, (ViewGroup.LayoutParams)layoutParams);
    }

    private void doPhotoClickSelectable() {
        this.doUpLoadPhotoClick();
    }

    private void doPhotoDelete(int photoId) {
        this.removeView(this.findViewById(photoId));
        this.mPhotoViewIDs.remove(new Integer(photoId));
        this.refreshImages();
    }

    private void refreshImages() {
        this.requestLayout();
        this.refresh();
    }

    public void showAddButton(Boolean b) {
        this.showAddButton = b;
        this.refresh();
    }

    public void showWithCircle(Boolean b) {
        this.roundAsCircle = b;
        this.refresh();
    }

    public void setRoundAsCircle(Boolean flag) {
        this.roundAsCircle = flag;
    }

    private void doPhotosDelete(ArrayList<Integer> positions) {
        if (positions == null) {
            return;
        }
        ArrayList<Integer> deleteIds = new ArrayList<Integer>();
        for (int position : positions) {
            deleteIds.add(this.mPhotoViewIDs.get(position));
        }
        for (int id : deleteIds) {
            this.removeView(this.findViewById(id));
            this.mPhotoViewIDs.remove(new Integer(id));
        }
        this.refreshImages();
    }

    private void refresh() {
        this.refreshLayout(this.getSquarePhotos());
    }

    private ArrayList<SquareImage> getSquarePhotos() {
        ArrayList<SquareImage> results = new ArrayList<SquareImage>();
        for (Integer i : this.mPhotoViewIDs) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(i);
        }
        return results;
    }

    private void refreshLayout(List<SquareImage> photos) {
        this.mPhotoViewIDs.clear();
        this.removeAllViews();
        this.initLayoutItem();
        for (int i = 0; i < photos.size(); ++i) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(this.mPhotoViewIDs.get(this.mPhotoViewIDs.size() - 1));
            squareImageView.setImageData(photos.get(i));
            if (this.showAddButton) {
                this.addPhoto(this.mPhotoViewIDs.get(this.mPhotoViewIDs.size() - 1));
                continue;
            }
            this.addPhotoWithoutButton(i, photos.size());
        }
    }

    private void doUpLoadPhotoClick() {
        NavigatorImage.startCustomAlbumActivity(this.getContext(), this.getCanSelectMaxNum(), this.getId());
    }

    private int getCanSelectMaxNum() {
        if (this.maxImageNum == -1) {
            return 0;
        }
        return this.maxImageNum - this.mPhotoViewIDs.size() + 1;
    }

    private void selectImageFromSystemAlbum() {
        Intent i = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        ((Activity)this.getContext()).startActivityForResult(i, 2001);
    }

    private void addPhoto(int viewId) {
        boolean isEndPhotoView = true;
        for (int i = 0; i < this.mPhotoViewIDs.size() - 1; ++i) {
            if (this.mPhotoViewIDs.get(i) != viewId) continue;
            isEndPhotoView = false;
        }
        if (isEndPhotoView && (this.maxImageNum == -1 || this.mPhotoViewIDs.size() < this.maxImageNum)) {
            this.addPhotoView();
        }
    }

    public void setNetworkPhotos(List<String> photos) {
        if (photos == null) {
            return;
        }
        this.preImage.clear();
        for (String url : photos) {
            this.preImage.add(new SquareImage(null, url, null, SquareImage.PhotoType.NETWORK));
        }
        this.setPhotoBySquareImage();
    }

    public void setLocalPhotos(List<String> photos) {
        if (photos == null) {
            return;
        }
        this.preImage.clear();
        for (String url : photos) {
            this.preImage.add(new SquareImage(url, null, null, SquareImage.PhotoType.LOCAL));
        }
        this.setPhotoBySquareImage();
    }

    public void setPhotosBySquareImage(List<SquareImage> photos) {
        if (photos == null) {
            return;
        }
        this.preImage.clear();
        this.preImage.addAll(photos);
        this.setPhotoBySquareImage();
    }

    public void setNetworkPhotosWithKey(ArrayList<String> urls) {
        if (urls == null) {
            return;
        }
        this.preImage.clear();
        for (String url : urls) {
            String[] headWithKey = url.split("/");
            this.preImage.add(new SquareImage(null, url, headWithKey[headWithKey.length - 1], SquareImage.PhotoType.NETWORK));
        }
        this.setPhotoBySquareImage();
    }

    private void setPhotoBySquareImageByObserver() {
        this.setPhotoBySquareImage();
        if (this.mPhotoViewIDs.size() > 0) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(this.mPhotoViewIDs.get(this.mPhotoViewIDs.size() - 1));
            squareImageView.requestLayout();
            squareImageView.invalidate();
        }
    }

    private void setPhotoBySquareImage() {
        if (this.showAddButton) {
            this.setSquareImagesWithButton(this.preImage);
        } else {
            this.setSquareImagesWithoutButton(this.preImage);
        }
    }

    private void setSquareImagesWithButton(ArrayList<SquareImage> photos) {
        this.removeAllViews();
        this.mPhotoViewIDs.clear();
        this.initLayoutItem();
        int size = photos != null ? photos.size() : 0;
        for (int i = 0; i < size; ++i) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(this.mPhotoViewIDs.get(this.mPhotoViewIDs.size() - 1));
            squareImageView.setImageData(photos.get(i));
            this.addPhoto(this.mPhotoViewIDs.get(this.mPhotoViewIDs.size() - 1));
        }
    }

    private void setSquareImagesWithoutButton(ArrayList<SquareImage> photos) {
        this.removeAllViews();
        this.mPhotoViewIDs.clear();
        this.initLayoutItem();
        int size = photos != null ? photos.size() : 0;
        for (int i = 0; i < size; ++i) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(this.mPhotoViewIDs.get(i));
            squareImageView.setImageData(photos.get(i));
            this.addPhotoWithoutButton(i, size);
        }
    }

    private void addPhotoWithoutButton(int position, int size) {
        if (position != size - 1) {
            this.addPhotoView();
        }
    }

    public ArrayList<String> getLocalUrls() {
        ArrayList<String> map = new ArrayList<String>();
        for (Integer i : this.mPhotoViewIDs) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(i);
            if (!TextUtils.isEmpty((CharSequence)squareImageView.getInternetUrl()) || TextUtils.isEmpty((CharSequence)squareImageView.getLocalUrl())) continue;
            map.add(squareImageView.getLocalUrl());
        }
        return map;
    }

    public ArrayList<String> getInternetUrls() {
        ArrayList<String> photos = new ArrayList<String>();
        for (Integer i : this.mPhotoViewIDs) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(i);
            if (TextUtils.isEmpty((CharSequence)squareImageView.getInternetUrl())) continue;
            photos.add(squareImageView.getInternetUrl());
        }
        return photos;
    }

    public boolean isEmpty() {
        boolean empty = true;
        for (Integer i : this.mPhotoViewIDs) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(i);
            if (squareImageView.getUploadImageKey() == null) continue;
            empty = false;
        }
        return empty;
    }

    public SquareImageView findFirstSquareView() {
        return (SquareImageView)this.findViewById(this.mPhotoViewIDs.get(0));
    }

    public void setFragmentManager(FragmentManager manager) {
        this.mManager = manager;
    }

    public void setUnionKey(String key) {
        this.unionKey = key;
    }

    private int createIndex() {
        long time = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("mmss");
        String date = sdf.format(new Date(time));
        int num1 = Integer.valueOf(date + Long.toString(time % 1000L));
        int i = num1 * 10 + this.mPhotoViewIDs.size();
        return i;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        ImageGroupSavedState imageSaveState = new ImageGroupSavedState(parcelable);
        imageSaveState.setSquarePhotos(this.getSquarePhotos());
        return imageSaveState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof ImageGroupSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        ImageGroupSavedState ss = (ImageGroupSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.imageGroupSavedState = ss;
    }

    public void onParentResult(int requestCode, Intent data) {
        ArrayList images = data.getStringArrayListExtra("extra_photos_url");
        ArrayList positions = data.getIntegerArrayListExtra("image_position");
        if (requestCode == 2004 && null != positions) {
            this.doPhotosDelete(positions);
        } else if (requestCode == 2005 && null != images) {
            this.doSelectPhotos(images);
        }
    }

    private void doSelectPhotos(List<String> images) {
        for (String url : images) {
            this.doSelectPhotosByUrl(url);
        }
    }

    private void doSelectPhotosByUrl(String url) {
        this.refreshPhotoView(url);
    }

    private void refreshPhotoView(String url) {
        SquareImageView squarePhotoView = (SquareImageView)this.findViewById(this.mPhotoViewIDs.get(this.mPhotoViewIDs.size() - 1));
        ImageGroupDisplayHelper.displayImageLocal((SimpleDraweeView)squarePhotoView, url, 200, 200);
        squarePhotoView.setFocusable(true);
        squarePhotoView.setFocusableInTouchMode(true);
        squarePhotoView.requestFocus();
        squarePhotoView.setLocalUrl(url);
        squarePhotoView.setUploadKey("image_" + this.unionKey + "_" + System.currentTimeMillis());
        this.addPhoto(squarePhotoView.getId());
    }

    private void refreshPhotoView(Uri uri) {
        if (this.imageGroupSavedState != null) {
            this.preTakePhotoUri = uri;
            return;
        }
        this.preTakePhotoUri = null;
        SquareImageView squarePhotoView = (SquareImageView)this.findViewById(this.mPhotoViewIDs.get(this.mPhotoViewIDs.size() - 1));
        ImageGroupDisplayHelper.displayImage((SimpleDraweeView)squarePhotoView, uri, 200, 200);
        squarePhotoView.setFocusable(true);
        squarePhotoView.setFocusableInTouchMode(true);
        squarePhotoView.requestFocus();
        squarePhotoView.setLocalUrl(ImageGroupUtils.getPathOfPhotoByUri(this.getContext(), uri));
        squarePhotoView.setUploadKey("image_" + this.unionKey + "_" + System.currentTimeMillis());
        this.addPhoto(squarePhotoView.getId());
    }

    public HashMap<String, String> getUploadImageUrlKeys() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Integer i : this.mPhotoViewIDs) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(i);
            if (!TextUtils.isEmpty((CharSequence)squareImageView.getInternetUrl()) || TextUtils.isEmpty((CharSequence)squareImageView.getLocalUrl())) continue;
            map.put(squareImageView.getUploadImageKey(), squareImageView.getLocalUrl());
        }
        return map;
    }

    public ArrayList<String> getImageKeys() {
        ArrayList<String> map = new ArrayList<String>();
        for (Integer i : this.mPhotoViewIDs) {
            SquareImageView squareImageView = (SquareImageView)this.findViewById(i);
            if (TextUtils.isEmpty((CharSequence)squareImageView.getInternetUrl()) && TextUtils.isEmpty((CharSequence)squareImageView.getLocalUrl())) continue;
            map.add(squareImageView.getUploadImageKey());
        }
        return map;
    }

    public String getImageKeyString() {
        ArrayList<String> keys = this.getImageKeys();
        if (keys.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String key : keys) {
            sb.append(key);
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void setOnImageClickListener(OnImageClickListener listener) {
        this.clickListener = listener;
    }
}

