/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.facebook.drawee.view.SimpleDraweeView;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.adapter.RecyclerViewAdapter;
import com.loopeer.android.librarys.imagegroupview.model.Image;
import com.loopeer.android.librarys.imagegroupview.model.ImageFolder;
import com.loopeer.android.librarys.imagegroupview.utils.ImageDisplayHelper;
import java.util.ArrayList;
import java.util.List;

public class ImageAdapter
extends RecyclerViewAdapter<Image> {
    private static final int ITEM_CAMERA = 10000;
    private static final int ITEM_IMAMGE = 10001;
    private OnImageClickListener mOnImageClickListener;
    private List<Image> mSelectImages = new ArrayList<Image>();

    public ImageAdapter(Context context) {
        super(context);
    }

    public void setOnImageClickListener(OnImageClickListener listener) {
        this.mOnImageClickListener = listener;
    }

    @Override
    public void bindView(final Image product, int i, RecyclerView.ViewHolder viewHolder) {
        RecyclerView.ViewHolder productViewHolder;
        if (viewHolder instanceof ImageViewHolder) {
            productViewHolder = (ImageViewHolder)viewHolder;
            productViewHolder.bind(product);
            productViewHolder.container.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ImageAdapter.this.mOnImageClickListener.onImageSelected(product);
                }
            });
            productViewHolder.itemView.setSelected(this.isImageSelected(product));
        }
        if (viewHolder instanceof CameraViewHolder) {
            productViewHolder = (CameraViewHolder)viewHolder;
            productViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ImageAdapter.this.mOnImageClickListener.onCameraSelected();
                }
            });
        }
    }

    private boolean isImageSelected(Image product) {
        return this.mSelectImages.contains(product);
    }

    public void updateFolderImageData(ImageFolder imageFolder) {
        ArrayList<Image> images = new ArrayList<Image>();
        images.addAll(imageFolder.images);
        if (TextUtils.isEmpty((CharSequence)imageFolder.dir)) {
            images.add(0, null);
        }
        this.updateData(images);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int i) {
        LayoutInflater inflater = this.getLayoutInflater();
        switch (i) {
            case 10000: {
                View view = inflater.inflate(R.layout.list_item_camera, parent, false);
                return new CameraViewHolder(view);
            }
        }
        View view = inflater.inflate(R.layout.list_item_image, parent, false);
        return new ImageViewHolder(view);
    }

    public int getItemViewType(int position) {
        if (this.getItem(position) == null) {
            return 10000;
        }
        return 10001;
    }

    public void updateSelectImages(List<Image> selectedImages) {
        this.mSelectImages.clear();
        this.mSelectImages.addAll(selectedImages);
        this.notifyDataSetChanged();
    }

    public static interface OnImageClickListener {
        public void onImageSelected(Image var1);

        public void onCameraSelected();
    }

    static class CameraViewHolder
    extends RecyclerView.ViewHolder {
        public CameraViewHolder(View itemView) {
            super(itemView);
            int screenWidth = itemView.getResources().getDisplayMetrics().widthPixels;
            int parentMargin = itemView.getResources().getDimensionPixelSize(R.dimen.inline_padding);
            int width = (screenWidth - parentMargin * 4) / 3;
            ViewGroup.LayoutParams layoutParams = itemView.getLayoutParams();
            layoutParams.height = width;
            layoutParams.width = width;
            itemView.setLayoutParams(layoutParams);
        }
    }

    static class ImageViewHolder
    extends RecyclerView.ViewHolder {
        SimpleDraweeView icon;
        FrameLayout container;

        public ImageViewHolder(View itemView) {
            super(itemView);
            this.icon = (SimpleDraweeView)itemView.findViewById(16908294);
            this.container = (FrameLayout)itemView.findViewById(R.id.container);
            int screenWidth = itemView.getResources().getDisplayMetrics().widthPixels;
            int parentMargin = itemView.getResources().getDimensionPixelSize(R.dimen.inline_padding);
            int width = (screenWidth - parentMargin * 4) / 3;
            ViewGroup.LayoutParams layoutParams = this.icon.getLayoutParams();
            layoutParams.height = width;
            layoutParams.width = width;
            this.icon.setLayoutParams(layoutParams);
        }

        public void bind(Image image) {
            ImageDisplayHelper.displayImageLocal(this.icon, image.url, 200, 200);
        }
    }
}

