/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.shadow;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.loopeer.shadow.R;
import com.loopeer.shadow.ShapeUtils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b.\u0018\u00002\u00020\u0001:\u0002\u0085\u0001B'\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010G\u001a\u00020)2\u0006\u0010H\u001a\u00020IH\u0014J\u0012\u0010J\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\u0010\u0010N\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010MJ\u0018\u0010O\u001a\u00020K2\u0006\u0010P\u001a\u00020\u00152\u0006\u0010Q\u001a\u00020\u0015H\u0016J\b\u0010R\u001a\u00020KH\u0014J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u0005H\u0016J\u0010\u0010S\u001a\u00020I2\u0006\u0010V\u001a\u00020IH\u0014J\b\u0010W\u001a\u00020XH\u0016J\n\u0010Y\u001a\u0004\u0018\u00010'H\u0016J\b\u0010Z\u001a\u00020\u0007H\u0016J\b\u0010[\u001a\u00020\u0007H\u0002J\u0006\u0010\\\u001a\u00020\u0007J\u0006\u0010]\u001a\u00020\u0007J\b\u0010^\u001a\u00020\u0007H\u0002J\b\u0010_\u001a\u00020\u0015H\u0002J\b\u0010`\u001a\u00020KH\u0016J0\u0010a\u001a\u00020K2\u0006\u0010b\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u00072\u0006\u0010f\u001a\u00020)H\u0002J\u0012\u0010g\u001a\u00020K2\b\u0010L\u001a\u0004\u0018\u00010MH\u0014J0\u0010h\u001a\u00020K2\u0006\u0010i\u001a\u00020)2\u0006\u0010b\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u0007H\u0014J\u0018\u0010j\u001a\u00020K2\u0006\u0010k\u001a\u00020\u00072\u0006\u0010l\u001a\u00020\u0007H\u0014J(\u0010m\u001a\u00020K2\u0006\u0010n\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\u00072\u0006\u0010p\u001a\u00020\u00072\u0006\u0010q\u001a\u00020\u0007H\u0014J&\u0010r\u001a\u00020K2\u0006\u0010s\u001a\u00020\u00152\u0006\u0010t\u001a\u00020\u00152\u0006\u0010u\u001a\u00020\u00152\u0006\u0010v\u001a\u00020\u0015J\u0012\u0010w\u001a\u00020K2\b\u0010x\u001a\u0004\u0018\u00010'H\u0016J\u0010\u0010y\u001a\u00020K2\u0006\u0010z\u001a\u00020\u0007H\u0016J&\u0010{\u001a\u00020K2\u0006\u0010b\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u00072\u0006\u0010e\u001a\u00020\u0007J\b\u0010|\u001a\u00020)H\u0016J\b\u0010}\u001a\u00020KH\u0002J\b\u0010~\u001a\u00020KH\u0002J+\u0010~\u001a\u00020K2\u0006\u0010\u007f\u001a\u00020\u00152\u0007\u0010\u0080\u0001\u001a\u00020\u00152\u0007\u0010\u0081\u0001\u001a\u00020\u00152\u0007\u0010\u0082\u0001\u001a\u00020\u0007H\u0002J\u0012\u0010\u0083\u0001\u001a\u00020)2\u0007\u0010\u0084\u0001\u001a\u00020'H\u0014R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R$\u0010#\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u000f\"\u0004\b%\u0010\u0011R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010/\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000f\"\u0004\b1\u0010\u0011R$\u00102\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0017\"\u0004\b4\u0010\u0019R$\u00105\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0017\"\u0004\b7\u0010\u0019R$\u00108\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u000f\"\u0004\b:\u0010\u0011R$\u0010;\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u000f\"\u0004\b=\u0010\u0011R$\u0010>\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u000f\"\u0004\b@\u0010\u0011R$\u0010A\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u000f\"\u0004\bC\u0010\u0011R&\u0010D\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\u0017\"\u0004\bF\u0010\u0019\u00a8\u0006\u0086\u0001"}, d2={"Lcom/loopeer/shadow/ShadowView;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "defStyleInt", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DEFAULT_CHILD_GRAVITY", "SIZE_DEFAULT", "SIZE_UNSET", "value", "backgroundClr", "getBackgroundClr", "()I", "setBackgroundClr", "(I)V", "bgPaint", "Landroid/graphics/Paint;", "cornerRadiusBL", "", "getCornerRadiusBL", "()F", "setCornerRadiusBL", "(F)V", "cornerRadiusBR", "getCornerRadiusBR", "setCornerRadiusBR", "cornerRadiusTL", "getCornerRadiusTL", "setCornerRadiusTL", "cornerRadiusTR", "getCornerRadiusTR", "setCornerRadiusTR", "foregroundColor", "getForegroundColor", "setForegroundColor", "foregroundDraw", "Landroid/graphics/drawable/Drawable;", "foregroundDrawBoundsChanged", "", "foregroundDrawGravity", "foregroundDrawInPadding", "overlayBounds", "Landroid/graphics/Rect;", "selfBounds", "shadowColor", "getShadowColor", "setShadowColor", "shadowDx", "getShadowDx", "setShadowDx", "shadowDy", "getShadowDy", "setShadowDy", "shadowMarginBottom", "getShadowMarginBottom", "setShadowMarginBottom", "shadowMarginLeft", "getShadowMarginLeft", "setShadowMarginLeft", "shadowMarginRight", "getShadowMarginRight", "setShadowMarginRight", "shadowMarginTop", "getShadowMarginTop", "setShadowMarginTop", "shadowRadius", "getShadowRadius", "setShadowRadius", "checkLayoutParams", "p", "Landroid/view/ViewGroup$LayoutParams;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "drawForeground", "drawableHotspotChanged", "x", "y", "drawableStateChanged", "generateLayoutParams", "Lcom/loopeer/shadow/ShadowView$LayoutParams;", "attrs", "lp", "getAccessibilityClassName", "", "getForeground", "getForegroundGravity", "getPaddingBottomWithForeground", "getPaddingLeftWithForeground", "getPaddingRightWithForeground", "getPaddingTopWithForeground", "getShadowMarginMax", "jumpDrawablesToCurrentState", "layoutChildren", "left", "top", "right", "bottom", "forceLeftGravity", "onDraw", "onLayout", "changed", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "setCornerRadius", "tl", "tr", "br", "bl", "setForeground", "drawable", "setForegroundGravity", "foregroundGravity", "setShadowMargin", "shouldDelayChildPressedState", "updateForegroundColor", "updatePaintShadow", "radius", "dx", "dy", "color", "verifyDrawable", "who", "LayoutParams", "shadow_release"})
public final class ShadowView
extends ViewGroup {
    private final int DEFAULT_CHILD_GRAVITY = 0x800033;
    private int SIZE_UNSET;
    private int SIZE_DEFAULT;
    private Drawable foregroundDraw;
    private final Rect selfBounds;
    private final Rect overlayBounds;
    private int foregroundDrawGravity;
    private boolean foregroundDrawInPadding;
    private boolean foregroundDrawBoundsChanged;
    private final Paint bgPaint;
    private int shadowColor;
    private int foregroundColor;
    private int backgroundClr;
    private float shadowRadius;
    private float shadowDx;
    private float shadowDy;
    private float cornerRadiusTL;
    private float cornerRadiusTR;
    private float cornerRadiusBL;
    private float cornerRadiusBR;
    private int shadowMarginTop;
    private int shadowMarginLeft;
    private int shadowMarginRight;
    private int shadowMarginBottom;
    private HashMap _$_findViewCache;

    public final int getShadowColor() {
        return this.shadowColor;
    }

    public final void setShadowColor(int value) {
        this.shadowColor = value;
        this.updatePaintShadow(this.getShadowRadius(), this.shadowDx, this.shadowDy, value);
    }

    public final int getForegroundColor() {
        return this.foregroundColor;
    }

    public final void setForegroundColor(int value) {
        this.foregroundColor = value;
        this.updateForegroundColor();
    }

    public final int getBackgroundClr() {
        return this.backgroundClr;
    }

    public final void setBackgroundClr(int value) {
        this.backgroundClr = value;
        this.bgPaint.setColor(value);
        this.invalidate();
    }

    public final float getShadowRadius() {
        return this.shadowRadius > this.getShadowMarginMax() && this.getShadowMarginMax() != 0.0f ? this.getShadowMarginMax() : this.shadowRadius;
    }

    public final void setShadowRadius(float value) {
        float v = value;
        if (v > this.getShadowMarginMax() && this.getShadowMarginMax() != 0.0f) {
            v = this.getShadowMarginMax();
        }
        this.shadowRadius = value;
        this.updatePaintShadow(v, this.shadowDx, this.shadowDy, this.shadowColor);
    }

    public final float getShadowDx() {
        return this.shadowDx;
    }

    public final void setShadowDx(float value) {
        this.shadowDx = value;
        this.updatePaintShadow(this.getShadowRadius(), value, this.shadowDy, this.shadowColor);
    }

    public final float getShadowDy() {
        return this.shadowDy;
    }

    public final void setShadowDy(float value) {
        this.shadowDy = value;
        this.updatePaintShadow(this.getShadowRadius(), this.shadowDx, value, this.shadowColor);
    }

    public final float getCornerRadiusTL() {
        return this.cornerRadiusTL;
    }

    public final void setCornerRadiusTL(float f) {
        this.cornerRadiusTL = f;
    }

    public final float getCornerRadiusTR() {
        return this.cornerRadiusTR;
    }

    public final void setCornerRadiusTR(float f) {
        this.cornerRadiusTR = f;
    }

    public final float getCornerRadiusBL() {
        return this.cornerRadiusBL;
    }

    public final void setCornerRadiusBL(float f) {
        this.cornerRadiusBL = f;
    }

    public final float getCornerRadiusBR() {
        return this.cornerRadiusBR;
    }

    public final void setCornerRadiusBR(float f) {
        this.cornerRadiusBR = f;
    }

    public final int getShadowMarginTop() {
        return this.shadowMarginTop;
    }

    public final void setShadowMarginTop(int value) {
        this.shadowMarginTop = value;
        this.updatePaintShadow();
    }

    public final int getShadowMarginLeft() {
        return this.shadowMarginLeft;
    }

    public final void setShadowMarginLeft(int value) {
        this.shadowMarginLeft = value;
        this.updatePaintShadow();
    }

    public final int getShadowMarginRight() {
        return this.shadowMarginRight;
    }

    public final void setShadowMarginRight(int value) {
        this.shadowMarginRight = value;
        this.updatePaintShadow();
    }

    public final int getShadowMarginBottom() {
        return this.shadowMarginBottom;
    }

    public final void setShadowMarginBottom(int value) {
        this.shadowMarginBottom = value;
        this.updatePaintShadow();
    }

    private final void updatePaintShadow() {
        this.updatePaintShadow(this.getShadowRadius(), this.shadowDx, this.shadowDy, this.shadowColor);
    }

    private final void updatePaintShadow(float radius, float dx, float dy, int color) {
        this.bgPaint.setShadowLayer(radius, dx, dy, color);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View child;
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        this.setMeasuredDimension(ViewGroup.getDefaultSize((int)0, (int)widthMeasureSpec), ViewGroup.getDefaultSize((int)0, (int)heightMeasureSpec));
        boolean shadowMeasureWidthMatchParent = this.getLayoutParams().width == -1;
        boolean shadowMeasureHeightMatchParent = this.getLayoutParams().height == -1;
        int widthSpec = widthMeasureSpec;
        if (shadowMeasureWidthMatchParent) {
            int childWidthSize = this.getMeasuredWidth() - this.shadowMarginRight - this.shadowMarginLeft;
            widthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)0x40000000);
        }
        int heightSpec = heightMeasureSpec;
        if (shadowMeasureHeightMatchParent) {
            int childHeightSize = this.getMeasuredHeight() - this.shadowMarginTop - this.shadowMarginBottom;
            heightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeightSize, (int)0x40000000);
        }
        View view = child = this.getChildAt(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"child");
        if (view.getVisibility() != 8) {
            this.measureChildWithMargins(child, widthSpec, 0, heightSpec, 0);
            ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.loopeer.shadow.ShadowView.LayoutParams");
            }
            LayoutParams lp = (LayoutParams)layoutParams;
            maxWidth = shadowMeasureWidthMatchParent ? Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin) : Math.max(maxWidth, child.getMeasuredWidth() + this.shadowMarginLeft + this.shadowMarginRight + lp.leftMargin + lp.rightMargin);
            maxHeight = shadowMeasureHeightMatchParent ? Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin) : Math.max(maxHeight, child.getMeasuredHeight() + this.shadowMarginTop + this.shadowMarginBottom + lp.topMargin + lp.bottomMargin);
            childState = View.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable = this.getForeground();
        if (drawable != null) {
            maxHeight = Math.max(maxHeight, drawable.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable.getMinimumWidth());
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)maxWidth, (int)(shadowMeasureWidthMatchParent ? widthMeasureSpec : widthSpec), (int)childState), View.resolveSizeAndState((int)maxHeight, (int)(shadowMeasureHeightMatchParent ? heightMeasureSpec : heightSpec), (int)(childState << 16)));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren(left, top, right, bottom, false);
        if (changed) {
            this.foregroundDrawBoundsChanged = changed;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void layoutChildren(int left, int top, int right, int bottom, boolean forceLeftGravity) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeftWithForeground();
        int parentRight = right - left - this.getPaddingRightWithForeground();
        int parentTop = this.getPaddingTopWithForeground();
        int parentBottom = bottom - top - this.getPaddingBottomWithForeground();
        int n = 0;
        int n2 = count - 1;
        if (n <= n2) {
            while (true) {
                void i;
                View child;
                View view = child = this.getChildAt((int)i);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"child");
                if (view.getVisibility() != 8) {
                    int childTop;
                    ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                    if (layoutParams == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.loopeer.shadow.ShadowView.LayoutParams");
                    }
                    LayoutParams lp = (LayoutParams)layoutParams;
                    int width = child.getMeasuredWidth();
                    int height = child.getMeasuredHeight();
                    int childLeft = 0;
                    int gravity = lp.getGravity();
                    if (gravity == -1) {
                        gravity = this.DEFAULT_CHILD_GRAVITY;
                    }
                    int layoutDirection = this.getLayoutDirection();
                    int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
                    int verticalGravity = gravity & 0x70;
                    switch (absoluteGravity & 7) {
                        case 1: {
                            childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin + this.shadowMarginLeft - this.shadowMarginRight;
                            break;
                        }
                        case 5: {
                            if (forceLeftGravity) break;
                            childLeft = parentRight - width - lp.rightMargin - this.shadowMarginRight;
                            break;
                        }
                        case 3: {
                            childLeft = parentLeft + lp.leftMargin + this.shadowMarginLeft;
                            break;
                        }
                        default: {
                            childLeft = parentLeft + lp.leftMargin + this.shadowMarginLeft;
                        }
                    }
                    switch (verticalGravity) {
                        case 48: {
                            childTop = parentTop + lp.topMargin + this.shadowMarginTop;
                            break;
                        }
                        case 16: {
                            childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin + this.shadowMarginTop - this.shadowMarginBottom;
                            break;
                        }
                        case 80: {
                            childTop = parentBottom - height - lp.bottomMargin - this.shadowMarginBottom;
                            break;
                        }
                        default: {
                            childTop = parentTop + lp.topMargin + this.shadowMarginTop;
                        }
                    }
                    child.layout(childLeft, childTop, childLeft + width, childTop + height);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    protected void onDraw(@Nullable Canvas canvas) {
        block0: {
            Canvas canvas2;
            super.onDraw(canvas);
            Canvas canvas3 = canvas;
            if (canvas3 == null) break block0;
            Canvas it = canvas2 = canvas3;
            int w = this.getMeasuredWidth();
            int h = this.getMeasuredHeight();
            Path path = ShapeUtils.INSTANCE.roundedRect(this.shadowMarginLeft, this.shadowMarginTop, w - this.shadowMarginRight, h - this.shadowMarginBottom, this.cornerRadiusTL, this.cornerRadiusTR, this.cornerRadiusBR, this.cornerRadiusBL);
            it.drawPath(path, this.bgPaint);
        }
    }

    public void draw(@Nullable Canvas canvas) {
        block0: {
            Canvas canvas2;
            super.draw(canvas);
            Canvas canvas3 = canvas;
            if (canvas3 == null) break block0;
            Canvas it = canvas2 = canvas3;
            canvas.save();
            int w = this.getMeasuredWidth();
            int h = this.getMeasuredHeight();
            Path path = ShapeUtils.INSTANCE.roundedRect(this.shadowMarginLeft, this.shadowMarginTop, w - this.shadowMarginRight, h - this.shadowMarginBottom, this.cornerRadiusTL, this.cornerRadiusTR, this.cornerRadiusBR, this.cornerRadiusBL);
            canvas.clipPath(path);
            this.drawForeground(canvas);
            canvas.restore();
        }
    }

    private final float getShadowMarginMax() {
        Integer n = ArraysKt.max((int[])new int[]{this.shadowMarginLeft, this.shadowMarginTop, this.shadowMarginRight, this.shadowMarginBottom});
        return n != null ? (float)n.intValue() : 0.0f;
    }

    public final void drawForeground(@Nullable Canvas canvas) {
        block3: {
            Drawable drawable;
            Drawable drawable2 = this.foregroundDraw;
            if (drawable2 == null) break block3;
            Drawable it = drawable = drawable2;
            if (this.foregroundDrawBoundsChanged) {
                this.foregroundDrawBoundsChanged = false;
                int w = this.getRight() - this.getLeft();
                int h = this.getBottom() - this.getTop();
                if (this.foregroundDrawInPadding) {
                    this.selfBounds.set(0, 0, w, h);
                } else {
                    this.selfBounds.set(this.getPaddingLeft(), this.getPaddingTop(), w - this.getPaddingRight(), h - this.getPaddingBottom());
                }
                Gravity.apply((int)this.foregroundDrawGravity, (int)it.getIntrinsicWidth(), (int)it.getIntrinsicHeight(), (Rect)this.selfBounds, (Rect)this.overlayBounds);
                it.setBounds(this.overlayBounds);
            }
            it.draw(canvas);
        }
    }

    @Nullable
    public Drawable getForeground() {
        return this.foregroundDraw;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.foregroundDrawBoundsChanged = true;
    }

    public int getForegroundGravity() {
        return this.foregroundDrawGravity;
    }

    public void setForegroundGravity(int foregroundGravity) {
        int foregroundGravity2 = foregroundGravity;
        if (this.foregroundDrawGravity != foregroundGravity2) {
            if ((foregroundGravity2 & 0x800007) == 0) {
                foregroundGravity2 |= 0x800003;
            }
            if ((foregroundGravity2 & 0x70) == 0) {
                foregroundGravity2 |= 0x30;
            }
            this.foregroundDrawGravity = foregroundGravity2;
            if (this.foregroundDrawGravity == 119 && this.foregroundDraw != null) {
                Rect padding = new Rect();
                Drawable drawable = this.foregroundDraw;
                if (drawable != null) {
                    drawable.getPadding(padding);
                }
            }
            this.requestLayout();
        }
    }

    protected boolean verifyDrawable(@NotNull Drawable who) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        return super.verifyDrawable(who) || who == this.foregroundDraw;
    }

    public void jumpDrawablesToCurrentState() {
        block0: {
            Drawable drawable;
            super.jumpDrawablesToCurrentState();
            Drawable drawable2 = this.foregroundDraw;
            if (drawable2 == null) break block0;
            Drawable it = drawable = drawable2;
            it.jumpToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        block0: {
            Drawable drawable;
            Drawable it;
            super.drawableStateChanged();
            Drawable drawable2 = this.foregroundDraw;
            if (drawable2 == null || (drawable2 = (it = (drawable = drawable2)).isStateful() ? drawable : null) == null) break block0;
            it = drawable = drawable2;
            it.setState(this.getDrawableState());
        }
    }

    public void setForeground(@Nullable Drawable drawable) {
        if (this.foregroundDraw != null) {
            Drawable drawable2 = this.foregroundDraw;
            if (drawable2 != null) {
                drawable2.setCallback((Drawable.Callback)null);
            }
            this.unscheduleDrawable(this.foregroundDraw);
        }
        this.foregroundDraw = drawable;
        this.updateForegroundColor();
        if (drawable != null) {
            this.setWillNotDraw(false);
            drawable.setCallback((Drawable.Callback)this);
            if (drawable.isStateful()) {
                drawable.setState(this.getDrawableState());
            }
            if (this.foregroundDrawGravity == 119) {
                Rect padding = new Rect();
                drawable.getPadding(padding);
            }
        }
        this.requestLayout();
        this.invalidate();
    }

    private final void updateForegroundColor() {
        block1: {
            block0: {
                if (Build.VERSION.SDK_INT < 21) break block0;
                RippleDrawable rippleDrawable = (RippleDrawable)this.foregroundDraw;
                if (rippleDrawable == null) break block1;
                rippleDrawable.setColor(ColorStateList.valueOf((int)this.foregroundColor));
                break block1;
            }
            Drawable drawable = this.foregroundDraw;
            if (drawable == null) break block1;
            drawable.setColorFilter(this.foregroundColor, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public void drawableHotspotChanged(float x, float y) {
        block1: {
            super.drawableHotspotChanged(x, y);
            if (Build.VERSION.SDK_INT < 21) break block1;
            Drawable drawable = this.foregroundDraw;
            if (drawable != null) {
                Drawable drawable2;
                Drawable it = drawable2 = drawable;
                it.setHotspot(x, y);
            }
        }
    }

    public final void setShadowMargin(int left, int top, int right, int bottom) {
        this.setShadowMarginLeft(left);
        this.setShadowMarginTop(top);
        this.setShadowMarginRight(right);
        this.setShadowMarginBottom(bottom);
        this.requestLayout();
        this.invalidate();
    }

    public final void setCornerRadius(float tl, float tr, float br, float bl) {
        this.cornerRadiusTL = tl;
        this.cornerRadiusTR = tr;
        this.cornerRadiusBR = br;
        this.cornerRadiusBL = bl;
        this.invalidate();
    }

    @NotNull
    public LayoutParams generateLayoutParams(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        return new LayoutParams(context, attrs);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected boolean checkLayoutParams(@NotNull ViewGroup.LayoutParams p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        return p instanceof LayoutParams;
    }

    @NotNull
    protected ViewGroup.LayoutParams generateLayoutParams(@NotNull ViewGroup.LayoutParams lp) {
        Intrinsics.checkParameterIsNotNull((Object)lp, (String)"lp");
        return (ViewGroup.LayoutParams)new LayoutParams(lp);
    }

    @NotNull
    public CharSequence getAccessibilityClassName() {
        String string = FrameLayout.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FrameLayout::class.java.name");
        return string;
    }

    public final int getPaddingLeftWithForeground() {
        return this.getPaddingLeft();
    }

    public final int getPaddingRightWithForeground() {
        return this.getPaddingRight();
    }

    private final int getPaddingTopWithForeground() {
        return this.getPaddingTop();
    }

    private final int getPaddingBottomWithForeground() {
        return this.getPaddingBottom();
    }

    @JvmOverloads
    public ShadowView(@Nullable Context context, @Nullable AttributeSet attributeSet, int defStyleInt) {
        super(context, attributeSet, defStyleInt);
        int shadowMargin;
        this.DEFAULT_CHILD_GRAVITY = 0x800033;
        this.SIZE_UNSET = -1;
        this.selfBounds = new Rect();
        this.overlayBounds = new Rect();
        this.foregroundDrawGravity = 119;
        this.foregroundDrawInPadding = true;
        this.bgPaint = new Paint();
        TypedArray a = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ShadowView, defStyleInt, 0);
        Context context2 = context;
        if (context2 == null) {
            Intrinsics.throwNpe();
        }
        this.setShadowColor(a.getColor(R.styleable.ShadowView_shadowColor, ContextCompat.getColor((Context)context2, (int)R.color.shadow_view_default_shadow_color)));
        this.setForegroundColor(a.getColor(R.styleable.ShadowView_foregroundColor, ContextCompat.getColor((Context)context, (int)R.color.shadow_view_foreground_color_dark)));
        this.setBackgroundClr(a.getColor(R.styleable.ShadowView_backgroundColor, -1));
        this.setShadowDx(a.getFloat(R.styleable.ShadowView_shadowDx, 0.0f));
        this.setShadowDy(a.getFloat(R.styleable.ShadowView_shadowDy, 1.0f));
        this.setShadowRadius(a.getDimensionPixelSize(R.styleable.ShadowView_shadowRadius, this.SIZE_DEFAULT));
        Drawable d = a.getDrawable(R.styleable.ShadowView_android_foreground);
        if (d != null) {
            this.setForeground(d);
        }
        if ((shadowMargin = a.getDimensionPixelSize(R.styleable.ShadowView_shadowMargin, this.SIZE_UNSET)) >= 0) {
            this.setShadowMarginTop(shadowMargin);
            this.setShadowMarginLeft(shadowMargin);
            this.setShadowMarginRight(shadowMargin);
            this.setShadowMarginBottom(shadowMargin);
        } else {
            this.setShadowMarginTop(a.getDimensionPixelSize(R.styleable.ShadowView_shadowMarginTop, this.SIZE_DEFAULT));
            this.setShadowMarginLeft(a.getDimensionPixelSize(R.styleable.ShadowView_shadowMarginLeft, this.SIZE_DEFAULT));
            this.setShadowMarginRight(a.getDimensionPixelSize(R.styleable.ShadowView_shadowMarginRight, this.SIZE_DEFAULT));
            this.setShadowMarginBottom(a.getDimensionPixelSize(R.styleable.ShadowView_shadowMarginBottom, this.SIZE_DEFAULT));
        }
        float cornerRadius = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadius, this.SIZE_UNSET);
        if (cornerRadius >= 0.0f) {
            this.cornerRadiusTL = cornerRadius;
            this.cornerRadiusTR = cornerRadius;
            this.cornerRadiusBL = cornerRadius;
            this.cornerRadiusBR = cornerRadius;
        } else {
            this.cornerRadiusTL = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadiusTL, this.SIZE_DEFAULT);
            this.cornerRadiusTR = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadiusTR, this.SIZE_DEFAULT);
            this.cornerRadiusBL = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadiusBL, this.SIZE_DEFAULT);
            this.cornerRadiusBR = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadiusBR, this.SIZE_DEFAULT);
        }
        a.recycle();
        this.bgPaint.setColor(this.backgroundClr);
        this.bgPaint.setAntiAlias(true);
        this.bgPaint.setStyle(Paint.Style.FILL);
        this.setLayerType(1, null);
        this.setWillNotDraw(false);
        this.setBackground(null);
    }

    @JvmOverloads
    public /* synthetic */ ShadowView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ShadowView(@Nullable Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public ShadowView(@Nullable Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/loopeer/shadow/ShadowView$LayoutParams;", "Landroid/view/ViewGroup$MarginLayoutParams;", "c", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "source", "Landroid/view/ViewGroup$LayoutParams;", "(Landroid/view/ViewGroup$LayoutParams;)V", "gravity", "", "getGravity", "()I", "setGravity", "(I)V", "Companion", "shadow_release"})
    public static final class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private int gravity;
        private static final int UNSPECIFIED_GRAVITY = -1;
        public static final Companion Companion = new Companion(null);

        public final int getGravity() {
            return this.gravity;
        }

        public final void setGravity(int n) {
            this.gravity = n;
        }

        public LayoutParams(@NotNull Context c, @Nullable AttributeSet attrs) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            super(c, attrs);
            this.gravity = Companion.getUNSPECIFIED_GRAVITY();
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ShadowView_Layout);
            this.gravity = a.getInt(R.styleable.ShadowView_Layout_layout_gravity, Companion.getUNSPECIFIED_GRAVITY());
            a.recycle();
        }

        public LayoutParams(@NotNull ViewGroup.LayoutParams source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super(source);
            this.gravity = Companion.getUNSPECIFIED_GRAVITY();
        }

        static {
            UNSPECIFIED_GRAVITY = -1;
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/loopeer/shadow/ShadowView$LayoutParams$Companion;", "", "()V", "UNSPECIFIED_GRAVITY", "", "getUNSPECIFIED_GRAVITY", "()I", "shadow_release"})
        public static final class Companion {
            public final int getUNSPECIFIED_GRAVITY() {
                return UNSPECIFIED_GRAVITY;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

