/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.shadow;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.loopeer.shadow.R;
import com.loopeer.shadow.ShapeUtils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b#\u0018\u00002\u00020\u0001:\u0001yB'\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010F\u001a\u00020(2\u0006\u0010G\u001a\u00020HH\u0014J\u0012\u0010I\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\u0010\u0010M\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010LJ\u0018\u0010N\u001a\u00020J2\u0006\u0010O\u001a\u00020\u000e2\u0006\u0010P\u001a\u00020\u000eH\u0016J\b\u0010Q\u001a\u00020JH\u0014J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u0005H\u0016J\u0010\u0010R\u001a\u00020H2\u0006\u0010U\u001a\u00020HH\u0014J\b\u0010V\u001a\u00020WH\u0016J\u0006\u0010X\u001a\u00020\u000eJ\n\u0010Y\u001a\u0004\u0018\u00010&H\u0016J\b\u0010Z\u001a\u00020\u0007H\u0016J\b\u0010[\u001a\u00020\u0007H\u0002J\u0006\u0010\\\u001a\u00020\u0007J\u0006\u0010]\u001a\u00020\u0007J\b\u0010^\u001a\u00020\u0007H\u0002J\b\u0010_\u001a\u00020JH\u0016J0\u0010`\u001a\u00020J2\u0006\u0010a\u001a\u00020\u00072\u0006\u0010b\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u00072\u0006\u0010e\u001a\u00020(H\u0002J\u0012\u0010f\u001a\u00020J2\b\u0010K\u001a\u0004\u0018\u00010LH\u0014J0\u0010g\u001a\u00020J2\u0006\u0010h\u001a\u00020(2\u0006\u0010a\u001a\u00020\u00072\u0006\u0010b\u001a\u00020\u00072\u0006\u0010c\u001a\u00020\u00072\u0006\u0010d\u001a\u00020\u0007H\u0014J\u0018\u0010i\u001a\u00020J2\u0006\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020\u0007H\u0014J(\u0010l\u001a\u00020J2\u0006\u0010m\u001a\u00020\u00072\u0006\u0010n\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\u00072\u0006\u0010p\u001a\u00020\u0007H\u0014J\u0012\u0010q\u001a\u00020J2\b\u0010r\u001a\u0004\u0018\u00010&H\u0016J\u0010\u0010s\u001a\u00020J2\u0006\u0010t\u001a\u00020\u0007H\u0016J\b\u0010u\u001a\u00020(H\u0016J\b\u0010v\u001a\u00020JH\u0002J\u0010\u0010w\u001a\u00020(2\u0006\u0010x\u001a\u00020&H\u0014R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u000e8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001c\u0010\u0016\u001a\u00020\u000e8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001c\u0010\u0019\u001a\u00020\u000e8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u001c\u0010\u001c\u001a\u00020\u000e8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R$\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00101\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\"\"\u0004\b3\u0010$R\u001a\u00104\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\"\"\u0004\b6\u0010$R\u001c\u00107\u001a\u00020\u00078FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\"\"\u0004\b9\u0010$R\u001c\u0010:\u001a\u00020\u00078FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\"\"\u0004\b<\u0010$R\u001c\u0010=\u001a\u00020\u00078FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\"\"\u0004\b?\u0010$R\u001c\u0010@\u001a\u00020\u00078FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\"\"\u0004\bB\u0010$R$\u0010C\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0010\"\u0004\bE\u0010\u0012\u00a8\u0006z"}, d2={"Lcom/loopeer/shadow/ShadowView;", "Landroid/view/ViewGroup;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "defStyleInt", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DEFAULT_CHILD_GRAVITY", "SIZE_UNSET", "bgPaint", "Landroid/graphics/Paint;", "cornerRadius", "", "getCornerRadius", "()F", "setCornerRadius", "(F)V", "cornerRadiusBL", "getCornerRadiusBL", "setCornerRadiusBL", "cornerRadiusBR", "getCornerRadiusBR", "setCornerRadiusBR", "cornerRadiusTL", "getCornerRadiusTL", "setCornerRadiusTL", "cornerRadiusTR", "getCornerRadiusTR", "setCornerRadiusTR", "value", "foregroundColor", "getForegroundColor", "()I", "setForegroundColor", "(I)V", "foregroundDraw", "Landroid/graphics/drawable/Drawable;", "foregroundDrawBoundsChanged", "", "foregroundDrawGravity", "foregroundDrawInPadding", "offset", "getOffset", "setOffset", "overlayBounds", "Landroid/graphics/Rect;", "selfBounds", "shadowColor", "getShadowColor", "setShadowColor", "shadowMargin", "getShadowMargin", "setShadowMargin", "shadowMarginBottom", "getShadowMarginBottom", "setShadowMarginBottom", "shadowMarginLeft", "getShadowMarginLeft", "setShadowMarginLeft", "shadowMarginRight", "getShadowMarginRight", "setShadowMarginRight", "shadowMarginTop", "getShadowMarginTop", "setShadowMarginTop", "shadowRadius", "getShadowRadius", "setShadowRadius", "checkLayoutParams", "p", "Landroid/view/ViewGroup$LayoutParams;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "drawForeground", "drawableHotspotChanged", "x", "y", "drawableStateChanged", "generateLayoutParams", "Lcom/loopeer/shadow/ShadowView$LayoutParams;", "attrs", "lp", "getAccessibilityClassName", "", "getCornerRadiusValue", "getForeground", "getForegroundGravity", "getPaddingBottomWithForeground", "getPaddingLeftWithForeground", "getPaddingRightWithForeground", "getPaddingTopWithForeground", "jumpDrawablesToCurrentState", "layoutChildren", "left", "top", "right", "bottom", "forceLeftGravity", "onDraw", "onLayout", "changed", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "setForeground", "drawable", "setForegroundGravity", "foregroundGravity", "shouldDelayChildPressedState", "updateForegroundColor", "verifyDrawable", "who", "LayoutParams", "shadow_release"})
public final class ShadowView
extends ViewGroup {
    private final int DEFAULT_CHILD_GRAVITY = 0x800033;
    private int SIZE_UNSET;
    private Drawable foregroundDraw;
    private final Rect selfBounds;
    private final Rect overlayBounds;
    private int foregroundDrawGravity;
    private boolean foregroundDrawInPadding;
    private boolean foregroundDrawBoundsChanged;
    private final Paint bgPaint;
    private int shadowColor;
    private int foregroundColor;
    private int offset;
    private float shadowRadius;
    private float cornerRadius;
    private float cornerRadiusTL;
    private float cornerRadiusTR;
    private float cornerRadiusBL;
    private float cornerRadiusBR;
    private int shadowMargin;
    private int shadowMarginTop;
    private int shadowMarginLeft;
    private int shadowMarginRight;
    private int shadowMarginBottom;
    private HashMap _$_findViewCache;

    public final int getShadowColor() {
        return this.shadowColor;
    }

    public final void setShadowColor(int n) {
        this.shadowColor = n;
    }

    public final int getForegroundColor() {
        return this.foregroundColor;
    }

    public final void setForegroundColor(int value) {
        this.foregroundColor = value;
        this.updateForegroundColor();
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final float getShadowRadius() {
        return this.shadowRadius;
    }

    public final void setShadowRadius(float value) {
        this.shadowRadius = value;
        this.bgPaint.setShadowLayer(value, 0.0f, 0.0f, this.shadowColor);
        this.offset = (int)value;
        this.invalidate();
    }

    public final float getCornerRadius() {
        return this.cornerRadius;
    }

    public final void setCornerRadius(float f) {
        this.cornerRadius = f;
    }

    public final float getCornerRadiusTL() {
        return this.cornerRadius > 0.0f ? this.cornerRadius : this.cornerRadiusTL;
    }

    public final void setCornerRadiusTL(float f) {
        this.cornerRadiusTL = f;
    }

    public final float getCornerRadiusTR() {
        return this.cornerRadius > 0.0f ? this.cornerRadius : this.cornerRadiusTR;
    }

    public final void setCornerRadiusTR(float f) {
        this.cornerRadiusTR = f;
    }

    public final float getCornerRadiusBL() {
        return this.cornerRadius > 0.0f ? this.cornerRadius : this.cornerRadiusBL;
    }

    public final void setCornerRadiusBL(float f) {
        this.cornerRadiusBL = f;
    }

    public final float getCornerRadiusBR() {
        return this.cornerRadius > 0.0f ? this.cornerRadius : this.cornerRadiusBR;
    }

    public final void setCornerRadiusBR(float f) {
        this.cornerRadiusBR = f;
    }

    public final int getShadowMargin() {
        return this.shadowMargin;
    }

    public final void setShadowMargin(int n) {
        this.shadowMargin = n;
    }

    public final int getShadowMarginTop() {
        return this.shadowMargin > 0 ? this.shadowMargin : this.shadowMarginTop;
    }

    public final void setShadowMarginTop(int n) {
        this.shadowMarginTop = n;
    }

    public final int getShadowMarginLeft() {
        return this.shadowMargin > 0 ? this.shadowMargin : this.shadowMarginLeft;
    }

    public final void setShadowMarginLeft(int n) {
        this.shadowMarginLeft = n;
    }

    public final int getShadowMarginRight() {
        return this.shadowMargin > 0 ? this.shadowMargin : this.shadowMarginRight;
    }

    public final void setShadowMarginRight(int n) {
        this.shadowMarginRight = n;
    }

    public final int getShadowMarginBottom() {
        return this.shadowMargin > 0 ? this.shadowMargin : this.shadowMarginBottom;
    }

    public final void setShadowMarginBottom(int n) {
        this.shadowMarginBottom = n;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View child;
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        this.setMeasuredDimension(ViewGroup.getDefaultSize((int)0, (int)widthMeasureSpec), ViewGroup.getDefaultSize((int)0, (int)heightMeasureSpec));
        boolean shadowMeasureWidthMatchParent = this.getLayoutParams().width == -1;
        boolean shadowMeasureHeightMatchParent = this.getLayoutParams().height == -1;
        int widthSpec = widthMeasureSpec;
        if (shadowMeasureWidthMatchParent) {
            int childWidthSize = this.getMeasuredWidth() - this.getShadowMarginRight() - this.getShadowMarginLeft();
            widthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)0x40000000);
        }
        int heightSpec = heightMeasureSpec;
        if (shadowMeasureHeightMatchParent) {
            int childHeightSize = this.getMeasuredHeight() - this.getShadowMarginTop() - this.getShadowMarginBottom();
            heightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeightSize, (int)0x40000000);
        }
        if ((child = this.getChildAt(0)).getVisibility() != 8) {
            this.measureChildWithMargins(child, widthSpec, 0, heightSpec, 0);
            ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.loopeer.shadow.ShadowView.LayoutParams");
            }
            LayoutParams lp = (LayoutParams)layoutParams;
            maxWidth = shadowMeasureWidthMatchParent ? Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin) : Math.max(maxWidth, child.getMeasuredWidth() + this.getShadowMarginLeft() + this.getShadowMarginRight() + lp.leftMargin + lp.rightMargin);
            maxHeight = shadowMeasureHeightMatchParent ? Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin) : Math.max(maxHeight, child.getMeasuredHeight() + this.getShadowMarginTop() + this.getShadowMarginBottom() + lp.topMargin + lp.bottomMargin);
            childState = View.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
        }
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        Drawable drawable = this.getForeground();
        if (drawable != null) {
            maxHeight = Math.max(maxHeight, drawable.getMinimumHeight());
            maxWidth = Math.max(maxWidth, drawable.getMinimumWidth());
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)maxWidth, (int)(shadowMeasureWidthMatchParent ? widthMeasureSpec : widthSpec), (int)childState), View.resolveSizeAndState((int)maxHeight, (int)(shadowMeasureHeightMatchParent ? heightMeasureSpec : heightSpec), (int)(childState << 16)));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren(left, top, right, bottom, false);
        if (changed) {
            this.foregroundDrawBoundsChanged = changed;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void layoutChildren(int left, int top, int right, int bottom, boolean forceLeftGravity) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeftWithForeground();
        int parentRight = right - left - this.getPaddingRightWithForeground();
        int parentTop = this.getPaddingTopWithForeground();
        int parentBottom = bottom - top - this.getPaddingBottomWithForeground();
        int n = 0;
        int n2 = count - 1;
        if (n <= n2) {
            while (true) {
                void i;
                View child;
                if ((child = this.getChildAt((int)i)).getVisibility() != 8) {
                    int childTop;
                    ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
                    if (layoutParams == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.loopeer.shadow.ShadowView.LayoutParams");
                    }
                    LayoutParams lp = (LayoutParams)layoutParams;
                    int width = child.getMeasuredWidth();
                    int height = child.getMeasuredHeight();
                    int childLeft = 0;
                    int gravity = lp.getGravity();
                    if (gravity == -1) {
                        gravity = this.DEFAULT_CHILD_GRAVITY;
                    }
                    int layoutDirection = this.getLayoutDirection();
                    int absoluteGravity = Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
                    int verticalGravity = gravity & 0x70;
                    switch (absoluteGravity & 7) {
                        case 1: {
                            childLeft = parentLeft + (parentRight - parentLeft - width) / 2 + lp.leftMargin - lp.rightMargin + this.getShadowMarginLeft() - this.getShadowMarginRight();
                            break;
                        }
                        case 5: {
                            if (forceLeftGravity) break;
                            childLeft = parentRight - width - lp.rightMargin - this.getShadowMarginRight();
                            break;
                        }
                        case 3: {
                            childLeft = parentLeft + lp.leftMargin + this.getShadowMarginLeft();
                            break;
                        }
                        default: {
                            childLeft = parentLeft + lp.leftMargin + this.getShadowMarginLeft();
                        }
                    }
                    switch (verticalGravity) {
                        case 48: {
                            childTop = parentTop + lp.topMargin + this.getShadowMarginTop();
                            break;
                        }
                        case 16: {
                            childTop = parentTop + (parentBottom - parentTop - height) / 2 + lp.topMargin - lp.bottomMargin + this.getShadowMarginTop() - this.getShadowMarginBottom();
                            break;
                        }
                        case 80: {
                            childTop = parentBottom - height - lp.bottomMargin - this.getShadowMarginBottom();
                            break;
                        }
                        default: {
                            childTop = parentTop + lp.topMargin + this.getShadowMarginTop();
                        }
                    }
                    child.layout(childLeft, childTop, childLeft + width, childTop + height);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    protected void onDraw(@Nullable Canvas canvas) {
        block0: {
            Canvas canvas2;
            super.onDraw(canvas);
            Canvas canvas3 = canvas;
            if (canvas3 == null) break block0;
            Canvas it = canvas2 = canvas3;
            int w = this.getMeasuredWidth();
            int h = this.getMeasuredHeight();
            Path path = ShapeUtils.INSTANCE.roundedRect(this.getShadowMarginLeft(), this.getShadowMarginTop(), w - this.getShadowMarginRight(), h - this.getShadowMarginBottom(), this.getCornerRadiusValue(), this.getCornerRadiusValue(), this.getCornerRadiusTL() > 0.0f, this.getCornerRadiusTR() > 0.0f, this.getCornerRadiusBR() > 0.0f, this.getCornerRadiusBL() > 0.0f);
            it.drawPath(path, this.bgPaint);
        }
    }

    public void draw(@Nullable Canvas canvas) {
        block0: {
            Canvas canvas2;
            super.draw(canvas);
            Canvas canvas3 = canvas;
            if (canvas3 == null) break block0;
            Canvas it = canvas2 = canvas3;
            canvas.save();
            int w = this.getMeasuredWidth();
            int h = this.getMeasuredHeight();
            Path path = ShapeUtils.INSTANCE.roundedRect(this.getShadowMarginLeft(), this.getShadowMarginTop(), w - this.getShadowMarginRight(), h - this.getShadowMarginBottom(), this.getCornerRadiusValue(), this.getCornerRadiusValue(), this.getCornerRadiusTL() > 0.0f, this.getCornerRadiusTR() > 0.0f, this.getCornerRadiusBR() > 0.0f, this.getCornerRadiusBL() > 0.0f);
            canvas.clipPath(path);
            this.drawForeground(canvas);
            canvas.restore();
        }
    }

    public final float getCornerRadiusValue() {
        Float f = ArraysKt.max((float[])new float[]{this.cornerRadius, this.getCornerRadiusTL(), this.getCornerRadiusTR(), this.getCornerRadiusBR(), this.getCornerRadiusBL()});
        return f != null ? f.floatValue() : 0.0f;
    }

    public final void drawForeground(@Nullable Canvas canvas) {
        block3: {
            Drawable drawable;
            Drawable drawable2 = this.foregroundDraw;
            if (drawable2 == null) break block3;
            Drawable it = drawable = drawable2;
            if (this.foregroundDrawBoundsChanged) {
                this.foregroundDrawBoundsChanged = false;
                int w = this.getRight() - this.getLeft();
                int h = this.getBottom() - this.getTop();
                if (this.foregroundDrawInPadding) {
                    this.selfBounds.set(0, 0, w, h);
                } else {
                    this.selfBounds.set(this.getPaddingLeft(), this.getPaddingTop(), w - this.getPaddingRight(), h - this.getPaddingBottom());
                }
                Gravity.apply((int)this.foregroundDrawGravity, (int)it.getIntrinsicWidth(), (int)it.getIntrinsicHeight(), (Rect)this.selfBounds, (Rect)this.overlayBounds);
                it.setBounds(this.overlayBounds);
            }
            it.draw(canvas);
        }
    }

    @Nullable
    public Drawable getForeground() {
        return this.foregroundDraw;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.foregroundDrawBoundsChanged = true;
    }

    public int getForegroundGravity() {
        return this.foregroundDrawGravity;
    }

    public void setForegroundGravity(int foregroundGravity) {
        int foregroundGravity2 = foregroundGravity;
        if (this.foregroundDrawGravity != foregroundGravity2) {
            if ((foregroundGravity2 & 0x800007) == 0) {
                foregroundGravity2 |= 0x800003;
            }
            if ((foregroundGravity2 & 0x70) == 0) {
                foregroundGravity2 |= 0x30;
            }
            this.foregroundDrawGravity = foregroundGravity2;
            if (this.foregroundDrawGravity == 119 && this.foregroundDraw != null) {
                Rect padding = new Rect();
                Drawable drawable = this.foregroundDraw;
                if (drawable != null) {
                    drawable.getPadding(padding);
                }
            }
            this.requestLayout();
        }
    }

    protected boolean verifyDrawable(@NotNull Drawable who) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        return super.verifyDrawable(who) || who == this.foregroundDraw;
    }

    public void jumpDrawablesToCurrentState() {
        block0: {
            Drawable drawable;
            super.jumpDrawablesToCurrentState();
            Drawable drawable2 = this.foregroundDraw;
            if (drawable2 == null) break block0;
            Drawable it = drawable = drawable2;
            it.jumpToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        block0: {
            Drawable drawable;
            Drawable it;
            super.drawableStateChanged();
            Drawable drawable2 = this.foregroundDraw;
            if (drawable2 == null || (drawable2 = (it = (drawable = drawable2)).isStateful() ? drawable : null) == null) break block0;
            it = drawable = drawable2;
            it.setState(this.getDrawableState());
        }
    }

    public void setForeground(@Nullable Drawable drawable) {
        if (this.foregroundDraw != null) {
            Drawable drawable2 = this.foregroundDraw;
            if (drawable2 != null) {
                drawable2.setCallback((Drawable.Callback)null);
            }
            this.unscheduleDrawable(this.foregroundDraw);
        }
        this.foregroundDraw = drawable;
        this.updateForegroundColor();
        if (drawable != null) {
            this.setWillNotDraw(false);
            drawable.setCallback((Drawable.Callback)this);
            if (drawable.isStateful()) {
                drawable.setState(this.getDrawableState());
            }
            if (this.foregroundDrawGravity == 119) {
                Rect padding = new Rect();
                drawable.getPadding(padding);
            }
        }
        this.requestLayout();
        this.invalidate();
    }

    private final void updateForegroundColor() {
        block1: {
            block0: {
                if (Build.VERSION.SDK_INT < 21) break block0;
                RippleDrawable rippleDrawable = (RippleDrawable)this.foregroundDraw;
                if (rippleDrawable == null) break block1;
                rippleDrawable.setColor(ColorStateList.valueOf((int)this.foregroundColor));
                break block1;
            }
            Drawable drawable = this.foregroundDraw;
            if (drawable == null) break block1;
            drawable.setColorFilter(this.foregroundColor, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public void drawableHotspotChanged(float x, float y) {
        block1: {
            super.drawableHotspotChanged(x, y);
            if (Build.VERSION.SDK_INT < 21) break block1;
            Drawable drawable = this.foregroundDraw;
            if (drawable != null) {
                Drawable drawable2;
                Drawable it = drawable2 = drawable;
                it.setHotspot(x, y);
            }
        }
    }

    @NotNull
    public LayoutParams generateLayoutParams(@NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        return new LayoutParams(context, attrs);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected boolean checkLayoutParams(@NotNull ViewGroup.LayoutParams p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        return p instanceof LayoutParams;
    }

    @NotNull
    protected ViewGroup.LayoutParams generateLayoutParams(@NotNull ViewGroup.LayoutParams lp) {
        Intrinsics.checkParameterIsNotNull((Object)lp, (String)"lp");
        return (ViewGroup.LayoutParams)new LayoutParams(lp);
    }

    @NotNull
    public CharSequence getAccessibilityClassName() {
        String string = FrameLayout.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FrameLayout::class.java.name");
        return string;
    }

    public final int getPaddingLeftWithForeground() {
        return this.getPaddingLeft();
    }

    public final int getPaddingRightWithForeground() {
        return this.getPaddingRight();
    }

    private final int getPaddingTopWithForeground() {
        return this.getPaddingTop();
    }

    private final int getPaddingBottomWithForeground() {
        return this.getPaddingBottom();
    }

    @JvmOverloads
    public ShadowView(@Nullable Context context, @Nullable AttributeSet attributeSet, int defStyleInt) {
        super(context, attributeSet, defStyleInt);
        this.DEFAULT_CHILD_GRAVITY = 0x800033;
        this.selfBounds = new Rect();
        this.overlayBounds = new Rect();
        this.foregroundDrawGravity = 119;
        this.foregroundDrawInPadding = true;
        this.bgPaint = new Paint();
        this.offset = 7;
        this.shadowRadius = 7.0f;
        this.cornerRadius = 20.0f;
        TypedArray a = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ShadowView, defStyleInt, 0);
        Drawable d = a.getDrawable(R.styleable.ShadowView_android_foreground);
        if (d != null) {
            this.setForeground(d);
        }
        this.shadowMargin = a.getDimensionPixelSize(R.styleable.ShadowView_shadowMargin, this.SIZE_UNSET);
        this.shadowMarginTop = a.getDimensionPixelSize(R.styleable.ShadowView_shadowMarginTop, this.shadowMargin);
        this.shadowMarginLeft = a.getDimensionPixelSize(R.styleable.ShadowView_shadowMarginLeft, this.shadowMargin);
        this.shadowMarginRight = a.getDimensionPixelSize(R.styleable.ShadowView_shadowMarginRight, this.shadowMargin);
        this.shadowMarginBottom = a.getDimensionPixelSize(R.styleable.ShadowView_shadowMarginBottom, this.shadowMargin);
        this.cornerRadius = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadius, this.SIZE_UNSET);
        int cornerValues = (int)this.cornerRadius;
        this.cornerRadiusTL = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadiusTL, cornerValues);
        this.cornerRadiusTR = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadiusTR, cornerValues);
        this.cornerRadiusBL = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadiusBL, cornerValues);
        this.cornerRadiusBR = a.getDimensionPixelSize(R.styleable.ShadowView_cornerRadiusBR, cornerValues);
        a.recycle();
        this.setForegroundColor(Color.parseColor((String)"#1f000000"));
        this.shadowColor = Color.parseColor((String)"#FAC4BA");
        this.bgPaint.setColor(-1);
        this.bgPaint.setAntiAlias(true);
        this.bgPaint.setStyle(Paint.Style.FILL);
        this.bgPaint.setShadowLayer(this.shadowRadius, 0.0f, 1.0f, this.shadowColor);
        this.setLayerType(1, null);
        this.setWillNotDraw(false);
    }

    @JvmOverloads
    public /* synthetic */ ShadowView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ShadowView(@Nullable Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public ShadowView(@Nullable Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0011R\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/loopeer/shadow/ShadowView$LayoutParams;", "Landroid/view/ViewGroup$MarginLayoutParams;", "c", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "width", "", "height", "(II)V", "gravity", "(III)V", "source", "Landroid/view/ViewGroup$LayoutParams;", "(Landroid/view/ViewGroup$LayoutParams;)V", "(Landroid/view/ViewGroup$MarginLayoutParams;)V", "(Lcom/loopeer/shadow/ShadowView$LayoutParams;)V", "getGravity", "()I", "setGravity", "(I)V", "Companion", "shadow_release"})
    public static final class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private int gravity;
        private static final int UNSPECIFIED_GRAVITY = -1;
        public static final Companion Companion = new Companion(null);

        public final int getGravity() {
            return this.gravity;
        }

        public final void setGravity(int n) {
            this.gravity = n;
        }

        public LayoutParams(@NotNull Context c, @Nullable AttributeSet attrs) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            super(c, attrs);
            this.gravity = Companion.getUNSPECIFIED_GRAVITY();
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.ShadowView_Layout);
            this.gravity = a.getInt(R.styleable.ShadowView_Layout_layout_gravity, Companion.getUNSPECIFIED_GRAVITY());
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
            this.gravity = Companion.getUNSPECIFIED_GRAVITY();
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height);
            this.gravity = Companion.getUNSPECIFIED_GRAVITY();
            this.gravity = gravity;
        }

        public LayoutParams(@NotNull ViewGroup.LayoutParams source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super(source);
            this.gravity = Companion.getUNSPECIFIED_GRAVITY();
        }

        public LayoutParams(@NotNull ViewGroup.MarginLayoutParams source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super(source);
            this.gravity = Companion.getUNSPECIFIED_GRAVITY();
        }

        public LayoutParams(@NotNull LayoutParams source) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)source), (String)"source");
            super((ViewGroup.MarginLayoutParams)source);
            this.gravity = Companion.getUNSPECIFIED_GRAVITY();
            this.gravity = source.gravity;
        }

        static {
            UNSPECIFIED_GRAVITY = -1;
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/loopeer/shadow/ShadowView$LayoutParams$Companion;", "", "()V", "UNSPECIFIED_GRAVITY", "", "getUNSPECIFIED_GRAVITY", "()I", "shadow_release"})
        public static final class Companion {
            public final int getUNSPECIFIED_GRAVITY() {
                return UNSPECIFIED_GRAVITY;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

