/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.os.Handler;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.ProgressDialogX;
import com.artifex.mupdfdemo.SearchTaskResult;
import com.lonelypluto.pdflibrary.R;

public abstract class SearchTask {
    private static final int SEARCH_PROGRESS_DELAY = 200;
    private final Context mContext;
    private final MuPDFCore mCore;
    private final Handler mHandler;
    private final AlertDialog.Builder mAlertBuilder;
    private AsyncTask<Void, Integer, SearchTaskResult> mSearchTask;

    public SearchTask(Context context, MuPDFCore core) {
        this.mContext = context;
        this.mCore = core;
        this.mHandler = new Handler();
        this.mAlertBuilder = new AlertDialog.Builder(context);
    }

    protected abstract void onTextFound(SearchTaskResult var1);

    public void stop() {
        if (this.mSearchTask != null) {
            this.mSearchTask.cancel(true);
            this.mSearchTask = null;
        }
    }

    public void go(final String text, int direction, int displayPage, int searchPage) {
        if (this.mCore == null) {
            return;
        }
        this.stop();
        final int increment = direction;
        final int startIndex = searchPage == -1 ? displayPage : searchPage + increment;
        final ProgressDialogX progressDialog = new ProgressDialogX(this.mContext);
        progressDialog.setProgressStyle(1);
        progressDialog.setTitle(this.mContext.getString(R.string.searching));
        progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                SearchTask.this.stop();
            }
        });
        progressDialog.setMax(this.mCore.countPages());
        this.mSearchTask = new AsyncTask<Void, Integer, SearchTaskResult>(){

            protected SearchTaskResult doInBackground(Void ... params) {
                for (int index = startIndex; 0 <= index && index < SearchTask.this.mCore.countPages() && !this.isCancelled(); index += increment) {
                    this.publishProgress(new Integer[]{index});
                    RectF[] searchHits = SearchTask.this.mCore.searchPage(index, text);
                    if (searchHits == null || searchHits.length <= 0) continue;
                    return new SearchTaskResult(text, index, searchHits);
                }
                return null;
            }

            protected void onPostExecute(SearchTaskResult result) {
                progressDialog.cancel();
                if (result != null) {
                    SearchTask.this.onTextFound(result);
                } else {
                    SearchTask.this.mAlertBuilder.setTitle(SearchTaskResult.get() == null ? R.string.text_not_found : R.string.no_further_occurrences_found);
                    AlertDialog alert = SearchTask.this.mAlertBuilder.create();
                    alert.setButton(-1, (CharSequence)SearchTask.this.mContext.getString(R.string.dismiss), (DialogInterface.OnClickListener)null);
                    alert.show();
                }
            }

            protected void onCancelled() {
                progressDialog.cancel();
            }

            protected void onProgressUpdate(Integer ... values) {
                progressDialog.setProgress(values[0]);
            }

            protected void onPreExecute() {
                super.onPreExecute();
                SearchTask.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (progressDialog.isCancelled()) {
                            progressDialog.show();
                            progressDialog.setProgress(startIndex);
                        }
                    }
                }, 200L);
            }
        };
        this.mSearchTask.execute((Object[])new Void[0]);
    }
}

