/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.crypto.macs;

import java.util.Hashtable;
import repack.org.bouncycastle.crypto.CipherParameters;
import repack.org.bouncycastle.crypto.Digest;
import repack.org.bouncycastle.crypto.ExtendedDigest;
import repack.org.bouncycastle.crypto.Mac;
import repack.org.bouncycastle.crypto.params.KeyParameter;

public class HMac
implements Mac {
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private Digest digest;
    private int digestSize;
    private int blockLength;
    private byte[] inputPad;
    private byte[] outputPad;
    private static Hashtable blockLengths = new Hashtable();

    static {
        blockLengths.put("GOST3411", new Integer(32));
        blockLengths.put("MD2", new Integer(16));
        blockLengths.put("MD4", new Integer(64));
        blockLengths.put("MD5", new Integer(64));
        blockLengths.put("RIPEMD128", new Integer(64));
        blockLengths.put("RIPEMD160", new Integer(64));
        blockLengths.put("SHA-1", new Integer(64));
        blockLengths.put("SHA-224", new Integer(64));
        blockLengths.put("SHA-256", new Integer(64));
        blockLengths.put("SHA-384", new Integer(128));
        blockLengths.put("SHA-512", new Integer(128));
        blockLengths.put("Tiger", new Integer(64));
        blockLengths.put("Whirlpool", new Integer(64));
    }

    private static int getByteLength(Digest digest) {
        if (digest instanceof ExtendedDigest) {
            return ((ExtendedDigest)digest).getByteLength();
        }
        Integer b = (Integer)blockLengths.get(digest.getAlgorithmName());
        if (b == null) {
            throw new IllegalArgumentException("unknown digest passed: " + digest.getAlgorithmName());
        }
        return b;
    }

    public HMac(Digest digest) {
        this(digest, HMac.getByteLength(digest));
    }

    private HMac(Digest digest, int byteLength) {
        this.digest = digest;
        this.digestSize = digest.getDigestSize();
        this.blockLength = byteLength;
        this.inputPad = new byte[this.blockLength];
        this.outputPad = new byte[this.blockLength];
    }

    @Override
    public String getAlgorithmName() {
        return String.valueOf(this.digest.getAlgorithmName()) + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.digest;
    }

    @Override
    public void init(CipherParameters params) {
        int i;
        this.digest.reset();
        byte[] key = ((KeyParameter)params).getKey();
        if (key.length > this.blockLength) {
            this.digest.update(key, 0, key.length);
            this.digest.doFinal(this.inputPad, 0);
            i = this.digestSize;
            while (i < this.inputPad.length) {
                this.inputPad[i] = 0;
                ++i;
            }
        } else {
            System.arraycopy(key, 0, this.inputPad, 0, key.length);
            i = key.length;
            while (i < this.inputPad.length) {
                this.inputPad[i] = 0;
                ++i;
            }
        }
        this.outputPad = new byte[this.inputPad.length];
        System.arraycopy(this.inputPad, 0, this.outputPad, 0, this.inputPad.length);
        i = 0;
        while (i < this.inputPad.length) {
            int n = i++;
            this.inputPad[n] = (byte)(this.inputPad[n] ^ 0x36);
        }
        i = 0;
        while (i < this.outputPad.length) {
            int n = i++;
            this.outputPad[n] = (byte)(this.outputPad[n] ^ 0x5C);
        }
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }

    @Override
    public int getMacSize() {
        return this.digestSize;
    }

    @Override
    public void update(byte in) {
        this.digest.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = new byte[this.digestSize];
        this.digest.doFinal(tmp, 0);
        this.digest.update(this.outputPad, 0, this.outputPad.length);
        this.digest.update(tmp, 0, tmp.length);
        int len = this.digest.doFinal(out, outOff);
        this.reset();
        return len;
    }

    @Override
    public void reset() {
        this.digest.reset();
        this.digest.update(this.inputPad, 0, this.inputPad.length);
    }
}

