/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cert;

import java.math.BigInteger;
import java.util.Date;
import repack.org.bouncycastle.asn1.DERInteger;
import repack.org.bouncycastle.asn1.x500.X500Name;
import repack.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import repack.org.bouncycastle.asn1.x509.Time;
import repack.org.bouncycastle.asn1.x509.V1TBSCertificateGenerator;
import repack.org.bouncycastle.cert.CertUtils;
import repack.org.bouncycastle.cert.X509CertificateHolder;
import repack.org.bouncycastle.operator.ContentSigner;

public class X509v1CertificateBuilder {
    private V1TBSCertificateGenerator tbsGen;

    public X509v1CertificateBuilder(X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, SubjectPublicKeyInfo publicKeyInfo) {
        if (issuer == null) {
            throw new IllegalArgumentException("issuer must not be null");
        }
        if (publicKeyInfo == null) {
            throw new IllegalArgumentException("publicKeyInfo must not be null");
        }
        this.tbsGen = new V1TBSCertificateGenerator();
        this.tbsGen.setSerialNumber(new DERInteger(serial));
        this.tbsGen.setIssuer(issuer);
        this.tbsGen.setStartDate(new Time(notBefore));
        this.tbsGen.setEndDate(new Time(notAfter));
        this.tbsGen.setSubject(subject);
        this.tbsGen.setSubjectPublicKeyInfo(publicKeyInfo);
    }

    public X509CertificateHolder build(ContentSigner signer) {
        this.tbsGen.setSignature(signer.getAlgorithmIdentifier());
        return CertUtils.generateFullCert(signer, this.tbsGen.generateTBSCertificate());
    }
}

