/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.color;

import org.apache.harmony.awt.internal.nls.Messages;

class NativeImageFormat {
    private static final int PT_ANY = 0;
    private static final int PT_GRAY = 3;
    private static final int PT_RGB = 4;
    private static final int INT_RGB_LCMS_FMT;
    private static final int INT_ARGB_LCMS_FMT;
    private static final int INT_BGR_LCMS_FMT;
    private static final int THREE_BYTE_BGR_LCMS_FMT;
    private static final int FOUR_BYTE_ABGR_LCMS_FMT;
    private static final int BYTE_GRAY_LCMS_FMT;
    private static final int USHORT_GRAY_LCMS_FMT;
    private int cmmFormat = 0;
    private int rows = 0;
    private int cols = 0;
    private int scanlineStride = -1;
    private Object imageData;
    private int dataOffset;
    private int alphaOffset = -1;

    static {
        INT_ARGB_LCMS_FMT = INT_RGB_LCMS_FMT = NativeImageFormat.colorspaceSh(4) | NativeImageFormat.extraSh(1) | NativeImageFormat.channelsSh(3) | NativeImageFormat.bytesSh(1) | NativeImageFormat.doswapSh(1) | NativeImageFormat.swapfirstSh(1);
        INT_BGR_LCMS_FMT = NativeImageFormat.colorspaceSh(4) | NativeImageFormat.extraSh(1) | NativeImageFormat.channelsSh(3) | NativeImageFormat.bytesSh(1);
        THREE_BYTE_BGR_LCMS_FMT = NativeImageFormat.colorspaceSh(4) | NativeImageFormat.channelsSh(3) | NativeImageFormat.bytesSh(1) | NativeImageFormat.doswapSh(1);
        FOUR_BYTE_ABGR_LCMS_FMT = NativeImageFormat.colorspaceSh(4) | NativeImageFormat.extraSh(1) | NativeImageFormat.channelsSh(3) | NativeImageFormat.bytesSh(1) | NativeImageFormat.doswapSh(1);
        BYTE_GRAY_LCMS_FMT = NativeImageFormat.colorspaceSh(3) | NativeImageFormat.channelsSh(1) | NativeImageFormat.bytesSh(1);
        USHORT_GRAY_LCMS_FMT = NativeImageFormat.colorspaceSh(3) | NativeImageFormat.channelsSh(1) | NativeImageFormat.bytesSh(2);
        NativeImageFormat.initIDs();
    }

    private static native void initIDs();

    private static int colorspaceSh(int s) {
        return s << 16;
    }

    private static int swapfirstSh(int s) {
        return s << 14;
    }

    private static int flavorSh(int s) {
        return s << 13;
    }

    private static int planarSh(int s) {
        return s << 12;
    }

    private static int endianSh(int s) {
        return s << 11;
    }

    private static int doswapSh(int s) {
        return s << 10;
    }

    private static int extraSh(int s) {
        return s << 7;
    }

    private static int channelsSh(int s) {
        return s << 3;
    }

    private static int bytesSh(int s) {
        return s;
    }

    Object getChannelData() {
        return this.imageData;
    }

    int getNumCols() {
        return this.cols;
    }

    int getNumRows() {
        return this.rows;
    }

    public NativeImageFormat() {
    }

    public NativeImageFormat(Object imgData, int nChannels, int nRows, int nCols) {
        if (imgData instanceof short[]) {
            this.cmmFormat |= NativeImageFormat.bytesSh(2);
        } else if (imgData instanceof byte[]) {
            this.cmmFormat |= NativeImageFormat.bytesSh(1);
        } else {
            throw new IllegalArgumentException(Messages.getString("awt.47"));
        }
        this.cmmFormat |= NativeImageFormat.channelsSh(nChannels);
        this.rows = nRows;
        this.cols = nCols;
        this.imageData = imgData;
        this.dataOffset = 0;
    }
}

