/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class Utils {
    public static String getSystemProperty(String name) {
        return Utils.getSystemProperty(name, null);
    }

    public static String getSystemProperty(final String name, final String value) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, value);
            }
        });
    }

    public static void loadLibrary(final String name) throws UnsatisfiedLinkError, NullPointerException {
        block3: {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() {
                        System.loadLibrary(name);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof UnsatisfiedLinkError) {
                    throw (UnsatisfiedLinkError)cause;
                }
                if (!(cause instanceof NullPointerException)) break block3;
                throw (NullPointerException)cause;
            }
        }
    }
}

