/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import repack.org.bouncycastle.jce.ProviderConfigurationPermission;
import repack.org.bouncycastle.jce.spec.ECParameterSpec;

public class ProviderUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission("BC", "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission("BC", "ecImplicitlyCa");
    private static ThreadLocal threadSpec = new ThreadLocal();
    private static volatile ECParameterSpec ecImplicitCaParams;

    static void setParameter(String parameterName, Object parameter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (parameterName.equals("threadLocalEcImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            ECParameterSpec curveSpec = (ECParameterSpec)parameter;
            threadSpec.set(curveSpec);
        } else if (parameterName.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            ecImplicitCaParams = (ECParameterSpec)parameter;
        }
    }

    public static ECParameterSpec getEcImplicitlyCa() {
        ECParameterSpec spec = (ECParameterSpec)threadSpec.get();
        if (spec != null) {
            return spec;
        }
        return ecImplicitCaParams;
    }

    static int getReadLimit(InputStream in) throws IOException {
        if (in instanceof ByteArrayInputStream) {
            return in.available();
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }
}

