/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.CancellableTaskDefinition;
import com.artifex.mupdfdemo.Hit;
import com.artifex.mupdfdemo.LinkInfo;
import com.artifex.mupdfdemo.MuPDFCancellableTaskDefinition;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.MuPDFView;
import com.artifex.mupdfdemo.PageView;
import com.artifex.mupdfdemo.PassClickResult;
import com.artifex.mupdfdemo.PassClickResultChoice;
import com.artifex.mupdfdemo.PassClickResultSignature;
import com.artifex.mupdfdemo.PassClickResultText;
import com.artifex.mupdfdemo.PassClickResultVisitor;
import com.artifex.mupdfdemo.TextProcessor;
import com.artifex.mupdfdemo.TextWord;
import com.lonelypluto.pdflibrary.R;
import java.util.ArrayList;

public class MuPDFPageView
extends PageView
implements MuPDFView {
    private final MuPDFCore mCore;
    private AsyncTask<Void, Void, PassClickResult> mPassClick;
    private RectF[] mWidgetAreas;
    private Annotation[] mAnnotations;
    private int mSelectedAnnotationIndex = -1;
    private AsyncTask<Void, Void, RectF[]> mLoadWidgetAreas;
    private AsyncTask<Void, Void, Annotation[]> mLoadAnnotations;
    private AlertDialog.Builder mTextEntryBuilder;
    private AlertDialog.Builder mChoiceEntryBuilder;
    private AlertDialog.Builder mSigningDialogBuilder;
    private AlertDialog.Builder mSignatureReportBuilder;
    private AlertDialog.Builder mPasswordEntryBuilder;
    private EditText mPasswordText;
    private AlertDialog mTextEntry;
    private AlertDialog mPasswordEntry;
    private EditText mEditText;
    private AsyncTask<String, Void, Boolean> mSetWidgetText;
    private AsyncTask<String, Void, Void> mSetWidgetChoice;
    private AsyncTask<PointF[], Void, Void> mAddStrikeOut;
    private AsyncTask<Object, Void, Void> mAddInk;
    private AsyncTask<Integer, Void, Void> mDeleteAnnotation;
    private AsyncTask<Void, Void, String> mCheckSignature;
    private AsyncTask<Void, Void, Boolean> mSign;
    private Runnable changeReporter;

    public MuPDFPageView(Context c, MuPDFCore core, Point parentSize, Bitmap sharedHqBm) {
        super(c, parentSize, sharedHqBm);
        this.mCore = core;
        this.mTextEntryBuilder = new AlertDialog.Builder(c);
        this.mTextEntryBuilder.setTitle((CharSequence)this.getContext().getString(R.string.fill_out_text_field));
        LayoutInflater inflater = (LayoutInflater)c.getSystemService("layout_inflater");
        this.mEditText = (EditText)inflater.inflate(R.layout.edittext_entry, null);
        this.mTextEntryBuilder.setView((View)this.mEditText);
        this.mTextEntryBuilder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        this.mTextEntryBuilder.setPositiveButton(R.string.okay, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MuPDFPageView.this.mSetWidgetText = (AsyncTask)new AsyncTask<String, Void, Boolean>(){

                    protected Boolean doInBackground(String ... arg0) {
                        return MuPDFPageView.this.mCore.setFocusedWidgetText(MuPDFPageView.this.mPageNumber, arg0[0]);
                    }

                    protected void onPostExecute(Boolean result) {
                        MuPDFPageView.this.changeReporter.run();
                        if (!result.booleanValue()) {
                            MuPDFPageView.this.invokeTextDialog(MuPDFPageView.this.mEditText.getText().toString());
                        }
                    }
                };
                MuPDFPageView.this.mSetWidgetText.execute((Object[])new String[]{MuPDFPageView.this.mEditText.getText().toString()});
            }
        });
        this.mTextEntry = this.mTextEntryBuilder.create();
        this.mChoiceEntryBuilder = new AlertDialog.Builder(c);
        this.mChoiceEntryBuilder.setTitle((CharSequence)this.getContext().getString(R.string.choose_value));
        this.mSigningDialogBuilder = new AlertDialog.Builder(c);
        this.mSigningDialogBuilder.setTitle((CharSequence)this.getContext().getString(R.string.select_certificate_and_sign));
        this.mSigningDialogBuilder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        this.mSigningDialogBuilder.setPositiveButton(R.string.okay, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        this.mSignatureReportBuilder = new AlertDialog.Builder(c);
        this.mSignatureReportBuilder.setTitle((CharSequence)this.getContext().getString(R.string.signature_checked));
        this.mSignatureReportBuilder.setPositiveButton(R.string.okay, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        this.mPasswordText = new EditText(c);
        this.mPasswordText.setInputType(128);
        this.mPasswordText.setTransformationMethod((TransformationMethod)new PasswordTransformationMethod());
        this.mPasswordEntryBuilder = new AlertDialog.Builder(c);
        this.mPasswordEntryBuilder.setTitle(R.string.enter_password);
        this.mPasswordEntryBuilder.setView((View)this.mPasswordText);
        this.mPasswordEntryBuilder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        this.mPasswordEntry = this.mPasswordEntryBuilder.create();
    }

    private void signWithKeyFile(final Uri uri) {
        this.mPasswordEntry.getWindow().setSoftInputMode(5);
        this.mPasswordEntry.setButton(-1, (CharSequence)"Sign", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                MuPDFPageView.this.signWithKeyFileAndPassword(uri, MuPDFPageView.this.mPasswordText.getText().toString());
            }
        });
        this.mPasswordEntry.show();
    }

    private void signWithKeyFileAndPassword(final Uri uri, final String password) {
        this.mSign = new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... params) {
                return MuPDFPageView.this.mCore.signFocusedSignature(Uri.decode((String)uri.getEncodedPath()), password);
            }

            protected void onPostExecute(Boolean result) {
                if (result.booleanValue()) {
                    MuPDFPageView.this.changeReporter.run();
                } else {
                    MuPDFPageView.this.mPasswordText.setText((CharSequence)"");
                    MuPDFPageView.this.signWithKeyFile(uri);
                }
            }
        };
        this.mSign.execute((Object[])new Void[0]);
    }

    @Override
    public LinkInfo hitLink(float x, float y) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX = (x - (float)this.getLeft()) / scale;
        float docRelY = (y - (float)this.getTop()) / scale;
        for (LinkInfo l : this.mLinks) {
            if (!l.rect.contains(docRelX, docRelY)) continue;
            return l;
        }
        return null;
    }

    private void invokeTextDialog(String text) {
        this.mEditText.setText((CharSequence)text);
        this.mTextEntry.getWindow().setSoftInputMode(5);
        this.mTextEntry.show();
    }

    private void invokeChoiceDialog(final String[] options) {
        this.mChoiceEntryBuilder.setItems((CharSequence[])options, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MuPDFPageView.this.mSetWidgetChoice = (AsyncTask)new AsyncTask<String, Void, Void>(){

                    protected Void doInBackground(String ... params) {
                        String[] sel = new String[]{params[0]};
                        MuPDFPageView.this.mCore.setFocusedWidgetChoiceSelected(sel);
                        return null;
                    }

                    protected void onPostExecute(Void result) {
                        MuPDFPageView.this.changeReporter.run();
                    }
                };
                MuPDFPageView.this.mSetWidgetChoice.execute((Object[])new String[]{options[which]});
            }
        });
        AlertDialog dialog = this.mChoiceEntryBuilder.create();
        dialog.show();
    }

    private void invokeSignatureCheckingDialog() {
        this.mCheckSignature = new AsyncTask<Void, Void, String>(){

            protected String doInBackground(Void ... params) {
                return MuPDFPageView.this.mCore.checkFocusedSignature();
            }

            protected void onPostExecute(String result) {
                AlertDialog report = MuPDFPageView.this.mSignatureReportBuilder.create();
                report.setMessage((CharSequence)result);
                report.show();
            }
        };
        this.mCheckSignature.execute((Object[])new Void[0]);
    }

    private void invokeSigningDialog() {
        AlertDialog dialog = this.mSigningDialogBuilder.create();
        dialog.show();
    }

    private void warnNoSignatureSupport() {
        AlertDialog dialog = this.mSignatureReportBuilder.create();
        dialog.setTitle((CharSequence)"App built with no signature support");
        dialog.show();
    }

    @Override
    public void setChangeReporter(Runnable reporter) {
        this.changeReporter = reporter;
    }

    @Override
    public Hit passClickEvent(float x, float y) {
        int i;
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        final float docRelX = (x - (float)this.getLeft()) / scale;
        final float docRelY = (y - (float)this.getTop()) / scale;
        boolean hit = false;
        if (this.mAnnotations != null) {
            for (i = 0; i < this.mAnnotations.length; ++i) {
                if (!this.mAnnotations[i].contains(docRelX, docRelY)) continue;
                hit = true;
                break;
            }
            if (hit) {
                switch (this.mAnnotations[i].type) {
                    case HIGHLIGHT: 
                    case UNDERLINE: 
                    case SQUIGGLY: 
                    case STRIKEOUT: 
                    case INK: {
                        this.mSelectedAnnotationIndex = i;
                        this.setItemSelectBox(this.mAnnotations[i]);
                        return Hit.Annotation;
                    }
                }
            }
        }
        this.mSelectedAnnotationIndex = -1;
        this.setItemSelectBox(null);
        if (!this.mCore.javascriptSupported()) {
            return Hit.Nothing;
        }
        if (this.mWidgetAreas != null) {
            for (i = 0; i < this.mWidgetAreas.length && !hit; ++i) {
                if (!this.mWidgetAreas[i].contains(docRelX, docRelY)) continue;
                hit = true;
            }
        }
        if (hit) {
            this.mPassClick = new AsyncTask<Void, Void, PassClickResult>(){

                protected PassClickResult doInBackground(Void ... arg0) {
                    return MuPDFPageView.this.mCore.passClickEvent(MuPDFPageView.this.mPageNumber, docRelX, docRelY);
                }

                protected void onPostExecute(PassClickResult result) {
                    if (result.changed) {
                        MuPDFPageView.this.changeReporter.run();
                    }
                    result.acceptVisitor(new PassClickResultVisitor(){

                        @Override
                        public void visitText(PassClickResultText result) {
                            MuPDFPageView.this.invokeTextDialog(result.text);
                        }

                        @Override
                        public void visitChoice(PassClickResultChoice result) {
                            MuPDFPageView.this.invokeChoiceDialog(result.options);
                        }

                        @Override
                        public void visitSignature(PassClickResultSignature result) {
                            switch (result.state) {
                                case NoSupport: {
                                    MuPDFPageView.this.warnNoSignatureSupport();
                                    break;
                                }
                                case Unsigned: {
                                    MuPDFPageView.this.invokeSigningDialog();
                                    break;
                                }
                                case Signed: {
                                    MuPDFPageView.this.invokeSignatureCheckingDialog();
                                }
                            }
                        }
                    });
                }
            };
            this.mPassClick.execute((Object[])new Void[0]);
            return Hit.Widget;
        }
        return Hit.Nothing;
    }

    @Override
    @TargetApi(value=11)
    public boolean copySelection() {
        final StringBuilder text = new StringBuilder();
        this.processSelectedText(new TextProcessor(){
            StringBuilder line;

            @Override
            public void onStartLine() {
                this.line = new StringBuilder();
            }

            @Override
            public void onWord(TextWord word) {
                if (this.line.length() > 0) {
                    this.line.append(' ');
                }
                this.line.append(word.w);
            }

            @Override
            public void onEndLine() {
                if (text.length() > 0) {
                    text.append('\n');
                }
                text.append((CharSequence)this.line);
            }
        });
        if (text.length() == 0) {
            return false;
        }
        ClipboardManager cm = (ClipboardManager)this.mContext.getSystemService("clipboard");
        cm.setPrimaryClip(ClipData.newPlainText((CharSequence)"MuPDF", (CharSequence)text));
        this.deselectText();
        return true;
    }

    @Override
    public boolean markupSelection(final Annotation.Type type) {
        final ArrayList quadPoints = new ArrayList();
        this.processSelectedText(new TextProcessor(){
            RectF rect;

            @Override
            public void onStartLine() {
                this.rect = new RectF();
            }

            @Override
            public void onWord(TextWord word) {
                this.rect.union((RectF)word);
            }

            @Override
            public void onEndLine() {
                if (!this.rect.isEmpty()) {
                    quadPoints.add(new PointF(this.rect.left, this.rect.bottom));
                    quadPoints.add(new PointF(this.rect.right, this.rect.bottom));
                    quadPoints.add(new PointF(this.rect.right, this.rect.top));
                    quadPoints.add(new PointF(this.rect.left, this.rect.top));
                }
            }
        });
        if (quadPoints.size() == 0) {
            return false;
        }
        this.mAddStrikeOut = new AsyncTask<PointF[], Void, Void>(){

            protected Void doInBackground(PointF[] ... params) {
                MuPDFPageView.this.addMarkup(params[0], type);
                return null;
            }

            protected void onPostExecute(Void result) {
                MuPDFPageView.this.loadAnnotations();
                MuPDFPageView.this.update();
            }
        };
        this.mAddStrikeOut.execute((Object[])new PointF[][]{quadPoints.toArray(new PointF[quadPoints.size()])});
        this.deselectText();
        return true;
    }

    @Override
    public void deleteSelectedAnnotation() {
        if (this.mSelectedAnnotationIndex != -1) {
            if (this.mDeleteAnnotation != null) {
                this.mDeleteAnnotation.cancel(true);
            }
            this.mDeleteAnnotation = new AsyncTask<Integer, Void, Void>(){

                protected Void doInBackground(Integer ... params) {
                    MuPDFPageView.this.mCore.deleteAnnotation(MuPDFPageView.this.mPageNumber, params[0]);
                    return null;
                }

                protected void onPostExecute(Void result) {
                    MuPDFPageView.this.loadAnnotations();
                    MuPDFPageView.this.update();
                }
            };
            this.mDeleteAnnotation.execute((Object[])new Integer[]{this.mSelectedAnnotationIndex});
            this.mSelectedAnnotationIndex = -1;
            this.setItemSelectBox(null);
        }
    }

    @Override
    public void deselectAnnotation() {
        this.mSelectedAnnotationIndex = -1;
        this.setItemSelectBox(null);
    }

    @Override
    public boolean saveDraw() {
        PointF[][] path = this.getDraw();
        if (path == null) {
            return false;
        }
        if (this.mAddInk != null) {
            this.mAddInk.cancel(true);
            this.mAddInk = null;
        }
        this.mAddInk = new AsyncTask<Object, Void, Void>(){

            protected Void doInBackground(Object ... params) {
                MuPDFPageView.this.mCore.addInkAnnotation(MuPDFPageView.this.mPageNumber, (PointF[][])params[0], (float[])params[1], ((Float)params[2]).floatValue());
                return null;
            }

            protected void onPostExecute(Void result) {
                MuPDFPageView.this.loadAnnotations();
                MuPDFPageView.this.update();
            }
        };
        this.mAddInk.execute(new Object[]{this.getDraw(), this.getColor(), Float.valueOf(this.getInkThickness())});
        this.cancelDraw();
        return true;
    }

    @Override
    protected CancellableTaskDefinition<Void, Void> getDrawPageTask(final Bitmap bm, final int sizeX, final int sizeY, final int patchX, final int patchY, final int patchWidth, final int patchHeight) {
        return new MuPDFCancellableTaskDefinition<Void, Void>(this.mCore){

            public Void doInBackground(MuPDFCore.Cookie cookie, Void ... params) {
                if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 14) {
                    bm.eraseColor(0);
                }
                MuPDFPageView.this.mCore.drawPage(bm, MuPDFPageView.this.mPageNumber, sizeX, sizeY, patchX, patchY, patchWidth, patchHeight, cookie);
                return null;
            }
        };
    }

    @Override
    protected CancellableTaskDefinition<Void, Void> getUpdatePageTask(final Bitmap bm, final int sizeX, final int sizeY, final int patchX, final int patchY, final int patchWidth, final int patchHeight) {
        return new MuPDFCancellableTaskDefinition<Void, Void>(this.mCore){

            public Void doInBackground(MuPDFCore.Cookie cookie, Void ... params) {
                if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT < 14) {
                    bm.eraseColor(0);
                }
                MuPDFPageView.this.mCore.updatePage(bm, MuPDFPageView.this.mPageNumber, sizeX, sizeY, patchX, patchY, patchWidth, patchHeight, cookie);
                return null;
            }
        };
    }

    @Override
    protected LinkInfo[] getLinkInfo() {
        return this.mCore.getPageLinks(this.mPageNumber);
    }

    @Override
    protected TextWord[][] getText() {
        return this.mCore.textLines(this.mPageNumber);
    }

    @Override
    protected void addMarkup(PointF[] quadPoints, Annotation.Type type) {
        this.mCore.addMarkupAnnotation(this.mPageNumber, quadPoints, type);
    }

    private void loadAnnotations() {
        this.mAnnotations = null;
        if (this.mLoadAnnotations != null) {
            this.mLoadAnnotations.cancel(true);
        }
        this.mLoadAnnotations = new AsyncTask<Void, Void, Annotation[]>(){

            protected Annotation[] doInBackground(Void ... params) {
                return MuPDFPageView.this.mCore.getAnnoations(MuPDFPageView.this.mPageNumber);
            }

            protected void onPostExecute(Annotation[] result) {
                MuPDFPageView.access$1502(MuPDFPageView.this, result);
            }
        };
        this.mLoadAnnotations.execute((Object[])new Void[0]);
    }

    @Override
    public void setPage(final int page, PointF size) {
        this.loadAnnotations();
        this.mLoadWidgetAreas = new AsyncTask<Void, Void, RectF[]>(){

            protected RectF[] doInBackground(Void ... arg0) {
                return MuPDFPageView.this.mCore.getWidgetAreas(page);
            }

            protected void onPostExecute(RectF[] result) {
                MuPDFPageView.access$1602(MuPDFPageView.this, result);
            }
        };
        this.mLoadWidgetAreas.execute((Object[])new Void[0]);
        super.setPage(page, size);
    }

    @Override
    public void setScale(float scale) {
    }

    @Override
    public void releaseResources() {
        if (this.mPassClick != null) {
            this.mPassClick.cancel(true);
            this.mPassClick = null;
        }
        if (this.mLoadWidgetAreas != null) {
            this.mLoadWidgetAreas.cancel(true);
            this.mLoadWidgetAreas = null;
        }
        if (this.mLoadAnnotations != null) {
            this.mLoadAnnotations.cancel(true);
            this.mLoadAnnotations = null;
        }
        if (this.mSetWidgetText != null) {
            this.mSetWidgetText.cancel(true);
            this.mSetWidgetText = null;
        }
        if (this.mSetWidgetChoice != null) {
            this.mSetWidgetChoice.cancel(true);
            this.mSetWidgetChoice = null;
        }
        if (this.mAddStrikeOut != null) {
            this.mAddStrikeOut.cancel(true);
            this.mAddStrikeOut = null;
        }
        if (this.mDeleteAnnotation != null) {
            this.mDeleteAnnotation.cancel(true);
            this.mDeleteAnnotation = null;
        }
        super.releaseResources();
    }

    static /* synthetic */ Annotation[] access$1502(MuPDFPageView x0, Annotation[] x1) {
        x0.mAnnotations = x1;
        return x1;
    }

    static /* synthetic */ RectF[] access$1602(MuPDFPageView x0, RectF[] x1) {
        x0.mWidgetAreas = x1;
        return x1;
    }
}

