/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.openssl;

import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import repack.org.bouncycastle.openssl.EncryptionException;
import repack.org.bouncycastle.openssl.MiscPEMGenerator;
import repack.org.bouncycastle.util.io.pem.PemGenerationException;
import repack.org.bouncycastle.util.io.pem.PemObjectGenerator;
import repack.org.bouncycastle.util.io.pem.PemWriter;

public class PEMWriter
extends PemWriter {
    private String provider;

    public PEMWriter(Writer out) {
        this(out, "BC");
    }

    public PEMWriter(Writer out, String provider) {
        super(out);
        this.provider = provider;
    }

    public void writeObject(Object obj) throws IOException {
        try {
            super.writeObject(new MiscPEMGenerator(obj));
        }
        catch (PemGenerationException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void writeObject(PemObjectGenerator obj) throws IOException {
        super.writeObject(obj);
    }

    public void writeObject(Object obj, String algorithm, char[] password, SecureRandom random) throws IOException {
        try {
            super.writeObject(new MiscPEMGenerator(obj, algorithm, password, random, this.provider));
        }
        catch (NoSuchProviderException e) {
            throw new EncryptionException(e.getMessage(), e);
        }
    }
}

