/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.jce.provider;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import repack.org.bouncycastle.asn1.ASN1InputStream;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.ASN1Set;
import repack.org.bouncycastle.asn1.ASN1TaggedObject;
import repack.org.bouncycastle.asn1.DEREncodable;
import repack.org.bouncycastle.asn1.DERObjectIdentifier;
import repack.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import repack.org.bouncycastle.asn1.pkcs.SignedData;
import repack.org.bouncycastle.jce.provider.PEMUtil;
import repack.org.bouncycastle.jce.provider.ProviderUtil;
import repack.org.bouncycastle.x509.X509AttributeCertificate;
import repack.org.bouncycastle.x509.X509StreamParserSpi;
import repack.org.bouncycastle.x509.X509V2AttributeCertificate;
import repack.org.bouncycastle.x509.util.StreamParsingException;

public class X509AttrCertParser
extends X509StreamParserSpi {
    private static final PEMUtil PEM_PARSER = new PEMUtil("ATTRIBUTE CERTIFICATE");
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;

    private X509AttributeCertificate readDERCertificate(InputStream in) throws IOException {
        ASN1InputStream dIn = new ASN1InputStream(in, ProviderUtil.getReadLimit(in));
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof DERObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(1), true)).getCertificates();
            return this.getCertificate();
        }
        return new X509V2AttributeCertificate(seq.getEncoded());
    }

    private X509AttributeCertificate getCertificate() throws IOException {
        if (this.sData != null) {
            while (this.sDataObjectCount < this.sData.size()) {
                DEREncodable obj;
                if (!((obj = this.sData.getObjectAt(this.sDataObjectCount++)) instanceof ASN1TaggedObject) || ((ASN1TaggedObject)obj).getTagNo() != 2) continue;
                return new X509V2AttributeCertificate(ASN1Sequence.getInstance((ASN1TaggedObject)obj, false).getEncoded());
            }
        }
        return null;
    }

    private X509AttributeCertificate readPEMCertificate(InputStream in) throws IOException {
        ASN1Sequence seq = PEM_PARSER.readPEMObject(in);
        if (seq != null) {
            return new X509V2AttributeCertificate(seq.getEncoded());
        }
        return null;
    }

    @Override
    public void engineInit(InputStream in) {
        this.currentStream = in;
        this.sData = null;
        this.sDataObjectCount = 0;
        if (!this.currentStream.markSupported()) {
            this.currentStream = new BufferedInputStream(this.currentStream);
        }
    }

    @Override
    public Object engineRead() throws StreamParsingException {
        int tag;
        block7: {
            block6: {
                try {
                    if (this.sData == null) break block6;
                    if (this.sDataObjectCount != this.sData.size()) {
                        return this.getCertificate();
                    }
                    this.sData = null;
                    this.sDataObjectCount = 0;
                    return null;
                }
                catch (Exception e) {
                    throw new StreamParsingException(e.toString(), e);
                }
            }
            this.currentStream.mark(10);
            tag = this.currentStream.read();
            if (tag != -1) break block7;
            return null;
        }
        if (tag != 48) {
            this.currentStream.reset();
            return this.readPEMCertificate(this.currentStream);
        }
        this.currentStream.reset();
        return this.readDERCertificate(this.currentStream);
    }

    @Override
    public Collection engineReadAll() throws StreamParsingException {
        X509AttributeCertificate cert;
        ArrayList<X509AttributeCertificate> certs = new ArrayList<X509AttributeCertificate>();
        while ((cert = (X509AttributeCertificate)this.engineRead()) != null) {
            certs.add(cert);
        }
        return certs;
    }
}

