/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cert.ocsp;

import java.util.Date;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.ocsp.ResponseData;
import repack.org.bouncycastle.asn1.ocsp.SingleResponse;
import repack.org.bouncycastle.asn1.x509.X509Extensions;
import repack.org.bouncycastle.cert.ocsp.OCSPUtils;
import repack.org.bouncycastle.cert.ocsp.RespID;
import repack.org.bouncycastle.cert.ocsp.SingleResp;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData data) {
        this.data = data;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s.size()];
        int i = 0;
        while (i != rs.length) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s.getObjectAt(i)));
            ++i;
        }
        return rs;
    }

    public X509Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

