/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.geom;

import java.util.ArrayList;
import java.util.List;
import org.apache.harmony.awt.geom.GeometryUtil;
import org.apache.harmony.awt.geom.IntersectPoint;

public class CrossingHelper {
    private double[][] coords;
    private int[] sizes;
    private List<IntersectPoint> isectPoints = new ArrayList<IntersectPoint>();

    public CrossingHelper(double[][] coords, int[] sizes) {
        this.coords = coords;
        this.sizes = sizes;
    }

    public IntersectPoint[] findCrossing() {
        int pointCount1 = this.sizes[0] / 2;
        int pointCount2 = this.sizes[1] / 2;
        int[] indices = new int[pointCount1 + pointCount2];
        int i = 0;
        while (i < pointCount1 + pointCount2) {
            indices[i] = i;
            ++i;
        }
        CrossingHelper.sort(this.coords[0], pointCount1, this.coords[1], pointCount2, indices);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int i2 = 0;
        while (i2 < indices.length) {
            Edge edge;
            int areaNumber;
            int endIndex;
            int begIndex;
            if (indices[i2] < pointCount1) {
                begIndex = indices[i2];
                endIndex = indices[i2] - 1;
                if (endIndex < 0) {
                    endIndex = pointCount1 - 1;
                }
                areaNumber = 0;
            } else if (indices[i2] < pointCount1 + pointCount2) {
                begIndex = indices[i2] - pointCount1;
                endIndex = indices[i2] - 1 - pointCount1;
                if (endIndex < 0) {
                    endIndex = pointCount2 - 1;
                }
                areaNumber = 1;
            } else {
                throw new IndexOutOfBoundsException();
            }
            if (!this.removeEdge(edges, begIndex, endIndex)) {
                edge = new Edge(begIndex, endIndex, areaNumber);
                this.intersectShape(edges, this.coords[0], pointCount1, this.coords[1], pointCount2, edge);
                edges.add(edge);
            }
            begIndex = indices[i2];
            endIndex = indices[i2] + 1;
            if (begIndex < pointCount1 && endIndex == pointCount1) {
                endIndex = 0;
            } else if (begIndex >= pointCount1 && endIndex == pointCount2 + pointCount1) {
                endIndex = pointCount1;
            }
            if (endIndex < pointCount1) {
                areaNumber = 0;
            } else {
                areaNumber = 1;
                endIndex -= pointCount1;
                begIndex -= pointCount1;
            }
            if (!this.removeEdge(edges, begIndex, endIndex)) {
                edge = new Edge(begIndex, endIndex, areaNumber);
                this.intersectShape(edges, this.coords[0], pointCount1, this.coords[1], pointCount2, edge);
                edges.add(edge);
            }
            ++i2;
        }
        return this.isectPoints.toArray(new IntersectPoint[this.isectPoints.size()]);
    }

    private boolean removeEdge(List<Edge> edges, int begIndex, int endIndex) {
        for (Edge edge : edges) {
            if (!edge.reverseCompare(begIndex, endIndex)) continue;
            edges.remove(edge);
            return true;
        }
        return false;
    }

    private void intersectShape(List<Edge> edges, double[] coords1, int length1, double[] coords2, int length2, Edge initEdge) {
        boolean areaOfEdge1;
        double y2;
        double x2;
        double y1;
        double x1;
        double[] point = new double[2];
        if (initEdge.areaNumber == 0) {
            x1 = coords1[2 * initEdge.begIndex];
            y1 = coords1[2 * initEdge.begIndex + 1];
            x2 = coords1[2 * initEdge.endIndex];
            y2 = coords1[2 * initEdge.endIndex + 1];
            areaOfEdge1 = false;
        } else {
            x1 = coords2[2 * initEdge.begIndex];
            y1 = coords2[2 * initEdge.begIndex + 1];
            x2 = coords2[2 * initEdge.endIndex];
            y2 = coords2[2 * initEdge.endIndex + 1];
            areaOfEdge1 = true;
        }
        for (Edge edge : edges) {
            int temp;
            int addEnd;
            int addBegin;
            int initEnd;
            int initBegin;
            boolean areaOfEdge2;
            double y4;
            double x4;
            double y3;
            double x3;
            if (edge.areaNumber == 0) {
                x3 = coords1[2 * edge.begIndex];
                y3 = coords1[2 * edge.begIndex + 1];
                x4 = coords1[2 * edge.endIndex];
                y4 = coords1[2 * edge.endIndex + 1];
                areaOfEdge2 = false;
            } else {
                x3 = coords2[2 * edge.begIndex];
                y3 = coords2[2 * edge.begIndex + 1];
                x4 = coords2[2 * edge.endIndex];
                y4 = coords2[2 * edge.endIndex + 1];
                areaOfEdge2 = true;
            }
            if (areaOfEdge1 == areaOfEdge2 || GeometryUtil.intersectLines(x1, y1, x2, y2, x3, y3, x4, y4, point) != 1 || this.containsPoint(point)) continue;
            if (initEdge.areaNumber == 0) {
                initBegin = initEdge.begIndex;
                initEnd = initEdge.endIndex;
                addBegin = edge.begIndex;
                addEnd = edge.endIndex;
            } else {
                initBegin = edge.begIndex;
                initEnd = edge.endIndex;
                addBegin = initEdge.begIndex;
                addEnd = initEdge.endIndex;
            }
            if (initEnd == length1 - 1 && initBegin == 0 && initEnd > initBegin || (initEnd != length1 - 1 || initBegin != 0) && (initBegin != length1 - 1 || initEnd != 0) && initBegin > initEnd) {
                temp = initBegin;
                initBegin = initEnd;
                initEnd = temp;
            }
            if (addEnd == length2 - 1 && addBegin == 0 && addEnd > addBegin || (addEnd != length2 - 1 || addBegin != 0) && (addBegin != length2 - 1 || addEnd != 0) && addBegin > addEnd) {
                temp = addBegin;
                addBegin = addEnd;
                addEnd = temp;
            }
            for (IntersectPoint ip : this.isectPoints) {
                if (initBegin == ip.getBegIndex(true) && initEnd == ip.getEndIndex(true)) {
                    if (CrossingHelper.compare(ip.getX(), ip.getY(), point[0], point[1]) > 0) {
                        initEnd = -(this.isectPoints.indexOf(ip) + 1);
                        ip.setBegIndex1(-(this.isectPoints.size() + 1));
                    } else {
                        initBegin = -(this.isectPoints.indexOf(ip) + 1);
                        ip.setEndIndex1(-(this.isectPoints.size() + 1));
                    }
                }
                if (addBegin != ip.getBegIndex(false) || addEnd != ip.getEndIndex(false)) continue;
                if (CrossingHelper.compare(ip.getX(), ip.getY(), point[0], point[1]) > 0) {
                    addEnd = -(this.isectPoints.indexOf(ip) + 1);
                    ip.setBegIndex2(-(this.isectPoints.size() + 1));
                    continue;
                }
                addBegin = -(this.isectPoints.indexOf(ip) + 1);
                ip.setEndIndex2(-(this.isectPoints.size() + 1));
            }
            this.isectPoints.add(new IntersectPoint(initBegin, initEnd, addBegin, addEnd, point[0], point[1]));
        }
    }

    private static void sort(double[] coords1, int length1, double[] coords2, int length2, int[] array) {
        int length = length1 + length2;
        int i = 1;
        while (i < length) {
            double y2;
            double x2;
            double y1;
            double x1;
            if (array[i - 1] < length1) {
                x1 = coords1[2 * array[i - 1]];
                y1 = coords1[2 * array[i - 1] + 1];
            } else {
                x1 = coords2[2 * (array[i - 1] - length1)];
                y1 = coords2[2 * (array[i - 1] - length1) + 1];
            }
            if (array[i] < length1) {
                x2 = coords1[2 * array[i]];
                y2 = coords1[2 * array[i] + 1];
            } else {
                x2 = coords2[2 * (array[i] - length1)];
                y2 = coords2[2 * (array[i] - length1) + 1];
            }
            int j = i;
            while (j > 0 && CrossingHelper.compare(x1, y1, x2, y2) <= 0) {
                int temp = array[j];
                array[j] = array[j - 1];
                array[j - 1] = temp;
                if (--j <= 0) continue;
                if (array[j - 1] < length1) {
                    x1 = coords1[2 * array[j - 1]];
                    y1 = coords1[2 * array[j - 1] + 1];
                } else {
                    x1 = coords2[2 * (array[j - 1] - length1)];
                    y1 = coords2[2 * (array[j - 1] - length1) + 1];
                }
                if (array[j] < length1) {
                    x2 = coords1[2 * array[j]];
                    y2 = coords1[2 * array[j] + 1];
                    continue;
                }
                x2 = coords2[2 * (array[j] - length1)];
                y2 = coords2[2 * (array[j] - length1) + 1];
            }
            ++i;
        }
    }

    public boolean containsPoint(double[] point) {
        for (IntersectPoint ipoint : this.isectPoints) {
            if (ipoint.getX() != point[0] || ipoint.getY() != point[1]) continue;
            return true;
        }
        return false;
    }

    public static int compare(double x1, double y1, double x2, double y2) {
        if (x1 < x2 || x1 == x2 && y1 < y2) {
            return 1;
        }
        if (x1 == x2 && y1 == y2) {
            return 0;
        }
        return -1;
    }

    private static final class Edge {
        final int begIndex;
        final int endIndex;
        final int areaNumber;

        Edge(int begIndex, int endIndex, int areaNumber) {
            this.begIndex = begIndex;
            this.endIndex = endIndex;
            this.areaNumber = areaNumber;
        }

        boolean reverseCompare(int begIndex, int endIndex) {
            return this.begIndex == endIndex && this.endIndex == begIndex;
        }
    }
}

