/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.jce.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import repack.org.bouncycastle.asn1.ASN1Object;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.DERBitString;
import repack.org.bouncycastle.asn1.DEREncodable;
import repack.org.bouncycastle.asn1.DERInteger;
import repack.org.bouncycastle.asn1.DERNull;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERObjectIdentifier;
import repack.org.bouncycastle.asn1.DEROutputStream;
import repack.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import repack.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import repack.org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import repack.org.bouncycastle.asn1.x9.X962Parameters;
import repack.org.bouncycastle.asn1.x9.X9ECParameters;
import repack.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import repack.org.bouncycastle.crypto.params.ECDomainParameters;
import repack.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import repack.org.bouncycastle.jce.interfaces.ECPointEncoder;
import repack.org.bouncycastle.jce.interfaces.ECPrivateKey;
import repack.org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import repack.org.bouncycastle.jce.provider.JCEECPublicKey;
import repack.org.bouncycastle.jce.provider.PKCS12BagAttributeCarrierImpl;
import repack.org.bouncycastle.jce.provider.ProviderUtil;
import repack.org.bouncycastle.jce.provider.asymmetric.ec.ECUtil;
import repack.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import repack.org.bouncycastle.jce.spec.ECParameterSpec;
import repack.org.bouncycastle.jce.spec.ECPrivateKeySpec;
import repack.org.bouncycastle.math.ec.ECCurve;
import repack.org.bouncycastle.math.ec.ECPoint;

public class JCEECPrivateKey
implements ECPrivateKey,
PKCS12BagAttributeCarrier,
ECPointEncoder {
    private String algorithm = "EC";
    private BigInteger d;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private DERBitString publicKey;
    private PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected JCEECPrivateKey() {
    }

    JCEECPrivateKey(ECPrivateKey key) {
        this.d = key.getD();
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParameters();
    }

    public JCEECPrivateKey(String algorithm, ECPrivateKeySpec spec) {
        this.algorithm = algorithm;
        this.d = spec.getD();
        this.ecSpec = spec.getParams();
    }

    public JCEECPrivateKey(String algorithm, ECPrivateKeyParameters params, JCEECPublicKey pubKey, ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.d = params.getD();
        this.ecSpec = spec == null ? new ECParameterSpec(dp.getCurve(), dp.getG(), dp.getN(), dp.getH(), dp.getSeed()) : spec;
        this.publicKey = this.getPublicKeyDetails(pubKey);
    }

    public JCEECPrivateKey(String algorithm, ECPrivateKeyParameters params) {
        this.algorithm = algorithm;
        this.d = params.getD();
        this.ecSpec = null;
    }

    public JCEECPrivateKey(String algorithm, JCEECPrivateKey key) {
        this.algorithm = algorithm;
        this.d = key.d;
        this.ecSpec = key.ecSpec;
        this.withCompression = key.withCompression;
        this.publicKey = key.publicKey;
        this.attrCarrier = key.attrCarrier;
    }

    JCEECPrivateKey(PrivateKeyInfo info) {
        this.populateFromPrivKeyInfo(info);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo info) {
        X962Parameters params = new X962Parameters((DERObject)info.getAlgorithmId().getParameters());
        if (params.isNamedCurve()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
            X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
            this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName(oid), ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        } else if (params.isImplicitlyCA()) {
            this.ecSpec = null;
        } else {
            X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
            this.ecSpec = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
        }
        if (info.getPrivateKey() instanceof DERInteger) {
            DERInteger derD = (DERInteger)info.getPrivateKey();
            this.d = derD.getValue();
        } else {
            ECPrivateKeyStructure ec = new ECPrivateKeyStructure((ASN1Sequence)info.getPrivateKey());
            this.d = ec.getKey();
            this.publicKey = ec.getPublicKey();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        X962Parameters params = null;
        if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
            DERObjectIdentifier curveOid = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
            params = new X962Parameters(curveOid);
        } else if (this.ecSpec == null) {
            params = new X962Parameters(DERNull.INSTANCE);
        } else {
            ECPoint generator;
            ECParameterSpec p = this.ecSpec;
            ECCurve curve = p.getG().getCurve();
            if (curve instanceof ECCurve.Fp) {
                generator = new ECPoint.Fp(curve, p.getG().getX(), p.getG().getY(), this.withCompression);
            } else if (curve instanceof ECCurve.F2m) {
                generator = new ECPoint.F2m(curve, p.getG().getX(), p.getG().getY(), this.withCompression);
            } else {
                throw new UnsupportedOperationException("Subclass of ECPoint " + curve.getClass().toString() + "not supported");
            }
            X9ECParameters ecP = new X9ECParameters(p.getCurve(), generator, p.getN(), p.getH(), p.getSeed());
            params = new X962Parameters(ecP);
        }
        ECPrivateKeyStructure keyStructure = this.publicKey != null ? new ECPrivateKeyStructure(this.getD(), this.publicKey, params) : new ECPrivateKeyStructure(this.getD(), params);
        PrivateKeyInfo info = this.algorithm.equals("ECGOST3410") ? new PrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, params.getDERObject()), keyStructure.getDERObject()) : new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params.getDERObject()), keyStructure.getDERObject());
        try {
            dOut.writeObject(info);
            dOut.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error encoding EC private key");
        }
        return bOut.toByteArray();
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    @Override
    public BigInteger getD() {
        return this.d;
    }

    @Override
    public void setBagAttribute(DERObjectIdentifier oid, DEREncodable attribute) {
        this.attrCarrier.setBagAttribute(oid, attribute);
    }

    @Override
    public DEREncodable getBagAttribute(DERObjectIdentifier oid) {
        return this.attrCarrier.getBagAttribute(oid);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    @Override
    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return ProviderUtil.getEcImplicitlyCa();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JCEECPrivateKey)) {
            return false;
        }
        JCEECPrivateKey other = (JCEECPrivateKey)o;
        return this.getD().equals(other.getD()) && this.engineGetSpec().equals(other.engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private DERBitString getPublicKeyDetails(JCEECPublicKey pub) {
        try {
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(pub.getEncoded()));
            return info.getPublicKeyData();
        }
        catch (IOException e) {
            return null;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte[] enc = (byte[])in.readObject();
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(enc)));
        this.algorithm = (String)in.readObject();
        this.withCompression = in.readBoolean();
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
        this.attrCarrier.readObject(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getEncoded());
        out.writeObject(this.algorithm);
        out.writeBoolean(this.withCompression);
        this.attrCarrier.writeObject(out);
    }
}

