/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1.ess;

import repack.org.bouncycastle.asn1.ASN1Encodable;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERSequence;
import repack.org.bouncycastle.asn1.ess.ESSCertIDv2;
import repack.org.bouncycastle.asn1.x509.PolicyInformation;

public class SigningCertificateV2
extends ASN1Encodable {
    ASN1Sequence certs;
    ASN1Sequence policies;

    public static SigningCertificateV2 getInstance(Object o) {
        if (o == null || o instanceof SigningCertificateV2) {
            return (SigningCertificateV2)o;
        }
        if (o instanceof ASN1Sequence) {
            return new SigningCertificateV2((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in 'SigningCertificateV2' factory : " + o.getClass().getName() + ".");
    }

    public SigningCertificateV2(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.certs = ASN1Sequence.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.policies = ASN1Sequence.getInstance(seq.getObjectAt(1));
        }
    }

    public SigningCertificateV2(ESSCertIDv2[] certs) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < certs.length) {
            v.add(certs[i]);
            ++i;
        }
        this.certs = new DERSequence(v);
    }

    public SigningCertificateV2(ESSCertIDv2[] certs, PolicyInformation[] policies) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < certs.length) {
            v.add(certs[i]);
            ++i;
        }
        this.certs = new DERSequence(v);
        if (policies != null) {
            v = new ASN1EncodableVector();
            i = 0;
            while (i < policies.length) {
                v.add(policies[i]);
                ++i;
            }
            this.policies = new DERSequence(v);
        }
    }

    public ESSCertIDv2[] getCerts() {
        ESSCertIDv2[] certIds = new ESSCertIDv2[this.certs.size()];
        int i = 0;
        while (i != this.certs.size()) {
            certIds[i] = ESSCertIDv2.getInstance(this.certs.getObjectAt(i));
            ++i;
        }
        return certIds;
    }

    public PolicyInformation[] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        PolicyInformation[] policyInformations = new PolicyInformation[this.policies.size()];
        int i = 0;
        while (i != this.policies.size()) {
            policyInformations[i] = PolicyInformation.getInstance(this.policies.getObjectAt(i));
            ++i;
        }
        return policyInformations;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.certs);
        if (this.policies != null) {
            v.add(this.policies);
        }
        return new DERSequence(v);
    }
}

