/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1.cryptopro;

import java.math.BigInteger;
import java.util.Enumeration;
import repack.org.bouncycastle.asn1.ASN1Encodable;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.ASN1TaggedObject;
import repack.org.bouncycastle.asn1.DERInteger;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERSequence;

public class ECGOST3410ParamSetParameters
extends ASN1Encodable {
    DERInteger p;
    DERInteger q;
    DERInteger a;
    DERInteger b;
    DERInteger x;
    DERInteger y;

    public static ECGOST3410ParamSetParameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ECGOST3410ParamSetParameters.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static ECGOST3410ParamSetParameters getInstance(Object obj) {
        if (obj == null || obj instanceof ECGOST3410ParamSetParameters) {
            return (ECGOST3410ParamSetParameters)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ECGOST3410ParamSetParameters((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid GOST3410Parameter: " + obj.getClass().getName());
    }

    public ECGOST3410ParamSetParameters(BigInteger a, BigInteger b, BigInteger p, BigInteger q, int x, BigInteger y) {
        this.a = new DERInteger(a);
        this.b = new DERInteger(b);
        this.p = new DERInteger(p);
        this.q = new DERInteger(q);
        this.x = new DERInteger(x);
        this.y = new DERInteger(y);
    }

    public ECGOST3410ParamSetParameters(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.a = (DERInteger)e.nextElement();
        this.b = (DERInteger)e.nextElement();
        this.p = (DERInteger)e.nextElement();
        this.q = (DERInteger)e.nextElement();
        this.x = (DERInteger)e.nextElement();
        this.y = (DERInteger)e.nextElement();
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getA() {
        return this.a.getPositiveValue();
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.a);
        v.add(this.b);
        v.add(this.p);
        v.add(this.q);
        v.add(this.x);
        v.add(this.y);
        return new DERSequence(v);
    }
}

