/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1.cmp;

import repack.org.bouncycastle.asn1.ASN1Encodable;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERSequence;
import repack.org.bouncycastle.asn1.cmp.PKIMessage;

public class PKIMessages
extends ASN1Encodable {
    private ASN1Sequence content;

    private PKIMessages(ASN1Sequence seq) {
        this.content = seq;
    }

    public static PKIMessages getInstance(Object o) {
        if (o instanceof PKIMessages) {
            return (PKIMessages)o;
        }
        if (o instanceof ASN1Sequence) {
            return new PKIMessages((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public PKIMessages(PKIMessage msg) {
        this.content = new DERSequence(msg);
    }

    public PKIMessages(PKIMessage[] msgs) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < msgs.length) {
            v.add(msgs[i]);
            ++i;
        }
        this.content = new DERSequence(v);
    }

    public PKIMessage[] toPKIMessageArray() {
        PKIMessage[] result = new PKIMessage[this.content.size()];
        int i = 0;
        while (i != result.length) {
            result[i] = PKIMessage.getInstance(this.content.getObjectAt(i));
            ++i;
        }
        return result;
    }

    @Override
    public DERObject toASN1Object() {
        return this.content;
    }
}

