/*
 * Decompiled with CFR 0.152.
 */
package harmony.java.awt;

import harmony.java.awt.Point;
import harmony.java.awt.Rectangle;
import harmony.java.awt.Shape;
import harmony.java.awt.geom.AffineTransform;
import harmony.java.awt.geom.PathIterator;
import harmony.java.awt.geom.Point2D;
import harmony.java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.harmony.awt.gl.Crossing;
import org.apache.harmony.awt.internal.nls.Messages;

public class Polygon
implements Shape,
Serializable {
    private static final long serialVersionUID = -6460061437900069969L;
    private static final int BUFFER_CAPACITY = 4;
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException(Messages.getString("awt.111"));
        }
        if (npoints < 0) {
            throw new NegativeArraySizeException(Messages.getString("awt.112"));
        }
        this.npoints = npoints;
        this.xpoints = new int[npoints];
        this.ypoints = new int[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
    }

    public void invalidate() {
        this.bounds = null;
    }

    public void addPoint(int px, int py) {
        if (this.npoints == this.xpoints.length) {
            int[] tmp = new int[this.xpoints.length + 4];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.xpoints.length);
            this.xpoints = tmp;
            tmp = new int[this.ypoints.length + 4];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.ypoints.length);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = px;
        this.ypoints[this.npoints] = py;
        ++this.npoints;
        if (this.bounds != null) {
            this.bounds.setFrameFromDiagonal(Math.min(this.bounds.getMinX(), (double)px), Math.min(this.bounds.getMinY(), (double)py), Math.max(this.bounds.getMaxX(), (double)px), Math.max(this.bounds.getMaxY(), (double)py));
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.npoints == 0) {
            return new Rectangle();
        }
        int bx1 = this.xpoints[0];
        int by1 = this.ypoints[0];
        int bx2 = bx1;
        int by2 = by1;
        int i = 1;
        while (i < this.npoints) {
            int x = this.xpoints[i];
            int y = this.ypoints[i];
            if (x < bx1) {
                bx1 = x;
            } else if (x > bx2) {
                bx2 = x;
            }
            if (y < by1) {
                by1 = y;
            } else if (y > by2) {
                by2 = y;
            }
            ++i;
        }
        this.bounds = new Rectangle(bx1, by1, bx2 - bx1, by2 - by1);
        return this.bounds;
    }

    @Deprecated
    public Rectangle getBoundingBox() {
        return this.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds().getBounds2D();
    }

    public void translate(int mx, int my) {
        int i = 0;
        while (i < this.npoints) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + mx;
            int n2 = i++;
            this.ypoints[n2] = this.ypoints[n2] + my;
        }
        if (this.bounds != null) {
            this.bounds.translate(mx, my);
        }
    }

    @Deprecated
    public boolean inside(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Override
    public boolean contains(double x, double y) {
        return Crossing.isInsideEvenOdd(Crossing.crossShape(this, x, y));
    }

    @Override
    public boolean contains(double x, double y, double width, double height) {
        int cross = Crossing.intersectShape(this, x, y, width, height);
        return cross != 255 && Crossing.isInsideEvenOdd(cross);
    }

    @Override
    public boolean intersects(double x, double y, double width, double height) {
        int cross = Crossing.intersectShape(this, x, y, width, height);
        return cross == 255 || Crossing.isInsideEvenOdd(cross);
    }

    @Override
    public boolean contains(Rectangle2D rect) {
        return this.contains(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public boolean contains(Point point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public boolean intersects(Rectangle2D rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform t) {
        return new Iterator(t, this);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform t, double flatness) {
        return new Iterator(t, this);
    }

    class Iterator
    implements PathIterator {
        public Polygon p;
        public AffineTransform t;
        public int index;

        public Iterator(AffineTransform at, Polygon p) {
            this.p = p;
            this.t = at;
            if (p.npoints == 0) {
                this.index = 1;
            }
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > this.p.npoints;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.110"));
            }
            if (this.index == this.p.npoints) {
                return 4;
            }
            coords[0] = this.p.xpoints[this.index];
            coords[1] = this.p.ypoints[this.index];
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.110"));
            }
            if (this.index == this.p.npoints) {
                return 4;
            }
            coords[0] = this.p.xpoints[this.index];
            coords[1] = this.p.ypoints[this.index];
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

