/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.tsp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import repack.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import repack.org.bouncycastle.asn1.DERBoolean;
import repack.org.bouncycastle.asn1.DERGeneralizedTime;
import repack.org.bouncycastle.asn1.DERInteger;
import repack.org.bouncycastle.asn1.DERNull;
import repack.org.bouncycastle.asn1.DERSet;
import repack.org.bouncycastle.asn1.cms.Attribute;
import repack.org.bouncycastle.asn1.cms.AttributeTable;
import repack.org.bouncycastle.asn1.ess.ESSCertID;
import repack.org.bouncycastle.asn1.ess.SigningCertificate;
import repack.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import repack.org.bouncycastle.asn1.tsp.Accuracy;
import repack.org.bouncycastle.asn1.tsp.MessageImprint;
import repack.org.bouncycastle.asn1.tsp.TSTInfo;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.asn1.x509.GeneralName;
import repack.org.bouncycastle.cert.jcajce.JcaX509CRLHolder;
import repack.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import repack.org.bouncycastle.cms.CMSAttributeTableGenerationException;
import repack.org.bouncycastle.cms.CMSAttributeTableGenerator;
import repack.org.bouncycastle.cms.CMSException;
import repack.org.bouncycastle.cms.CMSProcessableByteArray;
import repack.org.bouncycastle.cms.CMSSignedData;
import repack.org.bouncycastle.cms.CMSSignedDataGenerator;
import repack.org.bouncycastle.cms.CMSSignedGenerator;
import repack.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import repack.org.bouncycastle.cms.SignerInfoGenerator;
import repack.org.bouncycastle.cms.SimpleAttributeTableGenerator;
import repack.org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import repack.org.bouncycastle.jce.interfaces.GOST3410PrivateKey;
import repack.org.bouncycastle.operator.OperatorCreationException;
import repack.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import repack.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import repack.org.bouncycastle.tsp.TSPException;
import repack.org.bouncycastle.tsp.TSPUtil;
import repack.org.bouncycastle.tsp.TimeStampRequest;
import repack.org.bouncycastle.tsp.TimeStampToken;
import repack.org.bouncycastle.util.CollectionStore;
import repack.org.bouncycastle.util.Store;

public class TimeStampTokenGenerator {
    int accuracySeconds = -1;
    int accuracyMillis = -1;
    int accuracyMicros = -1;
    boolean ordering = false;
    GeneralName tsa = null;
    private String tsaPolicyOID;
    PrivateKey key;
    X509Certificate cert;
    String digestOID;
    AttributeTable signedAttr;
    AttributeTable unsignedAttr;
    CertStore certsAndCrls;
    private List certs = new ArrayList();
    private List crls = new ArrayList();
    private List attrCerts = new ArrayList();
    private SignerInfoGenerator signerInfoGen;

    public TimeStampTokenGenerator(final SignerInfoGenerator signerInfoGen, ASN1ObjectIdentifier tsaPolicy) throws IllegalArgumentException, TSPException {
        this.signerInfoGen = signerInfoGen;
        this.tsaPolicyOID = tsaPolicy.getId();
        if (!signerInfoGen.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("SignerInfoGenerator must have an associated certificate");
        }
        TSPUtil.validateCertificate(signerInfoGen.getAssociatedCertificate());
        try {
            final ESSCertID essCertid = new ESSCertID(MessageDigest.getInstance("SHA-1").digest(signerInfoGen.getAssociatedCertificate().getEncoded()));
            this.signerInfoGen = new SignerInfoGenerator(signerInfoGen, new CMSAttributeTableGenerator(){

                @Override
                public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                    AttributeTable table = signerInfoGen.getSignedAttributeTableGenerator().getAttributes(parameters);
                    return table.add(PKCSObjectIdentifiers.id_aa_signingCertificate, new SigningCertificate(essCertid));
                }
            }, signerInfoGen.getUnsignedAttributeTableGenerator());
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSPException("Can't find a SHA-1 implementation.", e);
        }
        catch (IOException e) {
            throw new TSPException("Exception processing certificate.", e);
        }
    }

    public TimeStampTokenGenerator(PrivateKey key, X509Certificate cert, String digestOID, String tsaPolicyOID) throws IllegalArgumentException, TSPException {
        this(key, cert, digestOID, tsaPolicyOID, null, null);
    }

    public TimeStampTokenGenerator(PrivateKey key, X509Certificate cert, String digestOID, String tsaPolicyOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException, TSPException {
        this.key = key;
        this.cert = cert;
        this.digestOID = digestOID;
        this.tsaPolicyOID = tsaPolicyOID;
        this.unsignedAttr = unsignedAttr;
        Hashtable<ASN1ObjectIdentifier, Attribute> signedAttrs = null;
        signedAttrs = signedAttr != null ? signedAttr.toHashtable() : new Hashtable<ASN1ObjectIdentifier, Attribute>();
        TSPUtil.validateCertificate(cert);
        try {
            ESSCertID essCertid = new ESSCertID(MessageDigest.getInstance("SHA-1").digest(cert.getEncoded()));
            signedAttrs.put(PKCSObjectIdentifiers.id_aa_signingCertificate, new Attribute(PKCSObjectIdentifiers.id_aa_signingCertificate, new DERSet(new SigningCertificate(essCertid))));
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSPException("Can't find a SHA-1 implementation.", e);
        }
        catch (CertificateEncodingException e) {
            throw new TSPException("Exception processing certificate.", e);
        }
        this.signedAttr = new AttributeTable(signedAttrs);
    }

    public void setCertificatesAndCRLs(CertStore certificates) throws CertStoreException, TSPException {
        Collection<Object> c1 = certificates.getCertificates(null);
        Iterator<Object> it = c1.iterator();
        while (it.hasNext()) {
            try {
                this.certs.add(new JcaX509CertificateHolder((X509Certificate)it.next()));
            }
            catch (CertificateEncodingException e) {
                throw new TSPException("cannot encode certificate: " + e.getMessage(), e);
            }
        }
        c1 = certificates.getCRLs(null);
        it = c1.iterator();
        while (it.hasNext()) {
            try {
                this.crls.add(new JcaX509CRLHolder((X509CRL)it.next()));
            }
            catch (CRLException e) {
                throw new TSPException("cannot encode CRL: " + e.getMessage(), e);
            }
        }
    }

    public void addCertificates(Store certStore) {
        this.certs.addAll(certStore.getMatches(null));
    }

    public void addCRLs(Store crlStore) {
        this.crls.addAll(crlStore.getMatches(null));
    }

    public void addAttributeCertificates(Store attrStore) {
        this.attrCerts.addAll(attrStore.getMatches(null));
    }

    public void setAccuracySeconds(int accuracySeconds) {
        this.accuracySeconds = accuracySeconds;
    }

    public void setAccuracyMillis(int accuracyMillis) {
        this.accuracyMillis = accuracyMillis;
    }

    public void setAccuracyMicros(int accuracyMicros) {
        this.accuracyMicros = accuracyMicros;
    }

    public void setOrdering(boolean ordering) {
        this.ordering = ordering;
    }

    public void setTSA(GeneralName tsa) {
        this.tsa = tsa;
    }

    public TimeStampToken generate(TimeStampRequest request, BigInteger serialNumber, Date genTime, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, TSPException {
        if (this.signerInfoGen == null) {
            try {
                JcaSignerInfoGeneratorBuilder sigBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(provider).build());
                sigBuilder.setSignedAttributeGenerator(new DefaultSignedAttributeTableGenerator(this.signedAttr));
                if (this.unsignedAttr != null) {
                    sigBuilder.setUnsignedAttributeGenerator(new SimpleAttributeTableGenerator(this.unsignedAttr));
                }
                this.signerInfoGen = sigBuilder.build(new JcaContentSignerBuilder(this.getSigAlgorithm(this.key, this.digestOID)).setProvider(provider).build(this.key), this.cert);
            }
            catch (OperatorCreationException e) {
                throw new TSPException("Error generating signing operator", e);
            }
            catch (CertificateEncodingException e) {
                throw new TSPException("Error encoding certificate", e);
            }
        }
        return this.generate(request, serialNumber, genTime);
    }

    public TimeStampToken generate(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        if (this.signerInfoGen == null) {
            throw new IllegalStateException("can only use this method with SignerInfoGenerator constructor");
        }
        ASN1ObjectIdentifier digestAlgOID = new ASN1ObjectIdentifier(request.getMessageImprintAlgOID());
        AlgorithmIdentifier algID = new AlgorithmIdentifier(digestAlgOID, new DERNull());
        MessageImprint messageImprint = new MessageImprint(algID, request.getMessageImprintDigest());
        Accuracy accuracy = null;
        if (this.accuracySeconds > 0 || this.accuracyMillis > 0 || this.accuracyMicros > 0) {
            DERInteger seconds = null;
            if (this.accuracySeconds > 0) {
                seconds = new DERInteger(this.accuracySeconds);
            }
            DERInteger millis = null;
            if (this.accuracyMillis > 0) {
                millis = new DERInteger(this.accuracyMillis);
            }
            DERInteger micros = null;
            if (this.accuracyMicros > 0) {
                micros = new DERInteger(this.accuracyMicros);
            }
            accuracy = new Accuracy(seconds, millis, micros);
        }
        DERBoolean derOrdering = null;
        if (this.ordering) {
            derOrdering = new DERBoolean(this.ordering);
        }
        DERInteger nonce = null;
        if (request.getNonce() != null) {
            nonce = new DERInteger(request.getNonce());
        }
        ASN1ObjectIdentifier tsaPolicy = new ASN1ObjectIdentifier(this.tsaPolicyOID);
        if (request.getReqPolicy() != null) {
            tsaPolicy = new ASN1ObjectIdentifier(request.getReqPolicy());
        }
        TSTInfo tstInfo = new TSTInfo(tsaPolicy, messageImprint, new DERInteger(serialNumber), new DERGeneralizedTime(genTime), accuracy, derOrdering, nonce, this.tsa, request.getExtensions());
        try {
            CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
            if (request.getCertReq()) {
                signedDataGenerator.addCertificates(new CollectionStore(this.certs));
                signedDataGenerator.addCRLs(new CollectionStore(this.crls));
                signedDataGenerator.addAttributeCertificates(new CollectionStore(this.attrCerts));
            } else {
                signedDataGenerator.addCRLs(new CollectionStore(this.crls));
            }
            signedDataGenerator.addSignerInfoGenerator(this.signerInfoGen);
            byte[] derEncodedTSTInfo = tstInfo.getEncoded("DER");
            CMSSignedData signedData = signedDataGenerator.generate(new CMSProcessableByteArray(PKCSObjectIdentifiers.id_ct_TSTInfo, derEncodedTSTInfo), true);
            return new TimeStampToken(signedData);
        }
        catch (CMSException cmsEx) {
            throw new TSPException("Error generating time-stamp token", cmsEx);
        }
        catch (IOException e) {
            throw new TSPException("Exception encoding info", e);
        }
    }

    private String getSigAlgorithm(PrivateKey key, String digestOID) {
        String enc = null;
        if (key instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(key.getAlgorithm())) {
            enc = "RSA";
        } else if (key instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(key.getAlgorithm())) {
            enc = "DSA";
        } else if ("ECDSA".equalsIgnoreCase(key.getAlgorithm()) || "EC".equalsIgnoreCase(key.getAlgorithm())) {
            enc = "ECDSA";
        } else if (key instanceof GOST3410PrivateKey || "GOST3410".equalsIgnoreCase(key.getAlgorithm())) {
            enc = "GOST3410";
        } else if ("ECGOST3410".equalsIgnoreCase(key.getAlgorithm())) {
            enc = CMSSignedGenerator.ENCRYPTION_ECGOST3410;
        }
        return String.valueOf(TSPUtil.getDigestAlgName(digestOID)) + "with" + enc;
    }
}

