/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import repack.org.bouncycastle.asn1.ASN1Object;
import repack.org.bouncycastle.asn1.ASN1OctetString;
import repack.org.bouncycastle.asn1.DEROctetString;
import repack.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import repack.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import repack.org.bouncycastle.asn1.cms.RecipientIdentifier;
import repack.org.bouncycastle.asn1.cms.RecipientInfo;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import repack.org.bouncycastle.asn1.x509.TBSCertificateStructure;
import repack.org.bouncycastle.cms.CMSEnvelopedHelper;
import repack.org.bouncycastle.cms.CMSUtils;
import repack.org.bouncycastle.cms.IntRecipientInfoGenerator;

class KeyTransIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private TBSCertificateStructure recipientTBSCert;
    private PublicKey recipientPublicKey;
    private ASN1OctetString subjectKeyIdentifier;
    private SubjectPublicKeyInfo info;

    KeyTransIntRecipientInfoGenerator() {
    }

    void setRecipientCert(X509Certificate recipientCert) {
        this.recipientTBSCert = CMSUtils.getTBSCertificateStructure(recipientCert);
        this.recipientPublicKey = recipientCert.getPublicKey();
        this.info = this.recipientTBSCert.getSubjectPublicKeyInfo();
    }

    void setRecipientPublicKey(PublicKey recipientPublicKey) {
        this.recipientPublicKey = recipientPublicKey;
        try {
            this.info = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(recipientPublicKey.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't extract key algorithm from this key");
        }
    }

    void setSubjectKeyIdentifier(ASN1OctetString subjectKeyIdentifier) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
    }

    @Override
    public RecipientInfo generate(SecretKey contentEncryptionKey, SecureRandom random, Provider prov) throws GeneralSecurityException {
        RecipientIdentifier recipId;
        AlgorithmIdentifier keyEncryptionAlgorithm = this.info.getAlgorithmId();
        byte[] encryptedKeyBytes = null;
        Cipher keyEncryptionCipher = CMSEnvelopedHelper.INSTANCE.createAsymmetricCipher(keyEncryptionAlgorithm.getObjectId().getId(), prov);
        try {
            keyEncryptionCipher.init(3, (Key)this.recipientPublicKey, random);
            encryptedKeyBytes = keyEncryptionCipher.wrap(contentEncryptionKey);
        }
        catch (GeneralSecurityException generalSecurityException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (ProviderException providerException) {
            // empty catch block
        }
        if (encryptedKeyBytes == null) {
            keyEncryptionCipher.init(1, (Key)this.recipientPublicKey, random);
            encryptedKeyBytes = keyEncryptionCipher.doFinal(contentEncryptionKey.getEncoded());
        }
        if (this.recipientTBSCert != null) {
            IssuerAndSerialNumber issuerAndSerial = new IssuerAndSerialNumber(this.recipientTBSCert.getIssuer(), this.recipientTBSCert.getSerialNumber().getValue());
            recipId = new RecipientIdentifier(issuerAndSerial);
        } else {
            recipId = new RecipientIdentifier(this.subjectKeyIdentifier);
        }
        return new RecipientInfo(new KeyTransRecipientInfo(recipId, keyEncryptionAlgorithm, new DEROctetString(encryptedKeyBytes)));
    }
}

