/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Object;
import repack.org.bouncycastle.asn1.DERNull;
import repack.org.bouncycastle.asn1.DERObjectIdentifier;
import repack.org.bouncycastle.asn1.DEROctetString;
import repack.org.bouncycastle.asn1.DERSequence;
import repack.org.bouncycastle.asn1.cms.KeyAgreeRecipientIdentifier;
import repack.org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import repack.org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import repack.org.bouncycastle.asn1.cms.OriginatorPublicKey;
import repack.org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import repack.org.bouncycastle.asn1.cms.RecipientInfo;
import repack.org.bouncycastle.asn1.cms.ecc.MQVuserKeyingMaterial;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import repack.org.bouncycastle.cms.CMSEnvelopedGenerator;
import repack.org.bouncycastle.cms.CMSEnvelopedHelper;
import repack.org.bouncycastle.cms.CMSUtils;
import repack.org.bouncycastle.cms.IntRecipientInfoGenerator;
import repack.org.bouncycastle.jce.interfaces.ECPublicKey;
import repack.org.bouncycastle.jce.spec.ECParameterSpec;
import repack.org.bouncycastle.jce.spec.MQVPrivateKeySpec;
import repack.org.bouncycastle.jce.spec.MQVPublicKeySpec;

class KeyAgreeIntRecipientInfoGenerator
implements IntRecipientInfoGenerator {
    private DERObjectIdentifier keyAgreementOID;
    private DERObjectIdentifier keyEncryptionOID;
    private ArrayList recipientCerts;
    private KeyPair senderKeyPair;

    KeyAgreeIntRecipientInfoGenerator() {
    }

    void setKeyAgreementOID(DERObjectIdentifier keyAgreementOID) {
        this.keyAgreementOID = keyAgreementOID;
    }

    void setKeyEncryptionOID(DERObjectIdentifier keyEncryptionOID) {
        this.keyEncryptionOID = keyEncryptionOID;
    }

    void setRecipientCerts(Collection recipientCerts) {
        this.recipientCerts = new ArrayList(recipientCerts);
    }

    void setSenderKeyPair(KeyPair senderKeyPair) {
        this.senderKeyPair = senderKeyPair;
    }

    @Override
    public RecipientInfo generate(SecretKey contentEncryptionKey, SecureRandom random, Provider prov) throws GeneralSecurityException {
        OriginatorIdentifierOrKey originator;
        PublicKey senderPublicKey = this.senderKeyPair.getPublic();
        PrivateKey senderPrivateKey = this.senderKeyPair.getPrivate();
        try {
            originator = new OriginatorIdentifierOrKey(KeyAgreeIntRecipientInfoGenerator.createOriginatorPublicKey(senderPublicKey));
        }
        catch (IOException e) {
            throw new InvalidKeyException("cannot extract originator public key: " + e);
        }
        DEROctetString ukm = null;
        if (this.keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
            try {
                ECParameterSpec ecParamSpec = ((ECPublicKey)senderPublicKey).getParameters();
                KeyPairGenerator ephemKPG = KeyPairGenerator.getInstance(this.keyAgreementOID.getId(), prov);
                ephemKPG.initialize(ecParamSpec, random);
                KeyPair ephemKP = ephemKPG.generateKeyPair();
                ukm = new DEROctetString(new MQVuserKeyingMaterial(KeyAgreeIntRecipientInfoGenerator.createOriginatorPublicKey(ephemKP.getPublic()), null));
                senderPrivateKey = new MQVPrivateKeySpec(senderPrivateKey, ephemKP.getPrivate(), ephemKP.getPublic());
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidKeyException("cannot determine MQV ephemeral key pair parameters from public key: " + e);
            }
            catch (IOException e) {
                throw new InvalidKeyException("cannot extract MQV ephemeral public key: " + e);
            }
        }
        ASN1EncodableVector params = new ASN1EncodableVector();
        params.add(this.keyEncryptionOID);
        params.add(DERNull.INSTANCE);
        AlgorithmIdentifier keyEncAlg = new AlgorithmIdentifier(this.keyAgreementOID, new DERSequence(params));
        ASN1EncodableVector recipientEncryptedKeys = new ASN1EncodableVector();
        for (X509Certificate recipientCert : this.recipientCerts) {
            KeyAgreeRecipientIdentifier karid = new KeyAgreeRecipientIdentifier(CMSUtils.getIssuerAndSerialNumber(recipientCert));
            PublicKey recipientPublicKey = recipientCert.getPublicKey();
            if (this.keyAgreementOID.getId().equals(CMSEnvelopedGenerator.ECMQV_SHA1KDF)) {
                recipientPublicKey = new MQVPublicKeySpec(recipientPublicKey, recipientPublicKey);
            }
            KeyAgreement keyAgreement = KeyAgreement.getInstance(this.keyAgreementOID.getId(), prov);
            keyAgreement.init((Key)senderPrivateKey, random);
            keyAgreement.doPhase(recipientPublicKey, true);
            SecretKey keyEncryptionKey = keyAgreement.generateSecret(this.keyEncryptionOID.getId());
            Cipher keyEncryptionCipher = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(this.keyEncryptionOID.getId(), prov);
            keyEncryptionCipher.init(3, (Key)keyEncryptionKey, random);
            byte[] encryptedKeyBytes = keyEncryptionCipher.wrap(contentEncryptionKey);
            DEROctetString encryptedKey = new DEROctetString(encryptedKeyBytes);
            recipientEncryptedKeys.add(new RecipientEncryptedKey(karid, encryptedKey));
        }
        return new RecipientInfo(new KeyAgreeRecipientInfo(originator, ukm, keyEncAlg, new DERSequence(recipientEncryptedKeys)));
    }

    private static OriginatorPublicKey createOriginatorPublicKey(PublicKey publicKey) throws IOException {
        SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance(ASN1Object.fromByteArray(publicKey.getEncoded()));
        return new OriginatorPublicKey(new AlgorithmIdentifier(spki.getAlgorithmId().getObjectId(), DERNull.INSTANCE), spki.getPublicKeyData().getBytes());
    }
}

