/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cms;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import repack.org.bouncycastle.asn1.ASN1Set;
import repack.org.bouncycastle.asn1.BERConstructedOctetString;
import repack.org.bouncycastle.asn1.DERNull;
import repack.org.bouncycastle.asn1.DERObjectIdentifier;
import repack.org.bouncycastle.asn1.DEROctetString;
import repack.org.bouncycastle.asn1.DEROutputStream;
import repack.org.bouncycastle.asn1.DERSet;
import repack.org.bouncycastle.asn1.cms.AttributeTable;
import repack.org.bouncycastle.asn1.cms.CMSAttributes;
import repack.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import repack.org.bouncycastle.asn1.cms.ContentInfo;
import repack.org.bouncycastle.asn1.cms.SignedData;
import repack.org.bouncycastle.asn1.cms.SignerIdentifier;
import repack.org.bouncycastle.asn1.cms.SignerInfo;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.cms.CMSAttributeTableGenerator;
import repack.org.bouncycastle.cms.CMSException;
import repack.org.bouncycastle.cms.CMSProcessable;
import repack.org.bouncycastle.cms.CMSProcessableByteArray;
import repack.org.bouncycastle.cms.CMSSignedData;
import repack.org.bouncycastle.cms.CMSSignedGenerator;
import repack.org.bouncycastle.cms.CMSSignedHelper;
import repack.org.bouncycastle.cms.CMSTypedData;
import repack.org.bouncycastle.cms.CMSUtils;
import repack.org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import repack.org.bouncycastle.cms.DigOutputStream;
import repack.org.bouncycastle.cms.SigOutputStream;
import repack.org.bouncycastle.cms.SignerInfoGenerator;
import repack.org.bouncycastle.cms.SignerInformation;
import repack.org.bouncycastle.cms.SignerInformationStore;
import repack.org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID) throws IllegalArgumentException {
        this.doAddSigner(key, CMSSignedDataGenerator.getSignerIdentifier(cert), encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID) throws IllegalArgumentException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID) throws IllegalArgumentException {
        this.doAddSigner(key, CMSSignedDataGenerator.getSignerIdentifier(subjectKeyID), encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID, signedAttr, unsignedAttr);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.doAddSigner(key, CMSSignedDataGenerator.getSignerIdentifier(cert), encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID, signedAttr, unsignedAttr);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        this.doAddSigner(key, CMSSignedDataGenerator.getSignerIdentifier(subjectKeyID), encryptionOID, digestOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.addSigner(key, cert, this.getEncOID(key, digestOID), digestOID, signedAttrGen, unsignedAttrGen);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.doAddSigner(key, CMSSignedDataGenerator.getSignerIdentifier(cert), encryptionOID, digestOID, signedAttrGen, unsignedAttrGen, null);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.addSigner(key, subjectKeyID, this.getEncOID(key, digestOID), digestOID, signedAttrGen, unsignedAttrGen);
    }

    public void addSigner(PrivateKey key, byte[] subjectKeyID, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        this.doAddSigner(key, CMSSignedDataGenerator.getSignerIdentifier(subjectKeyID), encryptionOID, digestOID, signedAttrGen, unsignedAttrGen, null);
    }

    private void doAddSigner(PrivateKey key, SignerIdentifier signerIdentifier, String encryptionOID, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen, AttributeTable baseSignedTable) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(key, signerIdentifier, digestOID, encryptionOID, signedAttrGen, unsignedAttrGen, baseSignedTable));
    }

    public CMSSignedData generate(CMSProcessable content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, CMSUtils.getProvider(sigProvider));
    }

    public CMSSignedData generate(CMSProcessable content, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(content, false, sigProvider);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(eContentType, content, encapsulate, CMSUtils.getProvider(sigProvider), true);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(eContentType, content, encapsulate, sigProvider, true);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, String sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(eContentType, content, encapsulate, CMSUtils.getProvider(sigProvider), addDefaultAttributes);
    }

    public CMSSignedData generate(String eContentType, CMSProcessable content, boolean encapsulate, Provider sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, CMSException {
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            signerInfos.add(signer.toSignerInfo());
        }
        boolean isCounterSignature = eContentType == null;
        ASN1ObjectIdentifier contentTypeOID = isCounterSignature ? null : new ASN1ObjectIdentifier(eContentType);
        for (SignerInfoGenerator sGen : this.signerGens) {
            if (content != null) {
                OutputStream cOut = sGen.getCalculatingOutputStream();
                try {
                    content.write(cOut);
                    cOut.close();
                }
                catch (IOException e) {
                    throw new CMSException("data processing exception: " + e.getMessage(), e);
                }
            }
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add(inf.getDigestAlgorithm());
            signerInfos.add(inf);
        }
        for (SignerInf signer : this.signerInfs) {
            try {
                digestAlgs.add(signer.getDigestAlgorithmID());
                signerInfos.add(signer.toSignerInfo(contentTypeOID, content, this.rand, sigProvider, addDefaultAttributes));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for signature.", e);
            }
            catch (SignatureException e) {
                throw new CMSException("error creating signature.", e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", e);
            }
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        BERConstructedOctetString octs = null;
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            if (content != null) {
                try {
                    content.write(bOut);
                }
                catch (IOException e) {
                    throw new CMSException("encapsulation error.", e);
                }
            }
            octs = new BERConstructedOctetString(bOut.toByteArray());
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, sd);
        return new CMSSignedData(content, contentInfo);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (content instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)content).getContentType().getId(), content, encapsulate, sigProvider);
        }
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        if (content instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)content).getContentType().getId(), content, encapsulate, sigProvider);
        }
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    public CMSSignedData generate(CMSTypedData content) throws CMSException {
        return this.generate(content, false);
    }

    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        ByteArrayOutputStream bOut;
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            digestAlgs.add(CMSSignedHelper.INSTANCE.fixAlgID(signer.getDigestAlgorithmID()));
            signerInfos.add(signer.toSignerInfo());
        }
        ASN1ObjectIdentifier contentTypeOID = content.getContentType();
        BERConstructedOctetString octs = null;
        if (encapsulate) {
            bOut = new ByteArrayOutputStream();
            if (content != null) {
                try {
                    content.write(bOut);
                }
                catch (IOException e) {
                    throw new CMSException("encapsulation error.", e);
                }
            }
            octs = new BERConstructedOctetString(bOut.toByteArray());
        }
        if (content != null) {
            bOut = null;
            if (encapsulate) {
                bOut = new ByteArrayOutputStream();
            }
            OutputStream cOut = CMSUtils.attachSignersToOutputStream(this.signerGens, bOut);
            cOut = CMSUtils.getSafeOutputStream(cOut);
            try {
                content.write(cOut);
                cOut.close();
            }
            catch (IOException e) {
                throw new CMSException("data processing exception: " + e.getMessage(), e);
            }
            if (encapsulate) {
                octs = new BERConstructedOctetString(bOut.toByteArray());
            }
        }
        for (SignerInfoGenerator sGen : this.signerGens) {
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add(inf.getDigestAlgorithm());
            signerInfos.add(inf);
            byte[] calcDigest = sGen.getCalculatedDigest();
            if (calcDigest == null) continue;
            this.digests.put(inf.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, sd);
        return new CMSSignedData((CMSProcessable)content, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer, Provider sigProvider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signer.getSignature()), false, sigProvider).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signer.getSignature()), false, CMSUtils.getProvider(sigProvider)).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(new CMSProcessableByteArray(null, signer.getSignature()), false).getSignerInfos();
    }

    private class SignerInf {
        final PrivateKey key;
        final SignerIdentifier signerIdentifier;
        final String digestOID;
        final String encOID;
        final CMSAttributeTableGenerator sAttr;
        final CMSAttributeTableGenerator unsAttr;
        final AttributeTable baseSignedTable;

        SignerInf(PrivateKey key, SignerIdentifier signerIdentifier, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSignedTable) {
            this.key = key;
            this.signerIdentifier = signerIdentifier;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSignedTable;
        }

        AlgorithmIdentifier getDigestAlgorithmID() {
            return new AlgorithmIdentifier(new DERObjectIdentifier(this.digestOID), new DERNull());
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, CMSProcessable content, SecureRandom random, Provider sigProvider, boolean addDefaultAttributes) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            AttributeTable signed;
            AlgorithmIdentifier digAlgId = this.getDigestAlgorithmID();
            String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String signatureName = String.valueOf(digestName) + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
            MessageDigest dig = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, sigProvider);
            AlgorithmIdentifier encAlgId = CMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.encOID, sig);
            if (content != null) {
                content.write(new DigOutputStream(dig));
            }
            byte[] hash = dig.digest();
            CMSSignedDataGenerator.this.digests.put(this.digestOID, hash.clone());
            if (addDefaultAttributes) {
                Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                signed = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            } else {
                signed = this.baseSignedTable;
            }
            sig.initSign(this.key, random);
            BufferedOutputStream sigStr = new BufferedOutputStream(new SigOutputStream(sig));
            ASN1Set signedAttr = null;
            if (signed != null) {
                if (contentType == null && signed.get(CMSAttributes.contentType) != null) {
                    Hashtable tmpSigned = signed.toHashtable();
                    tmpSigned.remove(CMSAttributes.contentType);
                    signed = new AttributeTable(tmpSigned);
                }
                signedAttr = CMSSignedDataGenerator.this.getAttributeSet(signed);
                new DEROutputStream(sigStr).writeObject(signedAttr);
            } else if (content != null) {
                content.write(sigStr);
            }
            ((OutputStream)sigStr).close();
            byte[] sigBytes = sig.sign();
            ASN1Set unsignedAttr = null;
            if (this.unsAttr != null) {
                Map parameters = CMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                parameters.put("encryptedDigest", sigBytes.clone());
                AttributeTable unsigned = this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters));
                unsignedAttr = CMSSignedDataGenerator.this.getAttributeSet(unsigned);
            }
            return new SignerInfo(this.signerIdentifier, digAlgId, signedAttr, encAlgId, new DEROctetString(sigBytes), unsignedAttr);
        }
    }
}

