/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import repack.org.bouncycastle.asn1.ASN1Encodable;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERSequence;
import repack.org.bouncycastle.asn1.x509.Target;
import repack.org.bouncycastle.asn1.x509.Targets;

public class TargetInformation
extends ASN1Encodable {
    private ASN1Sequence targets;

    public static TargetInformation getInstance(Object obj) {
        if (obj instanceof TargetInformation) {
            return (TargetInformation)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new TargetInformation((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass());
    }

    private TargetInformation(ASN1Sequence seq) {
        this.targets = seq;
    }

    public Targets[] getTargetsObjects() {
        Targets[] copy = new Targets[this.targets.size()];
        int count = 0;
        Enumeration e = this.targets.getObjects();
        while (e.hasMoreElements()) {
            copy[count++] = Targets.getInstance(e.nextElement());
        }
        return copy;
    }

    public TargetInformation(Targets targets) {
        this.targets = new DERSequence(targets);
    }

    public TargetInformation(Target[] targets) {
        this(new Targets(targets));
    }

    @Override
    public DERObject toASN1Object() {
        return this.targets;
    }
}

