/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1.esf;

import java.io.IOException;
import repack.org.bouncycastle.asn1.ASN1Encodable;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Object;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERObjectIdentifier;
import repack.org.bouncycastle.asn1.DERSequence;

public class OtherRevVals
extends ASN1Encodable {
    private DERObjectIdentifier otherRevValType;
    private ASN1Object otherRevVals;

    public static OtherRevVals getInstance(Object obj) {
        if (obj == null || obj instanceof OtherRevVals) {
            return (OtherRevVals)obj;
        }
        return new OtherRevVals((ASN1Sequence)obj);
    }

    public OtherRevVals(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.otherRevValType = (DERObjectIdentifier)seq.getObjectAt(0);
        try {
            this.otherRevVals = ASN1Object.fromByteArray(seq.getObjectAt(1).getDERObject().getDEREncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public OtherRevVals(DERObjectIdentifier otherRevValType, ASN1Object otherRevVals) {
        this.otherRevValType = otherRevValType;
        this.otherRevVals = otherRevVals;
    }

    public DERObjectIdentifier getOtherRevValType() {
        return this.otherRevValType;
    }

    public ASN1Object getOtherRevVals() {
        return this.otherRevVals;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.otherRevValType);
        v.add(this.otherRevVals);
        return new DERSequence(v);
    }
}

