/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import repack.org.bouncycastle.asn1.DEREncodable;
import repack.org.bouncycastle.asn1.DEROutputStream;
import repack.org.bouncycastle.asn1.DERSequence;
import repack.org.bouncycastle.asn1.LazyDERConstructionEnumeration;

public class LazyDERSequence
extends DERSequence {
    private byte[] encoded;
    private boolean parsed = false;
    private int size = -1;

    LazyDERSequence(byte[] encoded) throws IOException {
        this.encoded = encoded;
    }

    private void parse() {
        LazyDERConstructionEnumeration en = new LazyDERConstructionEnumeration(this.encoded);
        while (en.hasMoreElements()) {
            this.addObject((DEREncodable)en.nextElement());
        }
        this.parsed = true;
    }

    @Override
    public synchronized DEREncodable getObjectAt(int index) {
        if (!this.parsed) {
            this.parse();
        }
        return super.getObjectAt(index);
    }

    @Override
    public synchronized Enumeration getObjects() {
        if (this.parsed) {
            return super.getObjects();
        }
        return new LazyDERConstructionEnumeration(this.encoded);
    }

    @Override
    public int size() {
        if (this.size < 0) {
            LazyDERConstructionEnumeration en = new LazyDERConstructionEnumeration(this.encoded);
            this.size = 0;
            while (en.hasMoreElements()) {
                en.nextElement();
                ++this.size;
            }
        }
        return this.size;
    }

    @Override
    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(48, this.encoded);
    }
}

