/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import repack.org.bouncycastle.asn1.ASN1OctetStringParser;
import repack.org.bouncycastle.asn1.ASN1ParsingException;
import repack.org.bouncycastle.asn1.ASN1StreamParser;
import repack.org.bouncycastle.asn1.BERConstructedOctetString;
import repack.org.bouncycastle.asn1.ConstructedOctetStream;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.util.io.Streams;

public class BEROctetStringParser
implements ASN1OctetStringParser {
    private ASN1StreamParser _parser;

    BEROctetStringParser(ASN1StreamParser parser) {
        this._parser = parser;
    }

    @Override
    public InputStream getOctetStream() {
        return new ConstructedOctetStream(this._parser);
    }

    @Override
    public DERObject getLoadedObject() throws IOException {
        return new BERConstructedOctetString(Streams.readAll(this.getOctetStream()));
    }

    @Override
    public DERObject getDERObject() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException e) {
            throw new ASN1ParsingException("IOException converting stream to byte array: " + e.getMessage(), e);
        }
    }
}

