/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Exception;
import repack.org.bouncycastle.asn1.ASN1InputStream;
import repack.org.bouncycastle.asn1.BERApplicationSpecificParser;
import repack.org.bouncycastle.asn1.BERFactory;
import repack.org.bouncycastle.asn1.BEROctetStringParser;
import repack.org.bouncycastle.asn1.BERSequenceParser;
import repack.org.bouncycastle.asn1.BERSetParser;
import repack.org.bouncycastle.asn1.BERTaggedObject;
import repack.org.bouncycastle.asn1.BERTaggedObjectParser;
import repack.org.bouncycastle.asn1.DERApplicationSpecific;
import repack.org.bouncycastle.asn1.DEREncodable;
import repack.org.bouncycastle.asn1.DERExternalParser;
import repack.org.bouncycastle.asn1.DERFactory;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DEROctetString;
import repack.org.bouncycastle.asn1.DEROctetStringParser;
import repack.org.bouncycastle.asn1.DERSequenceParser;
import repack.org.bouncycastle.asn1.DERSetParser;
import repack.org.bouncycastle.asn1.DERTaggedObject;
import repack.org.bouncycastle.asn1.DERUnknownTag;
import repack.org.bouncycastle.asn1.DefiniteLengthInputStream;
import repack.org.bouncycastle.asn1.InMemoryRepresentable;
import repack.org.bouncycastle.asn1.IndefiniteLengthInputStream;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;

    public ASN1StreamParser(InputStream in) {
        this(in, ASN1InputStream.findLimit(in));
    }

    public ASN1StreamParser(InputStream in, int limit) {
        this._in = in;
        this._limit = limit;
    }

    public ASN1StreamParser(byte[] encoding) {
        this(new ByteArrayInputStream(encoding), encoding.length);
    }

    DEREncodable readIndef(int tagValue) throws IOException {
        switch (tagValue) {
            case 8: {
                return new DERExternalParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 16: {
                return new BERSequenceParser(this);
            }
            case 17: {
                return new BERSetParser(this);
            }
        }
        throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(tagValue));
    }

    DEREncodable readImplicit(boolean constructed, int tag) throws IOException {
        if (this._in instanceof IndefiniteLengthInputStream) {
            if (!constructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            return this.readIndef(tag);
        }
        if (constructed) {
            switch (tag) {
                case 17: {
                    return new DERSetParser(this);
                }
                case 16: {
                    return new DERSequenceParser(this);
                }
                case 4: {
                    return new BEROctetStringParser(this);
                }
            }
        } else {
            switch (tag) {
                case 17: {
                    throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
                }
                case 16: {
                    throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
                }
                case 4: {
                    return new DEROctetStringParser((DefiniteLengthInputStream)this._in);
                }
            }
        }
        throw new RuntimeException("implicit tagging not implemented");
    }

    DERObject readTaggedObject(boolean constructed, int tag) throws IOException {
        if (!constructed) {
            DefiniteLengthInputStream defIn = (DefiniteLengthInputStream)this._in;
            return new DERTaggedObject(false, tag, new DEROctetString(defIn.toByteArray()));
        }
        ASN1EncodableVector v = this.readVector();
        if (this._in instanceof IndefiniteLengthInputStream) {
            return v.size() == 1 ? new BERTaggedObject(true, tag, v.get(0)) : new BERTaggedObject(false, tag, BERFactory.createSequence(v));
        }
        return v.size() == 1 ? new DERTaggedObject(true, tag, v.get(0)) : new DERTaggedObject(false, tag, DERFactory.createSequence(v));
    }

    public DEREncodable readObject() throws IOException {
        int tag = this._in.read();
        if (tag == -1) {
            return null;
        }
        this.set00Check(false);
        int tagNo = ASN1InputStream.readTagNumber(this._in, tag);
        boolean isConstructed = (tag & 0x20) != 0;
        int length = ASN1InputStream.readLength(this._in, this._limit);
        if (length < 0) {
            if (!isConstructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indIn = new IndefiniteLengthInputStream(this._in, this._limit);
            ASN1StreamParser sp = new ASN1StreamParser(indIn, this._limit);
            if ((tag & 0x40) != 0) {
                return new BERApplicationSpecificParser(tagNo, sp);
            }
            if ((tag & 0x80) != 0) {
                return new BERTaggedObjectParser(true, tagNo, sp);
            }
            return sp.readIndef(tagNo);
        }
        DefiniteLengthInputStream defIn = new DefiniteLengthInputStream(this._in, length);
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(isConstructed, tagNo, defIn.toByteArray());
        }
        if ((tag & 0x80) != 0) {
            return new BERTaggedObjectParser(isConstructed, tagNo, new ASN1StreamParser(defIn));
        }
        if (isConstructed) {
            switch (tagNo) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(defIn));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(defIn));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(defIn));
                }
                case 8: {
                    return new DERExternalParser(new ASN1StreamParser(defIn));
                }
            }
            return new DERUnknownTag(true, tagNo, defIn.toByteArray());
        }
        switch (tagNo) {
            case 4: {
                return new DEROctetStringParser(defIn);
            }
        }
        try {
            return ASN1InputStream.createPrimitiveDERObject(tagNo, defIn.toByteArray());
        }
        catch (IllegalArgumentException e) {
            throw new ASN1Exception("corrupted stream detected", e);
        }
    }

    private void set00Check(boolean enabled) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(enabled);
        }
    }

    ASN1EncodableVector readVector() throws IOException {
        DEREncodable obj;
        ASN1EncodableVector v = new ASN1EncodableVector();
        while ((obj = this.readObject()) != null) {
            if (obj instanceof InMemoryRepresentable) {
                v.add(((InMemoryRepresentable)((Object)obj)).getLoadedObject());
                continue;
            }
            v.add(obj.getDERObject());
        }
        return v;
    }
}

