/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import repack.org.bouncycastle.asn1.ASN1Object;
import repack.org.bouncycastle.asn1.ASN1SequenceParser;
import repack.org.bouncycastle.asn1.ASN1Set;
import repack.org.bouncycastle.asn1.ASN1TaggedObject;
import repack.org.bouncycastle.asn1.BERSequence;
import repack.org.bouncycastle.asn1.BERTaggedObject;
import repack.org.bouncycastle.asn1.DEREncodable;
import repack.org.bouncycastle.asn1.DERNull;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DEROutputStream;
import repack.org.bouncycastle.asn1.DERSequence;

public abstract class ASN1Sequence
extends ASN1Object {
    private Vector seq = new Vector();

    public static ASN1Sequence getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Sequence) {
            return (ASN1Sequence)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1Sequence.getInstance(ASN1Object.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Sequence)obj.getObject();
        }
        if (obj.isExplicit()) {
            if (obj instanceof BERTaggedObject) {
                return new BERSequence(obj.getObject());
            }
            return new DERSequence(obj.getObject());
        }
        if (obj.getObject() instanceof ASN1Sequence) {
            return (ASN1Sequence)obj.getObject();
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public Enumeration getObjects() {
        return this.seq.elements();
    }

    public ASN1SequenceParser parser() {
        final ASN1Sequence outer = this;
        return new ASN1SequenceParser(){
            private final int max;
            private int index;
            {
                this.max = ASN1Sequence.this.size();
            }

            @Override
            public DEREncodable readObject() throws IOException {
                DEREncodable obj;
                if (this.index == this.max) {
                    return null;
                }
                if ((obj = ASN1Sequence.this.getObjectAt(this.index++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)obj).parser();
                }
                if (obj instanceof ASN1Set) {
                    return ((ASN1Set)obj).parser();
                }
                return obj;
            }

            @Override
            public DERObject getLoadedObject() {
                return outer;
            }

            @Override
            public DERObject getDERObject() {
                return outer;
            }
        };
    }

    public DEREncodable getObjectAt(int index) {
        return (DEREncodable)this.seq.elementAt(index);
    }

    public int size() {
        return this.seq.size();
    }

    @Override
    public int hashCode() {
        Enumeration e = this.getObjects();
        int hashCode = this.size();
        while (e.hasMoreElements()) {
            DEREncodable o = this.getNext(e);
            hashCode *= 17;
            hashCode ^= o.hashCode();
        }
        return hashCode;
    }

    @Override
    boolean asn1Equals(DERObject o) {
        if (!(o instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence other = (ASN1Sequence)o;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration s1 = this.getObjects();
        Enumeration s2 = other.getObjects();
        while (s1.hasMoreElements()) {
            DERObject o2;
            DEREncodable obj1 = this.getNext(s1);
            DEREncodable obj2 = this.getNext(s2);
            DERObject o1 = obj1.getDERObject();
            if (o1 == (o2 = obj2.getDERObject()) || o1.equals(o2)) continue;
            return false;
        }
        return true;
    }

    private DEREncodable getNext(Enumeration e) {
        DEREncodable encObj = (DEREncodable)e.nextElement();
        if (encObj == null) {
            return DERNull.INSTANCE;
        }
        return encObj;
    }

    protected void addObject(DEREncodable obj) {
        this.seq.addElement(obj);
    }

    @Override
    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return this.seq.toString();
    }
}

