/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import repack.org.bouncycastle.asn1.ASN1Boolean;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Enumerated;
import repack.org.bouncycastle.asn1.ASN1Exception;
import repack.org.bouncycastle.asn1.ASN1GeneralizedTime;
import repack.org.bouncycastle.asn1.ASN1Integer;
import repack.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import repack.org.bouncycastle.asn1.ASN1StreamParser;
import repack.org.bouncycastle.asn1.ASN1UTCTime;
import repack.org.bouncycastle.asn1.BERApplicationSpecificParser;
import repack.org.bouncycastle.asn1.BERConstructedOctetString;
import repack.org.bouncycastle.asn1.BEROctetStringParser;
import repack.org.bouncycastle.asn1.BERSequenceParser;
import repack.org.bouncycastle.asn1.BERSetParser;
import repack.org.bouncycastle.asn1.BERTaggedObjectParser;
import repack.org.bouncycastle.asn1.DERApplicationSpecific;
import repack.org.bouncycastle.asn1.DERBMPString;
import repack.org.bouncycastle.asn1.DERBitString;
import repack.org.bouncycastle.asn1.DERExternal;
import repack.org.bouncycastle.asn1.DERExternalParser;
import repack.org.bouncycastle.asn1.DERFactory;
import repack.org.bouncycastle.asn1.DERGeneralString;
import repack.org.bouncycastle.asn1.DERIA5String;
import repack.org.bouncycastle.asn1.DERNull;
import repack.org.bouncycastle.asn1.DERNumericString;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DEROctetString;
import repack.org.bouncycastle.asn1.DERPrintableString;
import repack.org.bouncycastle.asn1.DERT61String;
import repack.org.bouncycastle.asn1.DERTags;
import repack.org.bouncycastle.asn1.DERUTF8String;
import repack.org.bouncycastle.asn1.DERUniversalString;
import repack.org.bouncycastle.asn1.DERUnknownTag;
import repack.org.bouncycastle.asn1.DERVisibleString;
import repack.org.bouncycastle.asn1.DefiniteLengthInputStream;
import repack.org.bouncycastle.asn1.IndefiniteLengthInputStream;
import repack.org.bouncycastle.asn1.LazyDERSequence;
import repack.org.bouncycastle.asn1.LimitedInputStream;
import repack.org.bouncycastle.util.io.Streams;

public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private final int limit;
    private final boolean lazyEvaluate;

    static int findLimit(InputStream in) {
        if (in instanceof LimitedInputStream) {
            return ((LimitedInputStream)in).getRemaining();
        }
        if (in instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)in).available();
        }
        return Integer.MAX_VALUE;
    }

    public ASN1InputStream(InputStream is) {
        this(is, ASN1InputStream.findLimit(is));
    }

    public ASN1InputStream(byte[] input) {
        this(new ByteArrayInputStream(input), input.length);
    }

    public ASN1InputStream(byte[] input, boolean lazyEvaluate) {
        this(new ByteArrayInputStream(input), input.length, lazyEvaluate);
    }

    public ASN1InputStream(InputStream input, int limit) {
        this(input, limit, false);
    }

    public ASN1InputStream(InputStream input, int limit, boolean lazyEvaluate) {
        super(input);
        this.limit = limit;
        this.lazyEvaluate = lazyEvaluate;
    }

    protected int readLength() throws IOException {
        return ASN1InputStream.readLength(this, this.limit);
    }

    protected void readFully(byte[] bytes) throws IOException {
        if (Streams.readFully(this, bytes) != bytes.length) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected DERObject buildObject(int tag, int tagNo, int length) throws IOException {
        boolean isConstructed = (tag & 0x20) != 0;
        DefiniteLengthInputStream defIn = new DefiniteLengthInputStream(this, length);
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(isConstructed, tagNo, defIn.toByteArray());
        }
        if ((tag & 0x80) != 0) {
            return new ASN1StreamParser(defIn).readTaggedObject(isConstructed, tagNo);
        }
        if (isConstructed) {
            switch (tagNo) {
                case 4: {
                    return new BERConstructedOctetString(this.buildDEREncodableVector((DefiniteLengthInputStream)defIn).v);
                }
                case 16: {
                    if (this.lazyEvaluate) {
                        return new LazyDERSequence(defIn.toByteArray());
                    }
                    return DERFactory.createSequence(this.buildDEREncodableVector(defIn));
                }
                case 17: {
                    return DERFactory.createSet(this.buildDEREncodableVector(defIn), false);
                }
                case 8: {
                    return new DERExternal(this.buildDEREncodableVector(defIn));
                }
            }
            return new DERUnknownTag(true, tagNo, defIn.toByteArray());
        }
        return ASN1InputStream.createPrimitiveDERObject(tagNo, defIn.toByteArray());
    }

    ASN1EncodableVector buildEncodableVector() throws IOException {
        DERObject o;
        ASN1EncodableVector v = new ASN1EncodableVector();
        while ((o = this.readObject()) != null) {
            v.add(o);
        }
        return v;
    }

    ASN1EncodableVector buildDEREncodableVector(DefiniteLengthInputStream dIn) throws IOException {
        return new ASN1InputStream(dIn).buildEncodableVector();
    }

    public DERObject readObject() throws IOException {
        int tag = this.read();
        if (tag <= 0) {
            if (tag == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int tagNo = ASN1InputStream.readTagNumber(this, tag);
        boolean isConstructed = (tag & 0x20) != 0;
        int length = this.readLength();
        if (length < 0) {
            if (!isConstructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indIn = new IndefiniteLengthInputStream(this, this.limit);
            ASN1StreamParser sp = new ASN1StreamParser(indIn, this.limit);
            if ((tag & 0x40) != 0) {
                return new BERApplicationSpecificParser(tagNo, sp).getLoadedObject();
            }
            if ((tag & 0x80) != 0) {
                return new BERTaggedObjectParser(true, tagNo, sp).getLoadedObject();
            }
            switch (tagNo) {
                case 4: {
                    return new BEROctetStringParser(sp).getLoadedObject();
                }
                case 16: {
                    return new BERSequenceParser(sp).getLoadedObject();
                }
                case 17: {
                    return new BERSetParser(sp).getLoadedObject();
                }
                case 8: {
                    return new DERExternalParser(sp).getLoadedObject();
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        try {
            return this.buildObject(tag, tagNo, length);
        }
        catch (IllegalArgumentException e) {
            throw new ASN1Exception("corrupted stream detected", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    static int readTagNumber(InputStream s, int tag) throws IOException {
        block2: {
            tagNo = tag & 31;
            if (tagNo != 31) break block2;
            tagNo = 0;
            b = s.read();
            if ((b & 127) != 0) ** GOTO lbl10
            throw new IOException("corrupted stream - invalid high tag number found");
lbl-1000:
            // 1 sources

            {
                tagNo |= b & 127;
                tagNo <<= 7;
                b = s.read();
lbl10:
                // 2 sources

                ** while (b >= 0 && (b & 128) != 0)
            }
lbl11:
            // 1 sources

            if (b < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            tagNo |= b & 127;
        }
        return tagNo;
    }

    static int readLength(InputStream s, int limit) throws IOException {
        int length = s.read();
        if (length < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes: " + size);
            }
            length = 0;
            int i = 0;
            while (i < size) {
                int next = s.read();
                if (next < 0) {
                    throw new EOFException("EOF found reading length");
                }
                length = (length << 8) + next;
                ++i;
            }
            if (length < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (length >= limit) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return length;
    }

    static DERObject createPrimitiveDERObject(int tagNo, byte[] bytes) {
        switch (tagNo) {
            case 3: {
                return DERBitString.fromOctetString(bytes);
            }
            case 30: {
                return new DERBMPString(bytes);
            }
            case 1: {
                return new ASN1Boolean(bytes);
            }
            case 10: {
                return new ASN1Enumerated(bytes);
            }
            case 24: {
                return new ASN1GeneralizedTime(bytes);
            }
            case 27: {
                return new DERGeneralString(bytes);
            }
            case 22: {
                return new DERIA5String(bytes);
            }
            case 2: {
                return new ASN1Integer(bytes);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(bytes);
            }
            case 6: {
                return new ASN1ObjectIdentifier(bytes);
            }
            case 4: {
                return new DEROctetString(bytes);
            }
            case 19: {
                return new DERPrintableString(bytes);
            }
            case 20: {
                return new DERT61String(bytes);
            }
            case 28: {
                return new DERUniversalString(bytes);
            }
            case 23: {
                return new ASN1UTCTime(bytes);
            }
            case 12: {
                return new DERUTF8String(bytes);
            }
            case 26: {
                return new DERVisibleString(bytes);
            }
        }
        return new DERUnknownTag(false, tagNo, bytes);
    }
}

