/*
 * Decompiled with CFR 0.152.
 */
package harmony.java.awt.geom;

import harmony.java.awt.geom.AffineTransform;
import harmony.java.awt.geom.Line2D;
import harmony.java.awt.geom.PathIterator;
import harmony.java.awt.geom.Point2D;
import harmony.java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;
import org.apache.harmony.awt.internal.nls.Messages;
import org.apache.harmony.misc.HashCode;

public abstract class Rectangle2D
extends RectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public abstract int outcode(double var1, double var3);

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public void setRect(Rectangle2D r) {
        this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public void setFrame(double x, double y, double width, double height) {
        this.setRect(x, y, width, height);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.clone();
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        double rx1 = this.getX();
        double ry1 = this.getY();
        double rx2 = rx1 + this.getWidth();
        double ry2 = ry1 + this.getHeight();
        return rx1 <= x1 && x1 <= rx2 && ry1 <= y1 && y1 <= ry2 || rx1 <= x2 && x2 <= rx2 && ry1 <= y2 && y2 <= ry2 || Line2D.linesIntersect(rx1, ry1, rx2, ry2, x1, y1, x2, y2) || Line2D.linesIntersect(rx2, ry1, rx1, ry2, x1, y1, x2, y2);
    }

    public boolean intersectsLine(Line2D l) {
        return this.intersectsLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public int outcode(Point2D p) {
        return this.outcode(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.isEmpty()) {
            return false;
        }
        double x1 = this.getX();
        double y1 = this.getY();
        double x2 = x1 + this.getWidth();
        double y2 = y1 + this.getHeight();
        return x1 <= x && x < x2 && y1 <= y && y < y2;
    }

    @Override
    public boolean intersects(double x, double y, double width, double height) {
        if (this.isEmpty() || width <= 0.0 || height <= 0.0) {
            return false;
        }
        double x1 = this.getX();
        double y1 = this.getY();
        double x2 = x1 + this.getWidth();
        double y2 = y1 + this.getHeight();
        return x + width > x1 && x < x2 && y + height > y1 && y < y2;
    }

    @Override
    public boolean contains(double x, double y, double width, double height) {
        if (this.isEmpty() || width <= 0.0 || height <= 0.0) {
            return false;
        }
        double x1 = this.getX();
        double y1 = this.getY();
        double x2 = x1 + this.getWidth();
        double y2 = y1 + this.getHeight();
        return x1 <= x && x + width <= x2 && y1 <= y && y + height <= y2;
    }

    public static void intersect(Rectangle2D src1, Rectangle2D src2, Rectangle2D dst) {
        double x1 = Math.max(src1.getMinX(), src2.getMinX());
        double y1 = Math.max(src1.getMinY(), src2.getMinY());
        double x2 = Math.min(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.min(src1.getMaxY(), src2.getMaxY());
        dst.setFrame(x1, y1, x2 - x1, y2 - y1);
    }

    public static void union(Rectangle2D src1, Rectangle2D src2, Rectangle2D dst) {
        double x1 = Math.min(src1.getMinX(), src2.getMinX());
        double y1 = Math.min(src1.getMinY(), src2.getMinY());
        double x2 = Math.max(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.max(src1.getMaxY(), src2.getMaxY());
        dst.setFrame(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(double x, double y) {
        double x1 = Math.min(this.getMinX(), x);
        double y1 = Math.min(this.getMinY(), y);
        double x2 = Math.max(this.getMaxX(), x);
        double y2 = Math.max(this.getMaxY(), y);
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(Point2D p) {
        this.add(p.getX(), p.getY());
    }

    public void add(Rectangle2D r) {
        Rectangle2D.union(this, r, this);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform t) {
        return new Iterator(this, t);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform t, double flatness) {
        return new Iterator(this, t);
    }

    public int hashCode() {
        HashCode hash = new HashCode();
        hash.append(this.getX());
        hash.append(this.getY());
        hash.append(this.getWidth());
        hash.append(this.getHeight());
        return hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)obj;
            return this.getX() == r.getX() && this.getY() == r.getY() && this.getWidth() == r.getWidth() && this.getHeight() == r.getHeight();
        }
        return false;
    }

    public static class Double
    extends Rectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double x, double y, double width, double height) {
            this.setRect(x, y, width, height);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        @Override
        public void setRect(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public void setRect(Rectangle2D r) {
            this.x = r.getX();
            this.y = r.getY();
            this.width = r.getWidth();
            this.height = r.getHeight();
        }

        @Override
        public int outcode(double px, double py) {
            int code = 0;
            if (this.width <= 0.0) {
                code |= 5;
            } else if (px < this.x) {
                code |= 1;
            } else if (px > this.x + this.width) {
                code |= 4;
            }
            if (this.height <= 0.0) {
                code |= 0xA;
            } else if (py < this.y) {
                code |= 2;
            } else if (py > this.y + this.height) {
                code |= 8;
            }
            return code;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        @Override
        public Rectangle2D createIntersection(Rectangle2D r) {
            Double dst = new Double();
            Rectangle2D.intersect(this, r, dst);
            return dst;
        }

        @Override
        public Rectangle2D createUnion(Rectangle2D r) {
            Double dest = new Double();
            Rectangle2D.union(this, r, dest);
            return dest;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
        }
    }

    public static class Float
    extends Rectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float x, float y, float width, float height) {
            this.setRect(x, y, width, height);
        }

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        @Override
        public void setRect(double x, double y, double width, double height) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)width;
            this.height = (float)height;
        }

        @Override
        public void setRect(Rectangle2D r) {
            this.x = (float)r.getX();
            this.y = (float)r.getY();
            this.width = (float)r.getWidth();
            this.height = (float)r.getHeight();
        }

        @Override
        public int outcode(double px, double py) {
            int code = 0;
            if (this.width <= 0.0f) {
                code |= 5;
            } else if (px < (double)this.x) {
                code |= 1;
            } else if (px > (double)(this.x + this.width)) {
                code |= 4;
            }
            if (this.height <= 0.0f) {
                code |= 0xA;
            } else if (py < (double)this.y) {
                code |= 2;
            } else if (py > (double)(this.y + this.height)) {
                code |= 8;
            }
            return code;
        }

        @Override
        public Rectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        @Override
        public Rectangle2D createIntersection(Rectangle2D r) {
            Rectangle2D dst = r instanceof Double ? new Double() : new Float();
            Rectangle2D.intersect(this, r, dst);
            return dst;
        }

        @Override
        public Rectangle2D createUnion(Rectangle2D r) {
            Rectangle2D dst = r instanceof Double ? new Double() : new Float();
            Rectangle2D.union(this, r, dst);
            return dst;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
        }
    }

    class Iterator
    implements PathIterator {
        double x;
        double y;
        double width;
        double height;
        AffineTransform t;
        int index;

        Iterator(Rectangle2D r, AffineTransform at) {
            this.x = r.getX();
            this.y = r.getY();
            this.width = r.getWidth();
            this.height = r.getHeight();
            this.t = at;
            if (this.width < 0.0 || this.height < 0.0) {
                this.index = 6;
            }
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.index > 5;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(double[] coords) {
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 5) {
                return 4;
            }
            if (this.index == 0) {
                type = 0;
                coords[0] = this.x;
                coords[1] = this.y;
            } else {
                type = 1;
                switch (this.index) {
                    case 1: {
                        coords[0] = this.x + this.width;
                        coords[1] = this.y;
                        break;
                    }
                    case 2: {
                        coords[0] = this.x + this.width;
                        coords[1] = this.y + this.height;
                        break;
                    }
                    case 3: {
                        coords[0] = this.x;
                        coords[1] = this.y + this.height;
                        break;
                    }
                    case 4: {
                        coords[0] = this.x;
                        coords[1] = this.y;
                    }
                }
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return type;
        }

        @Override
        public int currentSegment(float[] coords) {
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 5) {
                return 4;
            }
            if (this.index == 0) {
                coords[0] = (float)this.x;
                coords[1] = (float)this.y;
                type = 0;
            } else {
                type = 1;
                switch (this.index) {
                    case 1: {
                        coords[0] = (float)(this.x + this.width);
                        coords[1] = (float)this.y;
                        break;
                    }
                    case 2: {
                        coords[0] = (float)(this.x + this.width);
                        coords[1] = (float)(this.y + this.height);
                        break;
                    }
                    case 3: {
                        coords[0] = (float)this.x;
                        coords[1] = (float)(this.y + this.height);
                        break;
                    }
                    case 4: {
                        coords[0] = (float)this.x;
                        coords[1] = (float)this.y;
                    }
                }
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return type;
        }
    }
}

