/*
 * Decompiled with CFR 0.152.
 */
package harmony.java.awt.geom;

import harmony.java.awt.Rectangle;
import harmony.java.awt.Shape;
import harmony.java.awt.geom.AffineTransform;
import harmony.java.awt.geom.PathIterator;
import harmony.java.awt.geom.Point2D;
import harmony.java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class Line2D
implements Shape,
Cloneable {
    protected Line2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP1();

    public abstract Point2D getP2();

    public abstract void setLine(double var1, double var3, double var5, double var7);

    public void setLine(Point2D p1, Point2D p2) {
        this.setLine(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setLine(Line2D line) {
        this.setLine(line.getX1(), line.getY1(), line.getX2(), line.getY2());
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public static int relativeCCW(double x1, double y1, double x2, double y2, double px, double py) {
        double t = (px -= x1) * (y2 -= y1) - (py -= y1) * (x2 -= x1);
        if (t == 0.0 && (t = px * x2 + py * y2) > 0.0 && (t = (px -= x2) * x2 + (py -= y2) * y2) < 0.0) {
            t = 0.0;
        }
        return t < 0.0 ? -1 : (t > 0.0 ? 1 : 0);
    }

    public int relativeCCW(double px, double py) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public int relativeCCW(Point2D p) {
        return Line2D.relativeCCW(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double AvB = (x2 -= x1) * (y3 -= y1) - (x3 -= x1) * (y2 -= y1);
        double AvC = x2 * (y4 -= y1) - (x4 -= x1) * y2;
        if (AvB == 0.0 && AvC == 0.0) {
            if (x2 != 0.0) {
                return x4 * x3 <= 0.0 || x3 * x2 >= 0.0 && !(x2 > 0.0 ? !(x3 <= x2) && !(x4 <= x2) : !(x3 >= x2) && !(x4 >= x2));
            }
            if (y2 != 0.0) {
                return y4 * y3 <= 0.0 || y3 * y2 >= 0.0 && !(y2 > 0.0 ? !(y3 <= y2) && !(y4 <= y2) : !(y3 >= y2) && !(y4 >= y2));
            }
            return false;
        }
        double BvC = x3 * y4 - x4 * y3;
        return AvB * AvC <= 0.0 && BvC * (AvB + BvC - AvC) <= 0.0;
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        return Line2D.linesIntersect(x1, y1, x2, y2, this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public boolean intersectsLine(Line2D l) {
        return Line2D.linesIntersect(l.getX1(), l.getY1(), l.getX2(), l.getY2(), this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public static double ptSegDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double dist;
        if ((px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1) <= 0.0) {
            dist = px * px + py * py;
        } else if ((px = x2 - px) * x2 + (py = y2 - py) * y2 <= 0.0) {
            dist = px * px + py * py;
        } else {
            dist = px * y2 - py * x2;
            dist = dist * dist / (x2 * x2 + y2 * y2);
        }
        if (dist < 0.0) {
            dist = 0.0;
        }
        return dist;
    }

    public static double ptSegDist(double x1, double y1, double x2, double y2, double px, double py) {
        return Math.sqrt(Line2D.ptSegDistSq(x1, y1, x2, y2, px, py));
    }

    public double ptSegDistSq(double px, double py) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptSegDistSq(Point2D p) {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public double ptSegDist(double px, double py) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptSegDist(Point2D p) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public static double ptLineDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double s = (px -= x1) * (y2 -= y1) - (py -= y1) * (x2 -= x1);
        return s * s / (x2 * x2 + y2 * y2);
    }

    public static double ptLineDist(double x1, double y1, double x2, double y2, double px, double py) {
        return Math.sqrt(Line2D.ptLineDistSq(x1, y1, x2, y2, px, py));
    }

    public double ptLineDistSq(double px, double py) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptLineDistSq(Point2D p) {
        return Line2D.ptLineDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    public double ptLineDist(double px, double py) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public double ptLineDist(Point2D p) {
        return Line2D.ptLineDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), p.getX(), p.getY());
    }

    @Override
    public boolean contains(double px, double py) {
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    @Override
    public boolean contains(double rx, double ry, double rw, double rh) {
        return false;
    }

    @Override
    public boolean intersects(double rx, double ry, double rw, double rh) {
        return this.intersects(new Rectangle2D.Double(rx, ry, rw, rh));
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return r.intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(this, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new Iterator(this, at);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class Double
    extends Line2D {
        public double x1;
        public double y1;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double x1, double y1, double x2, double y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Double(Point2D p1, Point2D p2) {
            this.setLine(p1, p2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        @Override
        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public Rectangle2D getBounds2D() {
            double rh;
            double ry;
            double rw;
            double rx;
            if (this.x1 < this.x2) {
                rx = this.x1;
                rw = this.x2 - this.x1;
            } else {
                rx = this.x2;
                rw = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                ry = this.y1;
                rh = this.y2 - this.y1;
            } else {
                ry = this.y2;
                rh = this.y1 - this.y2;
            }
            return new Rectangle2D.Double(rx, ry, rw, rh);
        }
    }

    public static class Float
    extends Line2D {
        public float x1;
        public float y1;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float x1, float y1, float x2, float y2) {
            this.setLine(x1, y1, x2, y2);
        }

        public Float(Point2D p1, Point2D p2) {
            this.setLine(p1, p2);
        }

        @Override
        public double getX1() {
            return this.x1;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        @Override
        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        @Override
        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        @Override
        public void setLine(double x1, double y1, double x2, double y2) {
            this.x1 = (float)x1;
            this.y1 = (float)y1;
            this.x2 = (float)x2;
            this.y2 = (float)y2;
        }

        public void setLine(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        @Override
        public Rectangle2D getBounds2D() {
            float rh;
            float ry;
            float rw;
            float rx;
            if (this.x1 < this.x2) {
                rx = this.x1;
                rw = this.x2 - this.x1;
            } else {
                rx = this.x2;
                rw = this.x1 - this.x2;
            }
            if (this.y1 < this.y2) {
                ry = this.y1;
                rh = this.y2 - this.y1;
            } else {
                ry = this.y2;
                rh = this.y1 - this.y2;
            }
            return new Rectangle2D.Float(rx, ry, rw, rh);
        }
    }

    class Iterator
    implements PathIterator {
        double x1;
        double y1;
        double x2;
        double y2;
        AffineTransform t;
        int index;

        Iterator(Line2D l, AffineTransform at) {
            this.x1 = l.getX1();
            this.y1 = l.getY1();
            this.x2 = l.getX2();
            this.y2 = l.getY2();
            this.t = at;
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.index > 1;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(double[] coords) {
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 0) {
                type = 0;
                coords[0] = this.x1;
                coords[1] = this.y1;
            } else {
                type = 1;
                coords[0] = this.x2;
                coords[1] = this.y2;
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return type;
        }

        @Override
        public int currentSegment(float[] coords) {
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 0) {
                type = 0;
                coords[0] = (float)this.x1;
                coords[1] = (float)this.y1;
            } else {
                type = 1;
                coords[0] = (float)this.x2;
                coords[1] = (float)this.y2;
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return type;
        }
    }
}

