/*
 * Decompiled with CFR 0.152.
 */
package harmony.java.awt;

import java.io.Serializable;
import org.apache.harmony.awt.internal.nls.Messages;

public class Color
implements Serializable {
    private static final long serialVersionUID = 118526816881161077L;
    public static final Color white;
    public static final Color WHITE;
    public static final Color lightGray;
    public static final Color LIGHT_GRAY;
    public static final Color gray;
    public static final Color GRAY;
    public static final Color darkGray;
    public static final Color DARK_GRAY;
    public static final Color black;
    public static final Color BLACK;
    public static final Color red;
    public static final Color RED;
    public static final Color pink;
    public static final Color PINK;
    public static final Color orange;
    public static final Color ORANGE;
    public static final Color yellow;
    public static final Color YELLOW;
    public static final Color green;
    public static final Color GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    public static final Color blue;
    public static final Color BLUE;
    int value;
    private float[] frgbvalue;
    private float[] fvalue;
    private float falpha;
    private static final double SCALE_FACTOR = 0.7;
    private static final int MIN_SCALABLE = 3;

    static {
        WHITE = white = new Color(255, 255, 255);
        LIGHT_GRAY = lightGray = new Color(192, 192, 192);
        GRAY = gray = new Color(128, 128, 128);
        DARK_GRAY = darkGray = new Color(64, 64, 64);
        BLACK = black = new Color(0, 0, 0);
        RED = red = new Color(255, 0, 0);
        PINK = pink = new Color(255, 175, 175);
        ORANGE = orange = new Color(255, 200, 0);
        YELLOW = yellow = new Color(255, 255, 0);
        GREEN = green = new Color(0, 255, 0);
        MAGENTA = magenta = new Color(255, 0, 255);
        CYAN = cyan = new Color(0, 255, 255);
        BLUE = blue = new Color(0, 0, 255);
    }

    public Color(int rgba, boolean hasAlpha) {
        this.value = !hasAlpha ? rgba | 0xFF000000 : rgba;
    }

    public Color(int r, int g, int b, int a) {
        if ((r & 0xFF) != r || (g & 0xFF) != g || (b & 0xFF) != b || (a & 0xFF) != a) {
            throw new IllegalArgumentException(Messages.getString("awt.109"));
        }
        this.value = b | g << 8 | r << 16 | a << 24;
    }

    public Color(int r, int g, int b) {
        if ((r & 0xFF) != r || (g & 0xFF) != g || (b & 0xFF) != b) {
            throw new IllegalArgumentException(Messages.getString("awt.109"));
        }
        this.value = b | g << 8 | r << 16 | 0xFF000000;
    }

    public Color(int rgb) {
        this.value = rgb | 0xFF000000;
    }

    public Color(float r, float g, float b, float a) {
        this((int)((double)(r * 255.0f) + 0.5), (int)((double)(g * 255.0f) + 0.5), (int)((double)(b * 255.0f) + 0.5), (int)((double)(a * 255.0f) + 0.5));
        this.falpha = a;
        this.fvalue = new float[3];
        this.fvalue[0] = r;
        this.fvalue[1] = g;
        this.fvalue[2] = b;
        this.frgbvalue = this.fvalue;
    }

    public Color(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Color) {
            return ((Color)obj).value == this.value;
        }
        return false;
    }

    public Color darker() {
        return new Color((int)((double)this.getRed() * 0.7), (int)((double)this.getGreen() * 0.7), (int)((double)this.getBlue() * 0.7));
    }

    public Color brighter() {
        int r = this.getRed();
        int b = this.getBlue();
        int g = this.getGreen();
        if (r == 0 && b == 0 && g == 0) {
            return new Color(3, 3, 3);
        }
        if (r < 3 && r != 0) {
            r = 3;
        } else {
            int n = r = (r = (int)((double)r / 0.7)) > 255 ? 255 : r;
        }
        if (b < 3 && b != 0) {
            b = 3;
        } else {
            int n = b = (b = (int)((double)b / 0.7)) > 255 ? 255 : b;
        }
        g = g < 3 && g != 0 ? 3 : ((g = (int)((double)g / 0.7)) > 255 ? 255 : g);
        return new Color(r, g, b);
    }

    public float[] getRGBComponents(float[] components) {
        if (components == null) {
            components = new float[4];
        }
        components[3] = this.frgbvalue != null ? this.falpha : (float)this.getAlpha() / 255.0f;
        this.getRGBColorComponents(components);
        return components;
    }

    public float[] getRGBColorComponents(float[] components) {
        if (components == null) {
            components = new float[3];
        }
        if (this.frgbvalue != null) {
            components[2] = this.frgbvalue[2];
            components[1] = this.frgbvalue[1];
            components[0] = this.frgbvalue[0];
        } else {
            components[2] = (float)this.getBlue() / 255.0f;
            components[1] = (float)this.getGreen() / 255.0f;
            components[0] = (float)this.getRed() / 255.0f;
        }
        return components;
    }

    public float[] getComponents(float[] components) {
        if (this.fvalue == null) {
            return this.getRGBComponents(components);
        }
        int nColorComps = this.fvalue.length;
        if (components == null) {
            components = new float[nColorComps + 1];
        }
        this.getColorComponents(components);
        components[nColorComps] = this.falpha;
        return components;
    }

    public float[] getColorComponents(float[] components) {
        if (this.fvalue == null) {
            return this.getRGBColorComponents(components);
        }
        if (components == null) {
            components = new float[this.fvalue.length];
        }
        int i = 0;
        while (i < this.fvalue.length) {
            components[i] = this.fvalue[i];
            ++i;
        }
        return components;
    }

    public int hashCode() {
        return this.value;
    }

    public int getTransparency() {
        switch (this.getAlpha()) {
            case 255: {
                return 1;
            }
            case 0: {
                return 2;
            }
        }
        return 3;
    }

    public int getRed() {
        return this.value >> 16 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public int getGreen() {
        return this.value >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.value & 0xFF;
    }

    public int getAlpha() {
        return this.value >> 24 & 0xFF;
    }

    public static Color getColor(String nm, Color def) {
        Integer integer = Integer.getInteger(nm);
        if (integer == null) {
            return def;
        }
        return new Color(integer);
    }

    public static Color getColor(String nm, int def) {
        Integer integer = Integer.getInteger(nm);
        if (integer == null) {
            return new Color(def);
        }
        return new Color(integer);
    }

    public static Color getColor(String nm) {
        Integer integer = Integer.getInteger(nm);
        if (integer == null) {
            return null;
        }
        return new Color(integer);
    }

    public static Color decode(String nm) throws NumberFormatException {
        Integer integer = Integer.decode(nm);
        return new Color(integer);
    }

    public static Color getHSBColor(float h, float s, float b) {
        return new Color(Color.HSBtoRGB(h, s, b));
    }

    public static float[] RGBtoHSB(int r, int g, int b, float[] hsbvals) {
        float H;
        float S;
        if (hsbvals == null) {
            hsbvals = new float[3];
        }
        int V = Math.max(b, Math.max(r, g));
        int temp = Math.min(b, Math.min(r, g));
        float B = (float)V / 255.0f;
        if (V == temp) {
            S = 0.0f;
            H = 0.0f;
        } else {
            S = (float)(V - temp) / (float)V;
            float Cr = (float)(V - r) / (float)(V - temp);
            float Cg = (float)(V - g) / (float)(V - temp);
            float Cb = (float)(V - b) / (float)(V - temp);
            H = r == V ? Cb - Cg : (g == V ? 2.0f + Cr - Cb : 4.0f + Cg - Cr);
            if ((H /= 6.0f) < 0.0f) {
                H += 1.0f;
            }
        }
        hsbvals[0] = H;
        hsbvals[1] = S;
        hsbvals[2] = B;
        return hsbvals;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        float fr;
        float fg;
        float fb;
        if (saturation == 0.0f) {
            fg = fb = brightness;
            fr = fb;
        } else {
            float H = (hue - (float)Math.floor(hue)) * 6.0f;
            int I = (int)Math.floor(H);
            float F = H - (float)I;
            float M = brightness * (1.0f - saturation);
            float N = brightness * (1.0f - saturation * F);
            float K = brightness * (1.0f - saturation * (1.0f - F));
            switch (I) {
                case 0: {
                    fr = brightness;
                    fg = K;
                    fb = M;
                    break;
                }
                case 1: {
                    fr = N;
                    fg = brightness;
                    fb = M;
                    break;
                }
                case 2: {
                    fr = M;
                    fg = brightness;
                    fb = K;
                    break;
                }
                case 3: {
                    fr = M;
                    fg = N;
                    fb = brightness;
                    break;
                }
                case 4: {
                    fr = K;
                    fg = M;
                    fb = brightness;
                    break;
                }
                case 5: {
                    fr = brightness;
                    fg = M;
                    fb = N;
                    break;
                }
                default: {
                    fg = 0.0f;
                    fb = 0.0f;
                    fr = 0.0f;
                }
            }
        }
        int r = (int)((double)fr * 255.0 + 0.5);
        int g = (int)((double)fg * 255.0 + 0.5);
        int b = (int)((double)fb * 255.0 + 0.5);
        return r << 16 | g << 8 | b | 0xFF000000;
    }
}

