/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;

public class HandoutPdf {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("arguments: srcfile destfile pages");
        } else {
            try {
                int pages = Integer.parseInt(args[2]);
                if (pages < 2 || pages > 8) {
                    throw new DocumentException("You can't have " + pages + " pages on one page (minimum 2; maximum 8).");
                }
                float x1 = 30.0f;
                float x2 = 280.0f;
                float x3 = 320.0f;
                float x4 = 565.0f;
                float[] y1 = new float[pages];
                float[] y2 = new float[pages];
                float height = (778.0f - 20.0f * (float)(pages - 1)) / (float)pages;
                y1[0] = 812.0f;
                y2[0] = 812.0f - height;
                int i = 1;
                while (i < pages) {
                    y1[i] = y2[i - 1] - 20.0f;
                    y2[i] = y1[i] - height;
                    ++i;
                }
                PdfReader reader = new PdfReader(args[0]);
                int n = reader.getNumberOfPages();
                System.out.println("There are " + n + " pages in the original file.");
                Document document = new Document(PageSize.A4);
                PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(args[1]));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                int i2 = 0;
                int p = 0;
                while (i2 < n) {
                    float factory;
                    Rectangle rect;
                    float factorx;
                    float factor = (factorx = (x2 - x1) / (rect = reader.getPageSizeWithRotation(++i2)).getWidth()) < (factory = (y1[p] - y2[p]) / rect.getHeight()) ? factorx : factory;
                    float dx = factorx == factor ? 0.0f : (x2 - x1 - rect.getWidth() * factor) / 2.0f;
                    float dy = factory == factor ? 0.0f : (y1[p] - y2[p] - rect.getHeight() * factor) / 2.0f;
                    PdfImportedPage page = writer.getImportedPage(reader, i2);
                    int rotation = reader.getPageRotation(i2);
                    if (rotation == 90 || rotation == 270) {
                        cb.addTemplate(page, 0.0f, -factor, factor, 0.0f, x1 + dx, y2[p] + dy + rect.getHeight() * factor);
                    } else {
                        cb.addTemplate(page, factor, 0.0f, 0.0f, factor, x1 + dx, y2[p] + dy);
                    }
                    cb.setRGBColorStroke(192, 192, 192);
                    cb.rectangle(x3 - 5.0f, y2[p] - 5.0f, x4 - x3 + 10.0f, y1[p] - y2[p] + 10.0f);
                    float l = y1[p] - 19.0f;
                    while (l > y2[p]) {
                        cb.moveTo(x3, l);
                        cb.lineTo(x4, l);
                        l -= 16.0f;
                    }
                    cb.rectangle(x1 + dx, y2[p] + dy, rect.getWidth() * factor, rect.getHeight() * factor);
                    cb.stroke();
                    System.out.println("Processed page " + i2);
                    if (++p != pages) continue;
                    p = 0;
                    document.newPage();
                }
                document.close();
            }
            catch (Exception e) {
                System.err.println(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            }
        }
    }
}

