/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import harmony.java.awt.Color;
import java.util.Arrays;

public class BarcodeEAN
extends Barcode {
    private static final int[] GUARD_EMPTY = new int[0];
    private static final int[] GUARD_UPCA;
    private static final int[] GUARD_EAN13;
    private static final int[] GUARD_EAN8;
    private static final int[] GUARD_UPCE;
    private static final float[] TEXTPOS_EAN13;
    private static final float[] TEXTPOS_EAN8;
    private static final byte[][] BARS;
    private static final int TOTALBARS_EAN13 = 59;
    private static final int TOTALBARS_EAN8 = 43;
    private static final int TOTALBARS_UPCE = 33;
    private static final int TOTALBARS_SUPP2 = 13;
    private static final int TOTALBARS_SUPP5 = 31;
    private static final int ODD = 0;
    private static final int EVEN = 1;
    private static final byte[][] PARITY13;
    private static final byte[][] PARITY2;
    private static final byte[][] PARITY5;
    private static final byte[][] PARITYE;

    static {
        int[] nArray = new int[10];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 6;
        nArray[4] = 28;
        nArray[5] = 30;
        nArray[6] = 52;
        nArray[7] = 54;
        nArray[8] = 56;
        nArray[9] = 58;
        GUARD_UPCA = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = 2;
        nArray2[2] = 28;
        nArray2[3] = 30;
        nArray2[4] = 56;
        nArray2[5] = 58;
        GUARD_EAN13 = nArray2;
        int[] nArray3 = new int[6];
        nArray3[1] = 2;
        nArray3[2] = 20;
        nArray3[3] = 22;
        nArray3[4] = 40;
        nArray3[5] = 42;
        GUARD_EAN8 = nArray3;
        int[] nArray4 = new int[5];
        nArray4[1] = 2;
        nArray4[2] = 28;
        nArray4[3] = 30;
        nArray4[4] = 32;
        GUARD_UPCE = nArray4;
        TEXTPOS_EAN13 = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 34.5f, 41.5f, 53.5f, 60.5f, 67.5f, 74.5f, 81.5f, 88.5f};
        TEXTPOS_EAN8 = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 39.5f, 46.5f, 53.5f, 60.5f};
        BARS = new byte[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
        byte[][] byArrayArray = new byte[10][];
        byArrayArray[0] = new byte[6];
        byte[] byArray = new byte[6];
        byArray[2] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArrayArray[1] = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[5] = 1;
        byArrayArray[2] = byArray2;
        byte[] byArray3 = new byte[6];
        byArray3[2] = 1;
        byArray3[3] = 1;
        byArray3[4] = 1;
        byArrayArray[3] = byArray3;
        byte[] byArray4 = new byte[6];
        byArray4[1] = 1;
        byArray4[4] = 1;
        byArray4[5] = 1;
        byArrayArray[4] = byArray4;
        byte[] byArray5 = new byte[6];
        byArray5[1] = 1;
        byArray5[2] = 1;
        byArray5[5] = 1;
        byArrayArray[5] = byArray5;
        byte[] byArray6 = new byte[6];
        byArray6[1] = 1;
        byArray6[2] = 1;
        byArray6[3] = 1;
        byArrayArray[6] = byArray6;
        byte[] byArray7 = new byte[6];
        byArray7[1] = 1;
        byArray7[3] = 1;
        byArray7[5] = 1;
        byArrayArray[7] = byArray7;
        byte[] byArray8 = new byte[6];
        byArray8[1] = 1;
        byArray8[3] = 1;
        byArray8[4] = 1;
        byArrayArray[8] = byArray8;
        byte[] byArray9 = new byte[6];
        byArray9[1] = 1;
        byArray9[2] = 1;
        byArray9[4] = 1;
        byArrayArray[9] = byArray9;
        PARITY13 = byArrayArray;
        byte[][] byArrayArray2 = new byte[4][];
        byArrayArray2[0] = new byte[2];
        byte[] byArray10 = new byte[2];
        byArray10[1] = 1;
        byArrayArray2[1] = byArray10;
        byte[] byArray11 = new byte[2];
        byArray11[0] = 1;
        byArrayArray2[2] = byArray11;
        byArrayArray2[3] = new byte[]{1, 1};
        PARITY2 = byArrayArray2;
        byte[][] byArrayArray3 = new byte[10][];
        byte[] byArray12 = new byte[5];
        byArray12[0] = 1;
        byArray12[1] = 1;
        byArrayArray3[0] = byArray12;
        byte[] byArray13 = new byte[5];
        byArray13[0] = 1;
        byArray13[2] = 1;
        byArrayArray3[1] = byArray13;
        byte[] byArray14 = new byte[5];
        byArray14[0] = 1;
        byArray14[3] = 1;
        byArrayArray3[2] = byArray14;
        byte[] byArray15 = new byte[5];
        byArray15[0] = 1;
        byArray15[4] = 1;
        byArrayArray3[3] = byArray15;
        byte[] byArray16 = new byte[5];
        byArray16[1] = 1;
        byArray16[2] = 1;
        byArrayArray3[4] = byArray16;
        byte[] byArray17 = new byte[5];
        byArray17[2] = 1;
        byArray17[3] = 1;
        byArrayArray3[5] = byArray17;
        byte[] byArray18 = new byte[5];
        byArray18[3] = 1;
        byArray18[4] = 1;
        byArrayArray3[6] = byArray18;
        byte[] byArray19 = new byte[5];
        byArray19[1] = 1;
        byArray19[3] = 1;
        byArrayArray3[7] = byArray19;
        byte[] byArray20 = new byte[5];
        byArray20[1] = 1;
        byArray20[4] = 1;
        byArrayArray3[8] = byArray20;
        byte[] byArray21 = new byte[5];
        byArray21[2] = 1;
        byArray21[4] = 1;
        byArrayArray3[9] = byArray21;
        PARITY5 = byArrayArray3;
        byte[][] byArrayArray4 = new byte[10][];
        byte[] byArray22 = new byte[6];
        byArray22[0] = 1;
        byArray22[1] = 1;
        byArray22[2] = 1;
        byArrayArray4[0] = byArray22;
        byte[] byArray23 = new byte[6];
        byArray23[0] = 1;
        byArray23[1] = 1;
        byArray23[3] = 1;
        byArrayArray4[1] = byArray23;
        byte[] byArray24 = new byte[6];
        byArray24[0] = 1;
        byArray24[1] = 1;
        byArray24[4] = 1;
        byArrayArray4[2] = byArray24;
        byte[] byArray25 = new byte[6];
        byArray25[0] = 1;
        byArray25[1] = 1;
        byArray25[5] = 1;
        byArrayArray4[3] = byArray25;
        byte[] byArray26 = new byte[6];
        byArray26[0] = 1;
        byArray26[2] = 1;
        byArray26[3] = 1;
        byArrayArray4[4] = byArray26;
        byte[] byArray27 = new byte[6];
        byArray27[0] = 1;
        byArray27[3] = 1;
        byArray27[4] = 1;
        byArrayArray4[5] = byArray27;
        byte[] byArray28 = new byte[6];
        byArray28[0] = 1;
        byArray28[4] = 1;
        byArray28[5] = 1;
        byArrayArray4[6] = byArray28;
        byte[] byArray29 = new byte[6];
        byArray29[0] = 1;
        byArray29[2] = 1;
        byArray29[4] = 1;
        byArrayArray4[7] = byArray29;
        byte[] byArray30 = new byte[6];
        byArray30[0] = 1;
        byArray30[2] = 1;
        byArray30[5] = 1;
        byArrayArray4[8] = byArray30;
        byte[] byArray31 = new byte[6];
        byArray31[0] = 1;
        byArray31[3] = 1;
        byArray31[5] = 1;
        byArrayArray4[9] = byArray31;
        PARITYE = byArrayArray4;
    }

    public BarcodeEAN() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.guardBars = true;
            this.codeType = 1;
            this.code = "";
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static int calculateEANParity(String code) {
        int mul = 3;
        int total = 0;
        int k = code.length() - 1;
        while (k >= 0) {
            int n = code.charAt(k) - 48;
            total += mul * n;
            mul ^= 2;
            --k;
        }
        return (10 - total % 10) % 10;
    }

    public static String convertUPCAtoUPCE(String text) {
        if (text.length() != 12 || !text.startsWith("0") && !text.startsWith("1")) {
            return null;
        }
        if (text.substring(3, 6).equals("000") || text.substring(3, 6).equals("100") || text.substring(3, 6).equals("200")) {
            if (text.substring(6, 8).equals("00")) {
                return String.valueOf(text.substring(0, 1)) + text.substring(1, 3) + text.substring(8, 11) + text.substring(3, 4) + text.substring(11);
            }
        } else if (text.substring(4, 6).equals("00")) {
            if (text.substring(6, 9).equals("000")) {
                return String.valueOf(text.substring(0, 1)) + text.substring(1, 4) + text.substring(9, 11) + "3" + text.substring(11);
            }
        } else if (text.substring(5, 6).equals("0")) {
            if (text.substring(6, 10).equals("0000")) {
                return String.valueOf(text.substring(0, 1)) + text.substring(1, 5) + text.substring(10, 11) + "4" + text.substring(11);
            }
        } else if (text.charAt(10) >= '5' && text.substring(6, 10).equals("0000")) {
            return String.valueOf(text.substring(0, 1)) + text.substring(1, 6) + text.substring(10, 11) + text.substring(11);
        }
        return null;
    }

    public static byte[] getBarsEAN13(String _code) {
        byte[] stripes;
        int c;
        int[] code = new int[_code.length()];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[59];
        int pb = 0;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        byte[] sequence = PARITY13[code[0]];
        int k2 = 0;
        while (k2 < sequence.length) {
            c = code[k2 + 1];
            stripes = BARS[c];
            if (sequence[k2] == 0) {
                bars[pb++] = stripes[0];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[3];
            } else {
                bars[pb++] = stripes[3];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[0];
            }
            ++k2;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        k2 = 7;
        while (k2 < 13) {
            c = code[k2];
            stripes = BARS[c];
            bars[pb++] = stripes[0];
            bars[pb++] = stripes[1];
            bars[pb++] = stripes[2];
            bars[pb++] = stripes[3];
            ++k2;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        return bars;
    }

    public static byte[] getBarsEAN8(String _code) {
        byte[] stripes;
        int c;
        int[] code = new int[_code.length()];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[43];
        int pb = 0;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        int k2 = 0;
        while (k2 < 4) {
            c = code[k2];
            stripes = BARS[c];
            bars[pb++] = stripes[0];
            bars[pb++] = stripes[1];
            bars[pb++] = stripes[2];
            bars[pb++] = stripes[3];
            ++k2;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        k2 = 4;
        while (k2 < 8) {
            c = code[k2];
            stripes = BARS[c];
            bars[pb++] = stripes[0];
            bars[pb++] = stripes[1];
            bars[pb++] = stripes[2];
            bars[pb++] = stripes[3];
            ++k2;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        return bars;
    }

    public static byte[] getBarsUPCE(String _code) {
        int[] code = new int[_code.length()];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[33];
        boolean flip = code[0] != 0;
        int pb = 0;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        byte[] sequence = PARITYE[code[code.length - 1]];
        int k2 = 1;
        while (k2 < code.length - 1) {
            int c = code[k2];
            byte[] stripes = BARS[c];
            if (sequence[k2 - 1] == (flip ? (byte)1 : 0)) {
                bars[pb++] = stripes[0];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[3];
            } else {
                bars[pb++] = stripes[3];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[0];
            }
            ++k2;
        }
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 1;
        return bars;
    }

    public static byte[] getBarsSupplemental2(String _code) {
        int[] code = new int[2];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[13];
        int pb = 0;
        int parity = (code[0] * 10 + code[1]) % 4;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 2;
        byte[] sequence = PARITY2[parity];
        int k2 = 0;
        while (k2 < sequence.length) {
            if (k2 == 1) {
                bars[pb++] = 1;
                bars[pb++] = 1;
            }
            int c = code[k2];
            byte[] stripes = BARS[c];
            if (sequence[k2] == 0) {
                bars[pb++] = stripes[0];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[3];
            } else {
                bars[pb++] = stripes[3];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[0];
            }
            ++k2;
        }
        return bars;
    }

    public static byte[] getBarsSupplemental5(String _code) {
        int[] code = new int[5];
        int k = 0;
        while (k < code.length) {
            code[k] = _code.charAt(k) - 48;
            ++k;
        }
        byte[] bars = new byte[31];
        int pb = 0;
        int parity = ((code[0] + code[2] + code[4]) * 3 + (code[1] + code[3]) * 9) % 10;
        bars[pb++] = 1;
        bars[pb++] = 1;
        bars[pb++] = 2;
        byte[] sequence = PARITY5[parity];
        int k2 = 0;
        while (k2 < sequence.length) {
            if (k2 != 0) {
                bars[pb++] = 1;
                bars[pb++] = 1;
            }
            int c = code[k2];
            byte[] stripes = BARS[c];
            if (sequence[k2] == 0) {
                bars[pb++] = stripes[0];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[3];
            } else {
                bars[pb++] = stripes[3];
                bars[pb++] = stripes[2];
                bars[pb++] = stripes[1];
                bars[pb++] = stripes[0];
            }
            ++k2;
        }
        return bars;
    }

    @Override
    public Rectangle getBarcodeSize() {
        float width = 0.0f;
        float height = this.barHeight;
        if (this.font != null) {
            height = this.baseline <= 0.0f ? (height += -this.baseline + this.size) : (height += this.baseline - this.font.getFontDescriptor(3, this.size));
        }
        switch (this.codeType) {
            case 1: {
                width = this.x * 95.0f;
                if (this.font == null) break;
                width += this.font.getWidthPoint(this.code.charAt(0), this.size);
                break;
            }
            case 2: {
                width = this.x * 67.0f;
                break;
            }
            case 3: {
                width = this.x * 95.0f;
                if (this.font == null) break;
                width += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(11), this.size);
                break;
            }
            case 4: {
                width = this.x * 51.0f;
                if (this.font == null) break;
                width += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(7), this.size);
                break;
            }
            case 5: {
                width = this.x * 20.0f;
                break;
            }
            case 6: {
                width = this.x * 47.0f;
                break;
            }
            default: {
                throw new RuntimeException("Invalid code type.");
            }
        }
        return new Rectangle(width, height);
    }

    @Override
    public Rectangle placeBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        Rectangle rect = this.getBarcodeSize();
        float barStartX = 0.0f;
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.font.getFontDescriptor(3, this.size);
                barStartY = textStartY + this.baseline;
            }
        }
        switch (this.codeType) {
            case 1: 
            case 3: 
            case 4: {
                if (this.font == null) break;
                barStartX += this.font.getWidthPoint(this.code.charAt(0), this.size);
            }
        }
        byte[] bars = null;
        int[] guard = GUARD_EMPTY;
        switch (this.codeType) {
            case 1: {
                bars = BarcodeEAN.getBarsEAN13(this.code);
                guard = GUARD_EAN13;
                break;
            }
            case 2: {
                bars = BarcodeEAN.getBarsEAN8(this.code);
                guard = GUARD_EAN8;
                break;
            }
            case 3: {
                bars = BarcodeEAN.getBarsEAN13("0" + this.code);
                guard = GUARD_UPCA;
                break;
            }
            case 4: {
                bars = BarcodeEAN.getBarsUPCE(this.code);
                guard = GUARD_UPCE;
                break;
            }
            case 5: {
                bars = BarcodeEAN.getBarsSupplemental2(this.code);
                break;
            }
            case 6: {
                bars = BarcodeEAN.getBarsSupplemental5(this.code);
            }
        }
        float keepBarX = barStartX;
        boolean print = true;
        float gd = 0.0f;
        if (this.font != null && this.baseline > 0.0f && this.guardBars) {
            gd = this.baseline / 2.0f;
        }
        if (barColor != null) {
            cb.setColorFill(barColor);
        }
        int k = 0;
        while (k < bars.length) {
            float w = (float)bars[k] * this.x;
            if (print) {
                if (Arrays.binarySearch(guard, k) >= 0) {
                    cb.rectangle(barStartX, barStartY - gd, w - this.inkSpreading, this.barHeight + gd);
                } else {
                    cb.rectangle(barStartX, barStartY, w - this.inkSpreading, this.barHeight);
                }
            }
            print = !print;
            barStartX += w;
            ++k;
        }
        cb.fill();
        if (this.font != null) {
            if (textColor != null) {
                cb.setColorFill(textColor);
            }
            cb.beginText();
            cb.setFontAndSize(this.font, this.size);
            switch (this.codeType) {
                case 1: {
                    cb.setTextMatrix(0.0f, textStartY);
                    cb.showText(this.code.substring(0, 1));
                    k = 1;
                    while (k < 13) {
                        String c = this.code.substring(k, k + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = keepBarX + TEXTPOS_EAN13[k - 1] * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k;
                    }
                    break;
                }
                case 2: {
                    k = 0;
                    while (k < 8) {
                        String c = this.code.substring(k, k + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = TEXTPOS_EAN8[k] * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k;
                    }
                    break;
                }
                case 3: {
                    cb.setTextMatrix(0.0f, textStartY);
                    cb.showText(this.code.substring(0, 1));
                    k = 1;
                    while (k < 11) {
                        String c = this.code.substring(k, k + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = keepBarX + TEXTPOS_EAN13[k] * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k;
                    }
                    cb.setTextMatrix(keepBarX + this.x * 95.0f, textStartY);
                    cb.showText(this.code.substring(11, 12));
                    break;
                }
                case 4: {
                    cb.setTextMatrix(0.0f, textStartY);
                    cb.showText(this.code.substring(0, 1));
                    k = 1;
                    while (k < 7) {
                        String c = this.code.substring(k, k + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = keepBarX + TEXTPOS_EAN13[k - 1] * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k;
                    }
                    cb.setTextMatrix(keepBarX + this.x * 51.0f, textStartY);
                    cb.showText(this.code.substring(7, 8));
                    break;
                }
                case 5: 
                case 6: {
                    k = 0;
                    while (k < this.code.length()) {
                        String c = this.code.substring(k, k + 1);
                        float len = this.font.getWidthPoint(c, this.size);
                        float pX = (7.5f + (float)(9 * k)) * this.x - len / 2.0f;
                        cb.setTextMatrix(pX, textStartY);
                        cb.showText(c);
                        ++k;
                    }
                    break;
                }
            }
            cb.endText();
        }
        return rect;
    }
}

