/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.CancellableAsyncTask;
import com.artifex.mupdfdemo.CancellableTaskDefinition;
import com.artifex.mupdfdemo.LinkInfo;
import com.artifex.mupdfdemo.OpaqueImageView;
import com.artifex.mupdfdemo.TextProcessor;
import com.artifex.mupdfdemo.TextSelector;
import com.artifex.mupdfdemo.TextWord;
import com.lonelypluto.pdflibrary.utils.SharedPreferencesUtil;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class PageView
extends ViewGroup {
    private static final float ITEM_SELECT_BOX_WIDTH = 4.0f;
    private static final int HIGHLIGHT_COLOR = -2130749662;
    private int LINK_COLOR = -2130749662;
    private static final int BOX_COLOR = -9868951;
    private int INK_COLOR = -16777216;
    private float INK_THICKNESS = 10.0f;
    private float current_scale;
    private static final int BACKGROUND_COLOR = -1;
    private static final int PROGRESS_DIALOG_DELAY = 200;
    protected final Context mContext;
    protected int mPageNumber;
    private Point mParentSize;
    protected Point mSize;
    protected float mSourceScale;
    private ImageView mEntire;
    private Bitmap mEntireBm;
    private Matrix mEntireMat;
    private AsyncTask<Void, Void, TextWord[][]> mGetText;
    private AsyncTask<Void, Void, LinkInfo[]> mGetLinkInfo;
    private CancellableAsyncTask<Void, Void> mDrawEntire;
    private Point mPatchViewSize;
    private Rect mPatchArea;
    private ImageView mPatch;
    private Bitmap mPatchBm;
    private CancellableAsyncTask<Void, Void> mDrawPatch;
    private RectF[] mSearchBoxes;
    protected LinkInfo[] mLinks;
    private RectF mSelectBox;
    private TextWord[][] mText;
    private RectF mItemSelectBox;
    protected ArrayList<ArrayList<PointF>> mDrawing;
    private View mSearchView;
    private boolean mIsBlank;
    private boolean mHighlightLinks;
    private ProgressBar mBusyIndicator;
    private final Handler mHandler = new Handler();

    public PageView(Context c, Point parentSize, Bitmap sharedHqBm) {
        super(c);
        this.mContext = c;
        this.mParentSize = parentSize;
        this.setBackgroundColor(-1);
        this.mEntireBm = Bitmap.createBitmap((int)parentSize.x, (int)parentSize.y, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mPatchBm = sharedHqBm;
        this.mEntireMat = new Matrix();
    }

    protected abstract CancellableTaskDefinition<Void, Void> getDrawPageTask(Bitmap var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract CancellableTaskDefinition<Void, Void> getUpdatePageTask(Bitmap var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract LinkInfo[] getLinkInfo();

    protected abstract TextWord[][] getText();

    protected abstract void addMarkup(PointF[] var1, Annotation.Type var2);

    private void reinit() {
        if (this.mDrawEntire != null) {
            this.mDrawEntire.cancelAndWait();
            this.mDrawEntire = null;
        }
        if (this.mDrawPatch != null) {
            this.mDrawPatch.cancelAndWait();
            this.mDrawPatch = null;
        }
        if (this.mGetLinkInfo != null) {
            this.mGetLinkInfo.cancel(true);
            this.mGetLinkInfo = null;
        }
        if (this.mGetText != null) {
            this.mGetText.cancel(true);
            this.mGetText = null;
        }
        this.mIsBlank = true;
        this.mPageNumber = 0;
        if (this.mSize == null) {
            this.mSize = this.mParentSize;
        }
        if (this.mEntire != null) {
            this.mEntire.setImageBitmap(null);
            this.mEntire.invalidate();
        }
        if (this.mPatch != null) {
            this.mPatch.setImageBitmap(null);
            this.mPatch.invalidate();
        }
        this.mPatchViewSize = null;
        this.mPatchArea = null;
        this.mSearchBoxes = null;
        this.mLinks = null;
        this.mSelectBox = null;
        this.mText = null;
        this.mItemSelectBox = null;
    }

    public void releaseResources() {
        this.reinit();
        if (this.mBusyIndicator != null) {
            this.removeView((View)this.mBusyIndicator);
            this.mBusyIndicator = null;
        }
    }

    public void releaseBitmaps() {
        this.reinit();
        if (this.mEntireBm != null) {
            this.mEntireBm.recycle();
        }
        this.mEntireBm = null;
        if (this.mPatchBm != null) {
            this.mPatchBm.recycle();
        }
        this.mPatchBm = null;
    }

    public void blank(int page) {
        this.reinit();
        this.mPageNumber = page;
        if (this.mBusyIndicator == null) {
            this.mBusyIndicator = new ProgressBar(this.mContext);
            this.mBusyIndicator.setIndeterminate(true);
            this.addView((View)this.mBusyIndicator);
        }
        this.setBackgroundColor(-1);
    }

    public void setPage(int page, PointF size) {
        if (this.mDrawEntire != null) {
            this.mDrawEntire.cancelAndWait();
            this.mDrawEntire = null;
        }
        this.mIsBlank = false;
        if (this.mSearchView != null) {
            this.mSearchView.invalidate();
        }
        this.mPageNumber = page;
        if (this.mEntire == null) {
            this.mEntire = new OpaqueImageView(this.mContext);
            this.mEntire.setScaleType(ImageView.ScaleType.MATRIX);
            this.addView((View)this.mEntire);
        }
        this.mSourceScale = Math.min((float)this.mParentSize.x / size.x, (float)this.mParentSize.y / size.y);
        this.mSize = new Point((int)(size.x * this.mSourceScale), (int)(size.y * this.mSourceScale));
        this.mEntire.setImageBitmap(null);
        this.mEntire.invalidate();
        this.mGetLinkInfo = new AsyncTask<Void, Void, LinkInfo[]>(){

            protected LinkInfo[] doInBackground(Void ... v) {
                return PageView.this.getLinkInfo();
            }

            protected void onPostExecute(LinkInfo[] v) {
                PageView.this.mLinks = v;
                if (PageView.this.mSearchView != null) {
                    PageView.this.mSearchView.invalidate();
                }
            }
        };
        this.mGetLinkInfo.execute((Object[])new Void[0]);
        this.mDrawEntire = new CancellableAsyncTask<Void, Void>(this.getDrawPageTask(this.mEntireBm, this.mSize.x, this.mSize.y, 0, 0, this.mSize.x, this.mSize.y)){

            @Override
            public void onPreExecute() {
                PageView.this.setBackgroundColor(-1);
                PageView.this.mEntire.setImageBitmap(null);
                PageView.this.mEntire.invalidate();
                if (PageView.this.mBusyIndicator == null) {
                    PageView.this.mBusyIndicator = new ProgressBar(PageView.this.mContext);
                    PageView.this.mBusyIndicator.setIndeterminate(true);
                    PageView.this.addView((View)PageView.this.mBusyIndicator);
                    PageView.this.mBusyIndicator.setVisibility(4);
                    PageView.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (PageView.this.mBusyIndicator != null) {
                                PageView.this.mBusyIndicator.setVisibility(0);
                            }
                        }
                    }, 200L);
                }
            }

            @Override
            public void onPostExecute(Void result) {
                PageView.this.removeView((View)PageView.this.mBusyIndicator);
                PageView.this.mBusyIndicator = null;
                PageView.this.mEntire.setImageBitmap(PageView.this.mEntireBm);
                PageView.this.mEntire.invalidate();
                PageView.this.setBackgroundColor(0);
            }
        };
        this.mDrawEntire.execute((Void[])new Void[0]);
        if (this.mSearchView == null) {
            this.mSearchView = new View(this.mContext){

                protected void onDraw(final Canvas canvas) {
                    super.onDraw(canvas);
                    final float scale = PageView.this.mSourceScale * (float)this.getWidth() / (float)PageView.this.mSize.x;
                    PageView.this.current_scale = scale;
                    final Paint paint = new Paint();
                    if (!PageView.this.mIsBlank && PageView.this.mSearchBoxes != null) {
                        paint.setColor(SharedPreferencesUtil.getSearchTextColor());
                        for (RectF rectF : PageView.this.mSearchBoxes) {
                            canvas.drawRect(rectF.left * scale, rectF.top * scale, rectF.right * scale, rectF.bottom * scale, paint);
                        }
                    }
                    if (!PageView.this.mIsBlank && PageView.this.mLinks != null && PageView.this.mHighlightLinks) {
                        paint.setColor(PageView.this.LINK_COLOR);
                        for (LinkInfo linkInfo : PageView.this.mLinks) {
                            canvas.drawRect(linkInfo.rect.left * scale, linkInfo.rect.top * scale, linkInfo.rect.right * scale, linkInfo.rect.bottom * scale, paint);
                        }
                    }
                    if (PageView.this.mSelectBox != null && PageView.this.mText != null) {
                        paint.setColor(-2130749662);
                        PageView.this.processSelectedText(new TextProcessor(){
                            RectF rect;

                            @Override
                            public void onStartLine() {
                                this.rect = new RectF();
                            }

                            @Override
                            public void onWord(TextWord word) {
                                this.rect.union((RectF)word);
                            }

                            @Override
                            public void onEndLine() {
                                if (!this.rect.isEmpty()) {
                                    canvas.drawRect(this.rect.left * scale, this.rect.top * scale, this.rect.right * scale, this.rect.bottom * scale, paint);
                                }
                            }
                        });
                    }
                    if (PageView.this.mItemSelectBox != null) {
                        paint.setStyle(Paint.Style.STROKE);
                        paint.setStrokeWidth(4.0f);
                        paint.setColor(-9868951);
                        canvas.drawRect(((PageView)PageView.this).mItemSelectBox.left * scale, ((PageView)PageView.this).mItemSelectBox.top * scale, ((PageView)PageView.this).mItemSelectBox.right * scale, ((PageView)PageView.this).mItemSelectBox.bottom * scale, paint);
                    }
                    if (PageView.this.mDrawing != null) {
                        Path path = new Path();
                        paint.setAntiAlias(true);
                        paint.setDither(true);
                        paint.setStrokeJoin(Paint.Join.ROUND);
                        paint.setStrokeCap(Paint.Cap.ROUND);
                        paint.setStyle(Paint.Style.FILL);
                        paint.setStrokeWidth(PageView.this.INK_THICKNESS * scale);
                        paint.setColor(PageView.this.INK_COLOR);
                        for (ArrayList<PointF> arrayList : PageView.this.mDrawing) {
                            PointF p;
                            if (arrayList.size() >= 2) {
                                Iterator<PointF> iit = arrayList.iterator();
                                p = iit.next();
                                float mX = p.x * scale;
                                float mY = p.y * scale;
                                path.moveTo(mX, mY);
                                while (iit.hasNext()) {
                                    p = iit.next();
                                    float x = p.x * scale;
                                    float y = p.y * scale;
                                    path.quadTo(mX, mY, (x + mX) / 2.0f, (y + mY) / 2.0f);
                                    mX = x;
                                    mY = y;
                                }
                                path.lineTo(mX, mY);
                                continue;
                            }
                            p = arrayList.get(0);
                            canvas.drawCircle(p.x * scale, p.y * scale, PageView.this.INK_THICKNESS * scale / 2.0f, paint);
                        }
                        paint.setStyle(Paint.Style.STROKE);
                        canvas.drawPath(path, paint);
                    }
                }
            };
            this.addView(this.mSearchView);
        }
        this.requestLayout();
    }

    public void setSearchBoxes(RectF[] searchBoxes) {
        this.mSearchBoxes = searchBoxes;
        if (this.mSearchView != null) {
            this.mSearchView.invalidate();
        }
    }

    public void setLinkHighlighting(boolean f) {
        this.mHighlightLinks = f;
        if (this.mSearchView != null) {
            this.mSearchView.invalidate();
        }
    }

    public void setLinkHighlightColor(int color2) {
        this.LINK_COLOR = color2;
        if (this.mHighlightLinks && this.mSearchView != null) {
            this.mSearchView.invalidate();
        }
    }

    public void deselectText() {
        this.mSelectBox = null;
        this.mSearchView.invalidate();
    }

    public void selectText(float x0, float y0, float x1, float y1) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX0 = (x0 - (float)this.getLeft()) / scale;
        float docRelY0 = (y0 - (float)this.getTop()) / scale;
        float docRelX1 = (x1 - (float)this.getLeft()) / scale;
        float docRelY1 = (y1 - (float)this.getTop()) / scale;
        this.mSelectBox = docRelY0 <= docRelY1 ? new RectF(docRelX0, docRelY0, docRelX1, docRelY1) : new RectF(docRelX1, docRelY1, docRelX0, docRelY0);
        this.mSearchView.invalidate();
        if (this.mGetText == null) {
            this.mGetText = new AsyncTask<Void, Void, TextWord[][]>(){

                protected TextWord[][] doInBackground(Void ... params) {
                    return PageView.this.getText();
                }

                protected void onPostExecute(TextWord[][] result) {
                    PageView.access$1102(PageView.this, result);
                    PageView.this.mSearchView.invalidate();
                }
            };
            this.mGetText.execute((Object[])new Void[0]);
        }
    }

    public void startDraw(float x, float y) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX = (x - (float)this.getLeft()) / scale;
        float docRelY = (y - (float)this.getTop()) / scale;
        if (this.mDrawing == null) {
            this.mDrawing = new ArrayList();
        }
        ArrayList<PointF> arc = new ArrayList<PointF>();
        arc.add(new PointF(docRelX, docRelY));
        this.mDrawing.add(arc);
        this.mSearchView.invalidate();
    }

    public void continueDraw(float x, float y) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX = (x - (float)this.getLeft()) / scale;
        float docRelY = (y - (float)this.getTop()) / scale;
        if (this.mDrawing != null && this.mDrawing.size() > 0) {
            ArrayList<PointF> arc = this.mDrawing.get(this.mDrawing.size() - 1);
            arc.add(new PointF(docRelX, docRelY));
            this.mSearchView.invalidate();
        }
    }

    public void cancelDraw() {
        this.mDrawing = null;
        this.mSearchView.invalidate();
    }

    protected PointF[][] getDraw() {
        if (this.mDrawing == null) {
            return null;
        }
        PointF[][] path = new PointF[this.mDrawing.size()][];
        for (int i = 0; i < this.mDrawing.size(); ++i) {
            ArrayList<PointF> arc = this.mDrawing.get(i);
            path[i] = arc.toArray(new PointF[arc.size()]);
        }
        return path;
    }

    public void setInkColor(int color2) {
        this.INK_COLOR = color2;
    }

    public void setPaintStrockWidth(float inkThickness) {
        this.INK_THICKNESS = inkThickness;
    }

    protected float getInkThickness() {
        if (this.current_scale == 0.0f) {
            return 4.537815f;
        }
        return this.INK_THICKNESS * this.current_scale / 2.0f;
    }

    public float getCurrentScale() {
        if (this.current_scale == 0.0f) {
            return 9.07563f;
        }
        return this.current_scale;
    }

    protected float[] getColor() {
        return this.changeColor(this.INK_COLOR);
    }

    private float[] changeColor(int color2) {
        int red = (color2 & 0xFF0000) >> 16;
        int green = (color2 & 0xFF00) >> 8;
        int blue = color2 & 0xFF;
        float[] colors = new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
        return colors;
    }

    protected void processSelectedText(TextProcessor tp) {
        new TextSelector(this.mText, this.mSelectBox).select(tp);
    }

    public void setItemSelectBox(RectF rect) {
        this.mItemSelectBox = rect;
        if (this.mSearchView != null) {
            this.mSearchView.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int y;
        int x;
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case 0: {
                x = this.mSize.x;
                break;
            }
            default: {
                x = View.MeasureSpec.getSize((int)widthMeasureSpec);
            }
        }
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case 0: {
                y = this.mSize.y;
                break;
            }
            default: {
                y = View.MeasureSpec.getSize((int)heightMeasureSpec);
            }
        }
        this.setMeasuredDimension(x, y);
        if (this.mBusyIndicator != null) {
            int limit = Math.min(this.mParentSize.x, this.mParentSize.y) / 2;
            this.mBusyIndicator.measure(Integer.MIN_VALUE | limit, Integer.MIN_VALUE | limit);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int w = right - left;
        int h = bottom - top;
        if (this.mEntire != null) {
            if (this.mEntire.getWidth() != w || this.mEntire.getHeight() != h) {
                this.mEntireMat.setScale((float)w / (float)this.mSize.x, (float)h / (float)this.mSize.y);
                this.mEntire.setImageMatrix(this.mEntireMat);
                this.mEntire.invalidate();
            }
            this.mEntire.layout(0, 0, w, h);
        }
        if (this.mSearchView != null) {
            this.mSearchView.layout(0, 0, w, h);
        }
        if (this.mPatchViewSize != null) {
            if (this.mPatchViewSize.x != w || this.mPatchViewSize.y != h) {
                this.mPatchViewSize = null;
                this.mPatchArea = null;
                if (this.mPatch != null) {
                    this.mPatch.setImageBitmap(null);
                    this.mPatch.invalidate();
                }
            } else {
                this.mPatch.layout(this.mPatchArea.left, this.mPatchArea.top, this.mPatchArea.right, this.mPatchArea.bottom);
            }
        }
        if (this.mBusyIndicator != null) {
            int bw = this.mBusyIndicator.getMeasuredWidth();
            int bh = this.mBusyIndicator.getMeasuredHeight();
            this.mBusyIndicator.layout((w - bw) / 2, (h - bh) / 2, (w + bw) / 2, (h + bh) / 2);
        }
    }

    public void updateHq(boolean update) {
        Rect viewArea = new Rect(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
        if (viewArea.width() == this.mSize.x || viewArea.height() == this.mSize.y) {
            if (this.mPatch != null) {
                this.mPatch.setImageBitmap(null);
                this.mPatch.invalidate();
            }
        } else {
            boolean completeRedraw;
            boolean area_unchanged;
            final Point patchViewSize = new Point(viewArea.width(), viewArea.height());
            final Rect patchArea = new Rect(0, 0, this.mParentSize.x, this.mParentSize.y);
            if (!patchArea.intersect(viewArea)) {
                return;
            }
            patchArea.offset(-viewArea.left, -viewArea.top);
            boolean bl = area_unchanged = patchArea.equals((Object)this.mPatchArea) && patchViewSize.equals((Object)this.mPatchViewSize);
            if (area_unchanged && !update) {
                return;
            }
            boolean bl2 = completeRedraw = !area_unchanged;
            if (this.mDrawPatch != null) {
                this.mDrawPatch.cancelAndWait();
                this.mDrawPatch = null;
            }
            if (this.mPatch == null) {
                this.mPatch = new OpaqueImageView(this.mContext);
                this.mPatch.setScaleType(ImageView.ScaleType.MATRIX);
                this.addView((View)this.mPatch);
                this.mSearchView.bringToFront();
            }
            CancellableTaskDefinition<Void, Void> task = completeRedraw ? this.getDrawPageTask(this.mPatchBm, patchViewSize.x, patchViewSize.y, patchArea.left, patchArea.top, patchArea.width(), patchArea.height()) : this.getUpdatePageTask(this.mPatchBm, patchViewSize.x, patchViewSize.y, patchArea.left, patchArea.top, patchArea.width(), patchArea.height());
            this.mDrawPatch = new CancellableAsyncTask<Void, Void>(task){

                @Override
                public void onPostExecute(Void result) {
                    PageView.this.mPatchViewSize = patchViewSize;
                    PageView.this.mPatchArea = patchArea;
                    PageView.this.mPatch.setImageBitmap(PageView.this.mPatchBm);
                    PageView.this.mPatch.invalidate();
                    PageView.this.mPatch.layout(((PageView)PageView.this).mPatchArea.left, ((PageView)PageView.this).mPatchArea.top, ((PageView)PageView.this).mPatchArea.right, ((PageView)PageView.this).mPatchArea.bottom);
                }
            };
            this.mDrawPatch.execute((Void[])new Void[0]);
        }
    }

    public void update() {
        if (this.mDrawEntire != null) {
            this.mDrawEntire.cancelAndWait();
            this.mDrawEntire = null;
        }
        if (this.mDrawPatch != null) {
            this.mDrawPatch.cancelAndWait();
            this.mDrawPatch = null;
        }
        this.mDrawEntire = new CancellableAsyncTask<Void, Void>(this.getUpdatePageTask(this.mEntireBm, this.mSize.x, this.mSize.y, 0, 0, this.mSize.x, this.mSize.y)){

            @Override
            public void onPostExecute(Void result) {
                PageView.this.mEntire.setImageBitmap(PageView.this.mEntireBm);
                PageView.this.mEntire.invalidate();
            }
        };
        this.mDrawEntire.execute((Void[])new Void[0]);
        this.updateHq(true);
    }

    public void removeHq() {
        if (this.mDrawPatch != null) {
            this.mDrawPatch.cancelAndWait();
            this.mDrawPatch = null;
        }
        this.mPatchViewSize = null;
        this.mPatchArea = null;
        if (this.mPatch != null) {
            this.mPatch.setImageBitmap(null);
            this.mPatch.invalidate();
        }
    }

    public int getPage() {
        return this.mPageNumber;
    }

    public boolean isOpaque() {
        return true;
    }

    static /* synthetic */ TextWord[][] access$1102(PageView x0, TextWord[][] x1) {
        x0.mText = x1;
        return x1;
    }
}

