/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.Log;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.LinkInfo;
import com.artifex.mupdfdemo.MuPDFAlert;
import com.artifex.mupdfdemo.MuPDFAlertInternal;
import com.artifex.mupdfdemo.OutlineItem;
import com.artifex.mupdfdemo.PassClickResult;
import com.artifex.mupdfdemo.PassClickResultChoice;
import com.artifex.mupdfdemo.PassClickResultSignature;
import com.artifex.mupdfdemo.PassClickResultText;
import com.artifex.mupdfdemo.Separation;
import com.artifex.mupdfdemo.TextChar;
import com.artifex.mupdfdemo.TextWord;
import com.artifex.mupdfdemo.WidgetType;
import com.lonelypluto.pdflibrary.R;
import java.util.ArrayList;

public class MuPDFCore {
    private static final String TAG = MuPDFCore.class.getSimpleName();
    private static boolean gs_so_available = false;
    private int numPages = -1;
    private float pageWidth;
    private float pageHeight;
    private long globals;
    private byte[] fileBuffer;
    private String file_format;
    private boolean isUnencryptedPDF;
    private final boolean wasOpenedFromBuffer;

    private static native boolean gprfSupportedInternal();

    private native long openFile(String var1);

    private native long openBuffer(String var1);

    private native String fileFormatInternal();

    private native boolean isUnencryptedPDFInternal();

    private native int countPagesInternal();

    private native void gotoPageInternal(int var1);

    private native float getPageWidth();

    private native float getPageHeight();

    private native void drawPage(Bitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    private native void updatePageInternal(Bitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    private native RectF[] searchPage(String var1);

    private native TextChar[][][][] text();

    private native byte[] textAsHtml();

    private native void addMarkupAnnotationInternal(PointF[] var1, int var2);

    private native void addInkAnnotationInternal(PointF[][] var1, float var2, float var3, float var4, float var5);

    private native void deleteAnnotationInternal(int var1);

    private native int passClickEventInternal(int var1, float var2, float var3);

    private native void setFocusedWidgetChoiceSelectedInternal(String[] var1);

    private native String[] getFocusedWidgetChoiceSelected();

    private native String[] getFocusedWidgetChoiceOptions();

    private native int getFocusedWidgetSignatureState();

    private native String checkFocusedSignatureInternal();

    private native boolean signFocusedSignatureInternal(String var1, String var2);

    private native int setFocusedWidgetTextInternal(String var1);

    private native String getFocusedWidgetTextInternal();

    private native int getFocusedWidgetTypeInternal();

    private native LinkInfo[] getPageLinksInternal(int var1);

    private native RectF[] getWidgetAreasInternal(int var1);

    private native Annotation[] getAnnotationsInternal(int var1);

    private native OutlineItem[] getOutlineInternal();

    private native boolean hasOutlineInternal();

    private native boolean needsPasswordInternal();

    private native boolean authenticatePasswordInternal(String var1);

    private native MuPDFAlertInternal waitForAlertInternal();

    private native void replyToAlertInternal(MuPDFAlertInternal var1);

    private native void startAlertsInternal();

    private native void stopAlertsInternal();

    private native void destroying();

    private native boolean hasChangesInternal();

    private native void saveInternal();

    private native long createCookie();

    private native void destroyCookie(long var1);

    private native void abortCookie(long var1);

    private native String startProofInternal(int var1);

    private native void endProofInternal(String var1);

    private native int getNumSepsOnPageInternal(int var1);

    private native int controlSepOnPageInternal(int var1, int var2, boolean var3);

    private native Separation getSepInternal(int var1, int var2);

    public native boolean javascriptSupported();

    public MuPDFCore(Context context, String filename) throws Exception {
        this.globals = this.openFile(filename);
        if (this.globals == 0L) {
            throw new Exception(String.format(context.getString(R.string.cannot_open_file_Path), filename));
        }
        this.file_format = this.fileFormatInternal();
        this.isUnencryptedPDF = this.isUnencryptedPDFInternal();
        this.wasOpenedFromBuffer = false;
    }

    public MuPDFCore(Context context, byte[] buffer, String magic) throws Exception {
        this.fileBuffer = buffer;
        this.globals = this.openBuffer(magic != null ? magic : "");
        if (this.globals == 0L) {
            throw new Exception(context.getString(R.string.cannot_open_buffer));
        }
        this.file_format = this.fileFormatInternal();
        this.isUnencryptedPDF = this.isUnencryptedPDFInternal();
        this.wasOpenedFromBuffer = true;
    }

    public int countPages() {
        if (this.numPages < 0) {
            this.numPages = this.countPagesSynchronized();
        }
        return this.numPages;
    }

    public String fileFormat() {
        return this.file_format;
    }

    public boolean isUnencryptedPDF() {
        return this.isUnencryptedPDF;
    }

    public boolean wasOpenedFromBuffer() {
        return this.wasOpenedFromBuffer;
    }

    private synchronized int countPagesSynchronized() {
        return this.countPagesInternal();
    }

    private void gotoPage(int page) {
        if (page > this.numPages - 1) {
            page = this.numPages - 1;
        } else if (page < 0) {
            page = 0;
        }
        this.gotoPageInternal(page);
        this.pageWidth = this.getPageWidth();
        this.pageHeight = this.getPageHeight();
    }

    public synchronized PointF getPageSize(int page) {
        this.gotoPage(page);
        return new PointF(this.pageWidth, this.pageHeight);
    }

    public MuPDFAlert waitForAlert() {
        MuPDFAlertInternal alert = this.waitForAlertInternal();
        return alert != null ? alert.toAlert() : null;
    }

    public void replyToAlert(MuPDFAlert alert) {
        this.replyToAlertInternal(new MuPDFAlertInternal(alert));
    }

    public void stopAlerts() {
        this.stopAlertsInternal();
    }

    public void startAlerts() {
        this.startAlertsInternal();
    }

    public synchronized void onDestroy() {
        this.destroying();
        this.globals = 0L;
    }

    public synchronized void drawPage(Bitmap bm, int page, int pageW, int pageH, int patchX, int patchY, int patchW, int patchH, Cookie cookie) {
        this.gotoPage(page);
        this.drawPage(bm, pageW, pageH, patchX, patchY, patchW, patchH, cookie.cookiePtr);
    }

    public synchronized void updatePage(Bitmap bm, int page, int pageW, int pageH, int patchX, int patchY, int patchW, int patchH, Cookie cookie) {
        this.updatePageInternal(bm, page, pageW, pageH, patchX, patchY, patchW, patchH, cookie.cookiePtr);
    }

    public synchronized PassClickResult passClickEvent(int page, float x, float y) {
        boolean changed = this.passClickEventInternal(page, x, y) != 0;
        switch (WidgetType.values()[this.getFocusedWidgetTypeInternal()]) {
            case TEXT: {
                return new PassClickResultText(changed, this.getFocusedWidgetTextInternal());
            }
            case LISTBOX: 
            case COMBOBOX: {
                return new PassClickResultChoice(changed, this.getFocusedWidgetChoiceOptions(), this.getFocusedWidgetChoiceSelected());
            }
            case SIGNATURE: {
                return new PassClickResultSignature(changed, this.getFocusedWidgetSignatureState());
            }
        }
        return new PassClickResult(changed);
    }

    public synchronized boolean setFocusedWidgetText(int page, String text) {
        this.gotoPage(page);
        boolean success = this.setFocusedWidgetTextInternal(text) != 0;
        return success;
    }

    public synchronized void setFocusedWidgetChoiceSelected(String[] selected) {
        this.setFocusedWidgetChoiceSelectedInternal(selected);
    }

    public synchronized String checkFocusedSignature() {
        return this.checkFocusedSignatureInternal();
    }

    public synchronized boolean signFocusedSignature(String keyFile, String password) {
        return this.signFocusedSignatureInternal(keyFile, password);
    }

    public synchronized LinkInfo[] getPageLinks(int page) {
        return this.getPageLinksInternal(page);
    }

    public synchronized RectF[] getWidgetAreas(int page) {
        return this.getWidgetAreasInternal(page);
    }

    public synchronized Annotation[] getAnnoations(int page) {
        return this.getAnnotationsInternal(page);
    }

    public synchronized RectF[] searchPage(int page, String text) {
        this.gotoPage(page);
        return this.searchPage(text);
    }

    public synchronized byte[] html(int page) {
        this.gotoPage(page);
        return this.textAsHtml();
    }

    public synchronized TextWord[][] textLines(int page) {
        this.gotoPage(page);
        TextChar[][][][] chars = this.text();
        ArrayList<TextWord[]> lns = new ArrayList<TextWord[]>();
        for (TextChar[][][] bl : chars) {
            if (bl == null) continue;
            for (TextChar[][] ln : bl) {
                ArrayList<TextWord> wds = new ArrayList<TextWord>();
                TextWord wd = new TextWord();
                TextChar[][] textCharArray = ln;
                int n = textCharArray.length;
                for (int i = 0; i < n; ++i) {
                    TextChar[] sp;
                    for (TextChar tc : sp = textCharArray[i]) {
                        if (tc.c != ' ') {
                            wd.Add(tc);
                            continue;
                        }
                        if (wd.w.length() <= 0) continue;
                        wds.add(wd);
                        wd = new TextWord();
                    }
                }
                if (wd.w.length() > 0) {
                    wds.add(wd);
                }
                if (wds.size() <= 0) continue;
                lns.add(wds.toArray(new TextWord[wds.size()]));
            }
        }
        return (TextWord[][])lns.toArray((T[])new TextWord[lns.size()][]);
    }

    public synchronized void addMarkupAnnotation(int page, PointF[] quadPoints, Annotation.Type type) {
        this.gotoPage(page);
        this.addMarkupAnnotationInternal(quadPoints, type.ordinal());
    }

    public synchronized void addInkAnnotation(int page, PointF[][] arcs, float[] color, float inkThickness) {
        this.gotoPage(page);
        Log.e((String)"zyw", (String)("color = " + color[0] + " " + color[1] + " " + color[2]));
        this.addInkAnnotationInternal(arcs, color[0], color[1], color[2], inkThickness);
    }

    public synchronized void deleteAnnotation(int page, int annot_index) {
        this.gotoPage(page);
        this.deleteAnnotationInternal(annot_index);
    }

    public synchronized boolean hasOutline() {
        return this.hasOutlineInternal();
    }

    public synchronized OutlineItem[] getOutline() {
        return this.getOutlineInternal();
    }

    public synchronized boolean needsPassword() {
        return this.needsPasswordInternal();
    }

    public synchronized boolean authenticatePassword(String password) {
        return this.authenticatePasswordInternal(password);
    }

    public synchronized boolean hasChanges() {
        return this.hasChangesInternal();
    }

    public synchronized void save() {
        this.saveInternal();
    }

    public synchronized String startProof(int resolution) {
        return this.startProofInternal(resolution);
    }

    public synchronized void endProof(String filename) {
        this.endProofInternal(filename);
    }

    public static boolean gprfSupported() {
        return gs_so_available && MuPDFCore.gprfSupportedInternal();
    }

    public boolean canProof() {
        String format = this.fileFormat();
        return format.contains("PDF");
    }

    public synchronized int getNumSepsOnPage(int page) {
        return this.getNumSepsOnPageInternal(page);
    }

    public synchronized int controlSepOnPage(int page, int sep, boolean disable) {
        return this.controlSepOnPageInternal(page, sep, disable);
    }

    public synchronized Separation getSep(int page, int sep) {
        return this.getSepInternal(page, sep);
    }

    static {
        Log.e((String)TAG, (String)"Loading dll");
        System.loadLibrary("mupdf_java");
        Log.e((String)TAG, (String)"Loaded dll");
    }

    public class Cookie {
        private final long cookiePtr;

        public Cookie() {
            this.cookiePtr = MuPDFCore.this.createCookie();
            if (this.cookiePtr == 0L) {
                throw new OutOfMemoryError();
            }
        }

        public void abort() {
            MuPDFCore.this.abortCookie(this.cookiePtr);
        }

        public void destroy() {
            MuPDFCore.this.destroyCookie(this.cookiePtr);
        }
    }
}

