/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo.widget;

import android.content.Context;
import android.graphics.Point;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class VDHDeepLayout
extends RelativeLayout {
    private ViewDragHelper mViewDragHelper;
    private View mDragView;
    private Point mAutoBackOriginPos = new Point();

    public VDHDeepLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mViewDragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)new ViewDragHelper.Callback(){

            public boolean tryCaptureView(View child, int pointerId) {
                return child == VDHDeepLayout.this.mDragView;
            }

            public int clampViewPositionHorizontal(View child, int left, int dx) {
                int leftBound = VDHDeepLayout.this.getPaddingLeft();
                int rightBound = VDHDeepLayout.this.getWidth() - VDHDeepLayout.this.mDragView.getWidth() - leftBound;
                int newLeft = Math.min(Math.max(left, leftBound), rightBound);
                return newLeft;
            }

            public int clampViewPositionVertical(View child, int top, int dy) {
                int topBound = VDHDeepLayout.this.getPaddingTop();
                int bottomBound = VDHDeepLayout.this.getHeight() - VDHDeepLayout.this.mDragView.getHeight() - topBound;
                int newTop = Math.min(Math.max(top, topBound), bottomBound);
                return newTop;
            }

            public void onViewReleased(View releasedChild, float xvel, float yvel) {
                super.onViewReleased(releasedChild, xvel, yvel);
            }

            public void onEdgeDragStarted(int edgeFlags, int pointerId) {
                super.onEdgeDragStarted(edgeFlags, pointerId);
            }

            public int getViewHorizontalDragRange(View child) {
                return VDHDeepLayout.this.getMeasuredWidth() - child.getMeasuredWidth();
            }

            public int getViewVerticalDragRange(View child) {
                return VDHDeepLayout.this.getMeasuredHeight() - child.getMeasuredHeight();
            }
        });
        this.mViewDragHelper.setEdgeTrackingEnabled(2);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mViewDragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mViewDragHelper.processTouchEvent(event);
        return true;
    }

    public void computeScroll() {
        if (this.mViewDragHelper.continueSettling(true)) {
            this.invalidate();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mAutoBackOriginPos.x = this.mDragView.getLeft();
        this.mAutoBackOriginPos.y = this.mDragView.getTop();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mDragView = this.getChildAt(0);
    }
}

