/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.tsp.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import repack.org.bouncycastle.asn1.BERConstructedOctetString;
import repack.org.bouncycastle.asn1.DERIA5String;
import repack.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import repack.org.bouncycastle.asn1.cms.ContentInfo;
import repack.org.bouncycastle.asn1.cms.Evidence;
import repack.org.bouncycastle.asn1.cms.TimeStampAndCRL;
import repack.org.bouncycastle.asn1.cms.TimeStampTokenEvidence;
import repack.org.bouncycastle.asn1.cms.TimeStampedData;
import repack.org.bouncycastle.cms.CMSException;
import repack.org.bouncycastle.tsp.TimeStampToken;
import repack.org.bouncycastle.tsp.cms.CMSTimeStampedData;
import repack.org.bouncycastle.tsp.cms.CMSTimeStampedGenerator;
import repack.org.bouncycastle.util.io.Streams;

public class CMSTimeStampedDataGenerator
extends CMSTimeStampedGenerator {
    public CMSTimeStampedData generate(TimeStampToken timeStamp) throws CMSException {
        return this.generate(timeStamp, (InputStream)null);
    }

    public CMSTimeStampedData generate(TimeStampToken timeStamp, byte[] content) throws CMSException {
        return this.generate(timeStamp, new ByteArrayInputStream(content));
    }

    public CMSTimeStampedData generate(TimeStampToken timeStamp, InputStream content) throws CMSException {
        ByteArrayOutputStream contentOut = new ByteArrayOutputStream();
        if (content != null) {
            try {
                Streams.pipeAll(content, contentOut);
            }
            catch (IOException e) {
                throw new CMSException("exception encapsulating content: " + e.getMessage(), e);
            }
        }
        BERConstructedOctetString encContent = null;
        if (contentOut.size() != 0) {
            encContent = new BERConstructedOctetString(contentOut.toByteArray());
        }
        TimeStampAndCRL stamp = new TimeStampAndCRL(timeStamp.toCMSSignedData().getContentInfo());
        DERIA5String asn1DataUri = null;
        if (this.dataUri != null) {
            asn1DataUri = new DERIA5String(this.dataUri.toString());
        }
        return new CMSTimeStampedData(new ContentInfo(CMSObjectIdentifiers.timestampedData, new TimeStampedData(asn1DataUri, this.metaData, encContent, new Evidence(new TimeStampTokenEvidence(stamp)))));
    }
}

