/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;
import repack.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import repack.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import repack.org.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import repack.org.bouncycastle.crypto.generators.DHParametersGenerator;
import repack.org.bouncycastle.crypto.generators.DSAKeyPairGenerator;
import repack.org.bouncycastle.crypto.generators.DSAParametersGenerator;
import repack.org.bouncycastle.crypto.generators.ElGamalKeyPairGenerator;
import repack.org.bouncycastle.crypto.generators.ElGamalParametersGenerator;
import repack.org.bouncycastle.crypto.generators.GOST3410KeyPairGenerator;
import repack.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import repack.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import repack.org.bouncycastle.crypto.params.DHParameters;
import repack.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import repack.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import repack.org.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import repack.org.bouncycastle.crypto.params.DSAParameters;
import repack.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import repack.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import repack.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import repack.org.bouncycastle.crypto.params.ElGamalParameters;
import repack.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import repack.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import repack.org.bouncycastle.crypto.params.GOST3410KeyGenerationParameters;
import repack.org.bouncycastle.crypto.params.GOST3410Parameters;
import repack.org.bouncycastle.crypto.params.GOST3410PrivateKeyParameters;
import repack.org.bouncycastle.crypto.params.GOST3410PublicKeyParameters;
import repack.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import repack.org.bouncycastle.crypto.params.RSAKeyParameters;
import repack.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import repack.org.bouncycastle.jce.provider.JCEDHPrivateKey;
import repack.org.bouncycastle.jce.provider.JCEDHPublicKey;
import repack.org.bouncycastle.jce.provider.JCEElGamalPrivateKey;
import repack.org.bouncycastle.jce.provider.JCEElGamalPublicKey;
import repack.org.bouncycastle.jce.provider.JCERSAPrivateCrtKey;
import repack.org.bouncycastle.jce.provider.JCERSAPublicKey;
import repack.org.bouncycastle.jce.provider.JDKDSAPrivateKey;
import repack.org.bouncycastle.jce.provider.JDKDSAPublicKey;
import repack.org.bouncycastle.jce.provider.JDKGOST3410PrivateKey;
import repack.org.bouncycastle.jce.provider.JDKGOST3410PublicKey;
import repack.org.bouncycastle.jce.spec.ElGamalParameterSpec;
import repack.org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import repack.org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;

public abstract class JDKKeyPairGenerator
extends KeyPairGenerator {
    public JDKKeyPairGenerator(String algorithmName) {
        super(algorithmName);
    }

    @Override
    public abstract void initialize(int var1, SecureRandom var2);

    @Override
    public abstract KeyPair generateKeyPair();

    public static class DH
    extends JDKKeyPairGenerator {
        private static Hashtable params = new Hashtable();
        DHKeyGenerationParameters param;
        DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DH() {
            super("DH");
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
            }
            DHParameterSpec dhParams = (DHParameterSpec)params;
            this.param = new DHKeyGenerationParameters(random, new DHParameters(dhParams.getP(), dhParams.getG(), null, dhParams.getL()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                Integer paramStrength = new Integer(this.strength);
                if (params.containsKey(paramStrength)) {
                    this.param = (DHKeyGenerationParameters)params.get(paramStrength);
                } else {
                    DHParametersGenerator pGen = new DHParametersGenerator();
                    pGen.init(this.strength, this.certainty, this.random);
                    this.param = new DHKeyGenerationParameters(this.random, pGen.generateParameters());
                    params.put(paramStrength, this.param);
                }
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            DHPublicKeyParameters pub = (DHPublicKeyParameters)pair.getPublic();
            DHPrivateKeyParameters priv = (DHPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JCEDHPublicKey(pub), new JCEDHPrivateKey(priv));
        }
    }

    public static class DSA
    extends JDKKeyPairGenerator {
        DSAKeyGenerationParameters param;
        DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DSA() {
            super("DSA");
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            if (strength < 512 || strength > 1024 || strength % 64 != 0) {
                throw new InvalidParameterException("strength must be from 512 - 1024 and a multiple of 64");
            }
            this.strength = strength;
            this.random = random;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
            }
            DSAParameterSpec dsaParams = (DSAParameterSpec)params;
            this.param = new DSAKeyGenerationParameters(random, new DSAParameters(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                DSAParametersGenerator pGen = new DSAParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new DSAKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            DSAPublicKeyParameters pub = (DSAPublicKeyParameters)pair.getPublic();
            DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JDKDSAPublicKey(pub), new JDKDSAPrivateKey(priv));
        }
    }

    public static class ElGamal
    extends JDKKeyPairGenerator {
        ElGamalKeyGenerationParameters param;
        ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public ElGamal() {
            super("ElGamal");
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof ElGamalParameterSpec) && !(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
            }
            if (params instanceof ElGamalParameterSpec) {
                ElGamalParameterSpec elParams = (ElGamalParameterSpec)params;
                this.param = new ElGamalKeyGenerationParameters(random, new ElGamalParameters(elParams.getP(), elParams.getG()));
            } else {
                DHParameterSpec dhParams = (DHParameterSpec)params;
                this.param = new ElGamalKeyGenerationParameters(random, new ElGamalParameters(dhParams.getP(), dhParams.getG(), dhParams.getL()));
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                ElGamalParametersGenerator pGen = new ElGamalParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ElGamalPublicKeyParameters pub = (ElGamalPublicKeyParameters)pair.getPublic();
            ElGamalPrivateKeyParameters priv = (ElGamalPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JCEElGamalPublicKey(pub), new JCEElGamalPrivateKey(priv));
        }
    }

    public static class GOST3410
    extends JDKKeyPairGenerator {
        GOST3410KeyGenerationParameters param;
        GOST3410KeyPairGenerator engine = new GOST3410KeyPairGenerator();
        GOST3410ParameterSpec gost3410Params;
        int strength = 1024;
        SecureRandom random = null;
        boolean initialised = false;

        public GOST3410() {
            super("GOST3410");
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        private void init(GOST3410ParameterSpec gParams, SecureRandom random) {
            GOST3410PublicKeyParameterSetSpec spec = gParams.getPublicKeyParameters();
            this.param = new GOST3410KeyGenerationParameters(random, new GOST3410Parameters(spec.getP(), spec.getQ(), spec.getA()));
            this.engine.init(this.param);
            this.initialised = true;
            this.gost3410Params = gParams;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof GOST3410ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a GOST3410ParameterSpec");
            }
            this.init((GOST3410ParameterSpec)params, random);
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.init(new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId()), new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            GOST3410PublicKeyParameters pub = (GOST3410PublicKeyParameters)pair.getPublic();
            GOST3410PrivateKeyParameters priv = (GOST3410PrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JDKGOST3410PublicKey(pub, this.gost3410Params), new JDKGOST3410PrivateKey(priv, this.gost3410Params));
        }
    }

    public static class RSA
    extends JDKKeyPairGenerator {
        static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        static final int defaultTests = 12;
        RSAKeyGenerationParameters param;
        RSAKeyPairGenerator engine = new RSAKeyPairGenerator();

        public RSA() {
            super("RSA");
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), 2048, 12);
            this.engine.init(this.param);
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, random, strength, 12);
            this.engine.init(this.param);
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
            }
            RSAKeyGenParameterSpec rsaParams = (RSAKeyGenParameterSpec)params;
            this.param = new RSAKeyGenerationParameters(rsaParams.getPublicExponent(), random, rsaParams.getKeysize(), 12);
            this.engine.init(this.param);
        }

        @Override
        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            RSAKeyParameters pub = (RSAKeyParameters)pair.getPublic();
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)pair.getPrivate();
            return new KeyPair(new JCERSAPublicKey(pub), new JCERSAPrivateCrtKey(priv));
        }
    }
}

