/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cms.jcajce;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import repack.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import repack.org.bouncycastle.cms.CMSAttributeTableGenerator;
import repack.org.bouncycastle.cms.SignerInfoGenerator;
import repack.org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import repack.org.bouncycastle.operator.ContentSigner;
import repack.org.bouncycastle.operator.DigestCalculatorProvider;
import repack.org.bouncycastle.operator.OperatorCreationException;

public class JcaSignerInfoGeneratorBuilder
extends SignerInfoGeneratorBuilder {
    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider) {
        super(digestProvider);
    }

    @Override
    public SignerInfoGeneratorBuilder setDirectSignature(boolean hasNoSignedAttributes) {
        super.setDirectSignature(hasNoSignedAttributes);
        return this;
    }

    @Override
    public SignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator signedGen) {
        super.setSignedAttributeGenerator(signedGen);
        return this;
    }

    @Override
    public SignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator unsignedGen) {
        super.setUnsignedAttributeGenerator(unsignedGen);
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509Certificate certificate) throws OperatorCreationException, CertificateEncodingException {
        return super.build(contentSigner, new JcaX509CertificateHolder(certificate));
    }
}

