/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import repack.org.bouncycastle.asn1.DEREncodable;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.cms.AuthAttributesProvider;
import repack.org.bouncycastle.cms.CMSEnvelopedHelper;
import repack.org.bouncycastle.cms.CMSException;
import repack.org.bouncycastle.cms.CMSReadable;
import repack.org.bouncycastle.cms.CMSSecureReadable;
import repack.org.bouncycastle.cms.CMSTypedStream;
import repack.org.bouncycastle.cms.CMSUtils;
import repack.org.bouncycastle.cms.Recipient;
import repack.org.bouncycastle.cms.RecipientId;
import repack.org.bouncycastle.cms.RecipientOperator;
import repack.org.bouncycastle.util.io.Streams;

public abstract class RecipientInformation {
    protected RecipientId rid;
    protected AlgorithmIdentifier keyEncAlg;
    protected AlgorithmIdentifier messageAlgorithm;
    private CMSSecureReadable secureReadable;
    private AuthAttributesProvider additionalData;
    private byte[] resultMac;
    private RecipientOperator operator;

    RecipientInformation(AlgorithmIdentifier keyEncAlg, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        this.keyEncAlg = keyEncAlg;
        this.messageAlgorithm = messageAlgorithm;
        this.secureReadable = secureReadable;
        this.additionalData = additionalData;
    }

    String getContentAlgorithmName() {
        AlgorithmIdentifier algorithm = this.secureReadable.getAlgorithm();
        return CMSEnvelopedHelper.INSTANCE.getSymmetricCipherName(algorithm.getObjectId().getId());
    }

    public RecipientId getRID() {
        return this.rid;
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            return obj.getDERObject().getEncoded();
        }
        return null;
    }

    public String getKeyEncryptionAlgOID() {
        return this.keyEncAlg.getObjectId().getId();
    }

    public byte[] getKeyEncryptionAlgParams() {
        try {
            return this.encodeObj(this.keyEncAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AlgorithmParameters getKeyEncryptionAlgorithmParameters(String provider) throws CMSException, NoSuchProviderException {
        return this.getKeyEncryptionAlgorithmParameters(CMSUtils.getProvider(provider));
    }

    public AlgorithmParameters getKeyEncryptionAlgorithmParameters(Provider provider) throws CMSException {
        byte[] enc;
        block4: {
            enc = this.encodeObj(this.keyEncAlg.getParameters());
            if (enc != null) break block4;
            return null;
        }
        try {
            AlgorithmParameters params = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameters(this.getKeyEncryptionAlgOID(), provider);
            params.init(enc, "ASN.1");
            return params;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find parameters for algorithm", e);
        }
        catch (IOException e) {
            throw new CMSException("can't find parse parameters", e);
        }
    }

    protected CMSTypedStream getContentFromSessionKey(Key sKey, Provider provider) throws CMSException {
        CMSReadable readable = this.secureReadable.getReadable((SecretKey)sKey, provider);
        try {
            return new CMSTypedStream(readable.getInputStream());
        }
        catch (IOException e) {
            throw new CMSException("error getting .", e);
        }
    }

    public byte[] getContent(Key key, String provider) throws CMSException, NoSuchProviderException {
        return this.getContent(key, CMSUtils.getProvider(provider));
    }

    public byte[] getContent(Key key, Provider provider) throws CMSException {
        try {
            return CMSUtils.streamToByteArray(this.getContentStream(key, provider).getContentStream());
        }
        catch (IOException e) {
            throw new RuntimeException("unable to parse internal stream: " + e);
        }
    }

    public byte[] getContentDigest() {
        if (this.secureReadable instanceof CMSEnvelopedHelper.CMSDigestAuthenticatedSecureReadable) {
            return ((CMSEnvelopedHelper.CMSDigestAuthenticatedSecureReadable)this.secureReadable).getDigest();
        }
        return null;
    }

    public byte[] getMac() {
        if (this.resultMac == null) {
            if (this.operator != null) {
                if (this.operator.isMacBased()) {
                    if (this.additionalData != null) {
                        try {
                            Streams.drain(this.operator.getInputStream(new ByteArrayInputStream(this.additionalData.getAuthAttributes().getDEREncoded())));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.resultMac = this.operator.getMac();
                }
            } else {
                Object cryptoObject = this.secureReadable.getCryptoObject();
                if (cryptoObject instanceof Mac) {
                    this.resultMac = ((Mac)cryptoObject).doFinal();
                }
            }
        }
        return this.resultMac;
    }

    public byte[] getContent(Recipient recipient) throws CMSException {
        try {
            return CMSUtils.streamToByteArray(this.getContentStream(recipient).getContentStream());
        }
        catch (IOException e) {
            throw new CMSException("unable to parse internal stream: " + e.getMessage(), e);
        }
    }

    public CMSTypedStream getContentStream(Key key, String provider) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(provider));
    }

    public abstract CMSTypedStream getContentStream(Key var1, Provider var2) throws CMSException;

    public CMSTypedStream getContentStream(Recipient recipient) throws CMSException, IOException {
        this.operator = this.getRecipientOperator(recipient);
        if (this.additionalData != null) {
            return new CMSTypedStream(this.secureReadable.getInputStream());
        }
        return new CMSTypedStream(this.operator.getInputStream(this.secureReadable.getInputStream()));
    }

    protected abstract RecipientOperator getRecipientOperator(Recipient var1) throws CMSException, IOException;
}

