/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cms;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import repack.org.bouncycastle.asn1.cms.KEKIdentifier;
import repack.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import repack.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import repack.org.bouncycastle.cms.AuthAttributesProvider;
import repack.org.bouncycastle.cms.CMSEnvelopedHelper;
import repack.org.bouncycastle.cms.CMSException;
import repack.org.bouncycastle.cms.CMSSecureReadable;
import repack.org.bouncycastle.cms.CMSTypedStream;
import repack.org.bouncycastle.cms.CMSUtils;
import repack.org.bouncycastle.cms.KEKRecipient;
import repack.org.bouncycastle.cms.KEKRecipientId;
import repack.org.bouncycastle.cms.Recipient;
import repack.org.bouncycastle.cms.RecipientInformation;
import repack.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        super(info.getKeyEncryptionAlgorithm(), messageAlgorithm, secureReadable, additionalData);
        this.info = info;
        KEKIdentifier kekId = info.getKekid();
        this.rid = new KEKRecipientId(kekId.getKeyIdentifier().getOctets());
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(prov));
    }

    @Override
    public CMSTypedStream getContentStream(Key key, Provider prov) throws CMSException {
        try {
            Cipher keyCipher = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(this.keyEncAlg.getObjectId().getId(), prov);
            keyCipher.init(4, key);
            Key sKey = keyCipher.unwrap(this.info.getEncryptedKey().getOctets(), this.getContentAlgorithmName(), 3);
            return this.getContentFromSessionKey(sKey, prov);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", e);
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

