/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.cert;

import java.math.BigInteger;
import java.util.Date;
import repack.org.bouncycastle.asn1.ASN1Encodable;
import repack.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import repack.org.bouncycastle.asn1.DERInteger;
import repack.org.bouncycastle.asn1.DERObjectIdentifier;
import repack.org.bouncycastle.asn1.x500.X500Name;
import repack.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import repack.org.bouncycastle.asn1.x509.Time;
import repack.org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import repack.org.bouncycastle.asn1.x509.X509CertificateStructure;
import repack.org.bouncycastle.asn1.x509.X509Extension;
import repack.org.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import repack.org.bouncycastle.cert.CertUtils;
import repack.org.bouncycastle.cert.X509CertificateHolder;
import repack.org.bouncycastle.operator.ContentSigner;

public class X509v3CertificateBuilder {
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private X509ExtensionsGenerator extGenerator;

    public X509v3CertificateBuilder(X500Name issuer, BigInteger serial, Date notBefore, Date notAfter, X500Name subject, SubjectPublicKeyInfo publicKeyInfo) {
        this.tbsGen.setSerialNumber(new DERInteger(serial));
        this.tbsGen.setIssuer(issuer);
        this.tbsGen.setStartDate(new Time(notBefore));
        this.tbsGen.setEndDate(new Time(notAfter));
        this.tbsGen.setSubject(subject);
        this.tbsGen.setSubjectPublicKeyInfo(publicKeyInfo);
        this.extGenerator = new X509ExtensionsGenerator();
    }

    public X509v3CertificateBuilder setSubjectUniqueID(boolean[] uniqueID) {
        this.tbsGen.setSubjectUniqueID(CertUtils.booleanToBitString(uniqueID));
        return this;
    }

    public X509v3CertificateBuilder setIssuerUniqueID(boolean[] uniqueID) {
        this.tbsGen.setIssuerUniqueID(CertUtils.booleanToBitString(uniqueID));
        return this;
    }

    public X509v3CertificateBuilder addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) {
        this.extGenerator.addExtension((DERObjectIdentifier)oid, isCritical, value);
        return this;
    }

    public X509v3CertificateBuilder copyAndAddExtension(ASN1ObjectIdentifier oid, boolean isCritical, X509CertificateHolder certHolder) {
        X509CertificateStructure cert = certHolder.toASN1Structure();
        X509Extension extension = cert.getTBSCertificate().getExtensions().getExtension(oid);
        if (extension == null) {
            throw new NullPointerException("extension " + oid + " not present");
        }
        this.extGenerator.addExtension((DERObjectIdentifier)oid, isCritical, extension.getValue().getOctets());
        return this;
    }

    public X509CertificateHolder build(ContentSigner signer) {
        this.tbsGen.setSignature(signer.getAlgorithmIdentifier());
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        return CertUtils.generateFullCert(signer, this.tbsGen.generateTBSCertificate());
    }
}

