/*
 * Decompiled with CFR 0.152.
 */
package repack.org.bouncycastle.asn1.cmp;

import repack.org.bouncycastle.asn1.ASN1Encodable;
import repack.org.bouncycastle.asn1.ASN1EncodableVector;
import repack.org.bouncycastle.asn1.ASN1Sequence;
import repack.org.bouncycastle.asn1.DERObject;
import repack.org.bouncycastle.asn1.DERSequence;
import repack.org.bouncycastle.asn1.cmp.InfoTypeAndValue;

public class GenMsgContent
extends ASN1Encodable {
    private ASN1Sequence content;

    private GenMsgContent(ASN1Sequence seq) {
        this.content = seq;
    }

    public static GenMsgContent getInstance(Object o) {
        if (o instanceof GenMsgContent) {
            return (GenMsgContent)o;
        }
        if (o instanceof ASN1Sequence) {
            return new GenMsgContent((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    public GenMsgContent(InfoTypeAndValue itv) {
        this.content = new DERSequence(itv);
    }

    public GenMsgContent(InfoTypeAndValue[] itv) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < itv.length) {
            v.add(itv[i]);
            ++i;
        }
        this.content = new DERSequence(v);
    }

    public InfoTypeAndValue[] toInfoTypeAndValueArray() {
        InfoTypeAndValue[] result = new InfoTypeAndValue[this.content.size()];
        int i = 0;
        while (i != result.length) {
            result[i] = InfoTypeAndValue.getInstance(this.content.getObjectAt(i));
            ++i;
        }
        return result;
    }

    @Override
    public DERObject toASN1Object() {
        return this.content;
    }
}

